class Grenade_Frag extends CSSWeapons;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=GrenadeFragMesh MODELFILE=ModelsSkeletal\Grenades\GrenadeFrag\GrenadeFragMesh.psk
#exec MESH ORIGIN MESH=GrenadeFragMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=GrenadeFragFirstPick ANIVFILE=MODELS\Grenades\GrenadeFrag\GrenadeFragFirstPick_a.3d DATAFILE=MODELS\Grenades\GrenadeFrag\GrenadeFragFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GrenadeFragFirstPick X=0 Y=-60 Z=24.5

//3rd Person
#exec MESH IMPORT MESH=GrenadeFragFirst3rd ANIVFILE=MODELS\Grenades\GrenadeFrag\GrenadeFragFirst3rd_a.3d DATAFILE=MODELS\Grenades\GrenadeFrag\GrenadeFragFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GrenadeFragFirst3rd X=0 Y=7 Z=-5 Yaw=64

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=GrenadeFragMeshAnims ANIMFILE=ModelsSkeletal\Grenades\GrenadeFrag\GrenadeFragMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=98
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=22
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=Still STARTFRAME=23 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=PullPin STARTFRAME=33 NUMFRAMES=40
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=Throw STARTFRAME=74 NUMFRAMES=24

#exec ANIM DIGEST ANIM=GrenadeFragMeshAnims
#exec MESH DEFAULTANIM MESH=GrenadeFragMesh ANIM=GrenadeFragMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=GrenadeFragFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GrenadeFragFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=GrenadeFragFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GrenadeFragFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=GrenadeFragMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=GrenadeFragFirstPick MESH=GrenadeFragFirstPick
#exec MESHMAP SCALE MESHMAP=GrenadeFragFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=GrenadeFragFirst3rd MESH=GrenadeFragFirst3rd
#exec MESHMAP SCALE MESHMAP=GrenadeFragFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin00 FILE=Textures\Grenades\GrenadeFrag\GrenadeFragBody.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=GrenadeFragBodyPick FILE=Textures\Grenades\GrenadeFrag\GrenadeFragBodyPick.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragBody3rd FILE=Textures\Grenades\GrenadeFrag\GrenadeFrag3rd.bmp GROUP=GrenadeFrag LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=0 TEXTURE=GrenadeFragMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=1 TEXTURE=GrenadeFragMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=2 TEXTURE=GrenadeFragMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=3 TEXTURE=GrenadeFragMeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragFirstPick NUM=1 TEXTURE=GrenadeFragBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragFirst3rd NUM=1 TEXTURE=GrenadeFragBody3rd

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="GrenadeFragPinPull" FILE=Sounds\Grenades\GrenadeFrag\FragPinPull.wav GROUP="GrenadeFrag"

//=========================================================================================

#exec TEXTURE IMPORT NAME=GFragIcon FILE=Textures\Icons\GrenadeFragIcon.bmp GROUP=GrenadeFrag MIPS=OFF

//=========================================================================================

var(CSSWeapons) vector ThrowOffset;

simulated function PostRender(Canvas C)
{
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return AIRating;
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.9, 0.04);
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'PullMe')
		PlayPullPin();
	else if(EventType == 'ThrowMe')
		PlayThrow();
	else if(EventType == 'SelectMe')
		PlaySelection();
}

simulated function PlayPullPin()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('PullPin', 1.0, 0.04);
	}
}

simulated function PlayThrow()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Throw', 1.0, 0.04);
	}	
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 0.9, 0.04);
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(AmmoType.UseAmmo(1))
	{
		bPointing=True;
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);
		bCanClientFire = True;
		ClientFire(Value);
		GoToState('NormalFire');
	}
}

Function AltFire(float Value)
{
	Pawn(Owner).bAltFire = 0;
}

state NormalFire
{
	ignores Fire, AltFire;

Begin:
	PlayAnim('PullPin', 1.0, 0.04);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('PullMe');
	Sleep(0.3);
	Owner.PlaySound(Misc1Sound);
	//FinishAnim();
	Sleep(0.5);
	PlayAnim('Throw', 1.0, 0.04);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('ThrowMe');
	Sleep(0.4);
	SpawnGrenade(1100);
	//FinishAnim();
	Sleep(0.2);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('SelectMe');
	PlayAnim('Select', 0.9, 0.04);
	//FinishAnim();
	//GoTostate('Idle');
}

simulated function SpawnGrenade( float grenadeSpeed )
{
	Local Grenade_FragProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CSSCalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn(class'Grenade_FragProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
}

state Idle
{
	Begin:
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
}

defaultproperties
{
	ThrowOffset=(Y=7.000000)
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CSSWeapons.GrenadeFrag.GrenadeFragPinPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    PickupAmmoCount=2
    AmmoName=Class'CSSWeapons.AmmoGrenade_Frag'
    FireOffset=(X=0.00,Y=0.000000,Z=0.00),
	AIRating=0.180000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bSplashDamage=True
    bRecommendSplashDamage=True
    bWarnTarget=True
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a HE Grenade."
    ItemName="HE Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=17.00
    PlayerViewMesh=SkeletalMesh'CSSWeapons.GrenadeFragMesh'
    PickupViewMesh=LodMesh'CSSWeapons.GrenadeFragFirstPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CSSWeapons.GrenadeFragFirst3rd'
    ThirdPersonScale=2.50
    Mesh=LodMesh'CSSWeapons.GrenadeFragFirstPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CSSWeapons.GrenadeFrag.GFragIcon'
    StatusIcon=Texture'CSSWeapons.GrenadeFrag.GFragIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}