class Grenade_FlashProj extends Grenade_FragProj;

#exec AUDIO IMPORT NAME="GrenadeFlashExplode" FILE=Sounds\Grenades\GrenadeFlash\FlashExplode.wav GROUP="GrenadeFlash"

//Credits: Wormbo
simulated function Explosion(vector HitLocation)
{
	local Pawn Victims;
	local float Distance, Direction, ScaledRadius;
	local Vector dir;
	local CSSFlashBlindEffect FlashEffect;
	
	if ( bHurtEntry )
		return;

	if ( Level.NetMode != NM_DedicatedServer )
	{
		Spawn(class'BlastMark',,,,rot(16384,0,0));
		Spawn(Class'Grenade_FlashLightEffect',,,Location,rot(0,0,0));
	}

	For (Victims = Level.PawnList; Victims != None; Victims = Victims.NextPawn) {
		dir = Victims.Location + vect(0,0,1) * Victims.EyeHeight;
		if ( (Victims.bIsPlayer || !Victims.IsA('StationaryPawn')) && FastTrace(HitLocation, dir) ) {
			dir = HitLocation - dir;
			Distance = VSize(dir);
			Direction = vector(Victims.ViewRotation) dot Normal(dir);
			
			if ( Instigator != None )
				Distance /= Instigator.DamageScaling;
			if ( Instigator.IsA('Bot') && Bot(Instigator).bNovice )
				Distance *= 0.1;
			
			if ( Victims.bIsPlayer ) {
				if ( Instigator.bIsPlayer
						&& Instigator.PlayerReplicationInfo.Team == Victims.PlayerReplicationInfo.Team )
					Distance *= 0.1;
				else if ( Instigator.IsA('StationaryPawn')
						&& StationaryPawn(Instigator).SameTeamAs(Victims.PlayerReplicationInfo.Team) )
					Distance *= 0.1;
			}
			
			FlashEffect = Spawn(class'CSSFlashBlindEffect', Victims);
			if ( FlashEffect != None ) {
				FlashEffect.GiveTo(Victims);
				FlashEffect.SetBlinding(Direction, Distance);
			}
		} 
	}

	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(Sound'GrenadeFlashExplode',,3.0,,2200);

	Destroy();
}

simulated function Tick(float DeltaTime);

defaultproperties
{
	speed=150.000000
	MaxSpeed=2000.000000
	Damage=0.000000
	MomentumTransfer=0
	bUnlit=False
	AmbientGlow=0
	Physics=PHYS_Falling
	ImpactSound=Sound'CSSWeapons.GrenadeSmoke.GrenadeSmokeBounce'
	Mesh=LodMesh'CSSWeapons.GrenadeFlashFirstPick'
	DrawScale=2.000000
	RemoteRole=ROLE_SimulatedProxy
	bBounce=True
	LODBias=20.000000
    bFixedRotationDir=True
    DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
	CollisionRadius=6.000000
	CollisionHeight=7.000000
}