class Grenade_Flash extends Grenade_Frag;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=GrenadeFlashMesh MODELFILE=ModelsSkeletal\Grenades\GrenadeSmoke\GrenadeFlashMesh.psk
#exec MESH ORIGIN MESH=GrenadeFlashMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=GrenadeFlashFirstPick ANIVFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirstPick_a.3d DATAFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirstPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GrenadeFlashFirstPick X=0 Y=-60 Z=25.5

//3rd Person
#exec MESH IMPORT MESH=GrenadeFlashFirst3rd ANIVFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirst3rd_a.3d DATAFILE=MODELS\Grenades\GrenadeSmoke\GrenadeFlashFirst3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GrenadeFlashFirst3rd X=0 Y=7 Z=-5 Yaw=64

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=GrenadeFlashMeshAnims ANIMFILE=ModelsSkeletal\Grenades\GrenadeSmoke\GrenadeFlashMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=98
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=22
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=Still STARTFRAME=23 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=PullPin STARTFRAME=33 NUMFRAMES=40
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=Throw STARTFRAME=74 NUMFRAMES=24

#exec ANIM DIGEST ANIM=GrenadeFlashMeshAnims
#exec MESH DEFAULTANIM MESH=GrenadeFlashMesh ANIM=GrenadeFlashMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=GrenadeFlashFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GrenadeFlashFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=GrenadeFlashFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GrenadeFlashFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=GrenadeFlashMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=GrenadeFlashFirstPick MESH=GrenadeFlashFirstPick
#exec MESHMAP SCALE MESHMAP=GrenadeFlashFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=GrenadeFlashFirst3rd MESH=GrenadeFlashFirst3rd
#exec MESHMAP SCALE MESHMAP=GrenadeFlashFirst3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin00 FILE=Textures\Grenades\GrenadeFlash\GrenadeFlashBody.bmp GROUP=GrenadeFlash LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin01 FILE=Textures\Generic\M3Arm.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin02 FILE=Textures\Generic\M3Gloves.bmp GROUP=Generic LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin03 FILE=Textures\Generic\M3Thumbs.bmp GROUP=Generic LODSET=2

#exec TEXTURE IMPORT NAME=GrenadeFlashBodyPick FILE=Textures\Grenades\GrenadeFlash\GrenadeFlashBodyPick.bmp GROUP=GrenadeFlash LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=0 TEXTURE=GrenadeFlashMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=1 TEXTURE=GrenadeFlashMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=2 TEXTURE=GrenadeFlashMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=3 TEXTURE=GrenadeFlashMeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashFirstPick NUM=1 TEXTURE=GrenadeFlashBodyPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashFirst3rd NUM=1 TEXTURE=GrenadeFlashBodyPick

//=========================================================================================

#exec TEXTURE IMPORT NAME=GFlashIcon FILE=Textures\Icons\GrenadeFlashIcon.bmp GROUP=GrenadeFlash MIPS=OFF

//=========================================================================================

simulated function SpawnGrenade( float grenadeSpeed )
{
	Local Grenade_FlashProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CSSCalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn(class'Grenade_FlashProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
}

defaultproperties
{
	ThrowOffset=(Y=7.000000)
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CSSWeapons.GrenadeFrag.GrenadeFragPinPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    PickupAmmoCount=2
    AmmoName=Class'CSSWeapons.AmmoGrenade_Flash'
    FireOffset=(X=0.00,Y=0.000000,Z=0.00),
	AIRating=0.170000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bSplashDamage=True
    bRecommendSplashDamage=True
    bWarnTarget=True
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a Flash Grenade."
    ItemName="Flash Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=17.00
    PlayerViewMesh=SkeletalMesh'CSSWeapons.GrenadeFlashMesh'
    PickupViewMesh=LodMesh'CSSWeapons.GrenadeFlashFirstPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CSSWeapons.GrenadeFlashFirst3rd'
    ThirdPersonScale=2.50
    Mesh=LodMesh'CSSWeapons.GrenadeFlashFirstPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CSSWeapons.GrenadeFlash.GFlashIcon'
    StatusIcon=Texture'CSSWeapons.GrenadeFlash.GFlashIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}