class CSSSettingsMenuPage extends UMenuPageWindow;

var UWindowCheckbox bRecoil, bAmbientAll, bRandPistols, bRandPistolsReplace, bRandSGReplace, bRandRiflesReplace, bRandSMGReplace, bRandSniperReplace, bCross, bPenetrate, boldRep;
var UWindowComboControl GunPickupSound, AmmoPickupSound;
var UWindowLabelControl Note, Note2;
var string RealKeyName[255];
var UMenuLabelControl  lblKeyBind;
var UMenuLabelControl  lblMenuKey;
var UMenuRaisedButton  ButMenuKey;
var string OldMenuKey;
var bool   bMenu;

var UWindowSmallButton Close;

function Created()
{
	Super.Created();

	bRecoil = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 20, WinWidth - 30, 1));
	bRecoil.bAcceptsFocus=False;
	bRecoil.SetText("Enable Recoil");
	bRecoil.SetHelpText("If checked, weapon plays recoil.");
	bRecoil.SetFont(F_Normal);
	bRecoil.Align=TA_Left;
	bRecoil.bChecked=Class'CSSMutator'.default.bEnableRecoil;

	bAmbientAll = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 40, WinWidth - 30, 1));
	bAmbientAll.bAcceptsFocus=False;
	bAmbientAll.SetText("Ambient Glow on weapons/pickups/ammo");
	bAmbientAll.SetHelpText("If checked, sometimes it is difficult to find the weapons in dark corners.");
	bAmbientAll.SetFont(F_Normal);
	bAmbientAll.Align=TA_Left;
	bAmbientAll.bChecked=Class'CSSMutator'.default.bAllAmbientGlow;

	bCross = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 60, WinWidth - 30, 1));
	bCross.bAcceptsFocus=False;
	bCross.SetText("Enable Crosshair");
	bCross.SetHelpText("If checked, crosshair will be shown else not.");
	bCross.SetFont(F_Normal);
	bCross.Align=TA_Left;
	bCross.bChecked=Class'CSSMutator'.default.bEnableCrosshair;

	bRandPistols = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 80, WinWidth - 30, 1));
	bRandPistols.bAcceptsFocus=False;
	bRandPistols.SetText("Respawn with random pistols");
	bRandPistols.SetHelpText("If checked, players will respawn with random pistols.");
	bRandPistols.SetFont(F_Normal);
	bRandPistols.Align=TA_Left;
	bRandPistols.bChecked=Class'CSSMutator'.default.bRespawnWithRandomPistols;
	
	bRandPistolsReplace = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 100, WinWidth - 30, 1));
	bRandPistolsReplace.bAcceptsFocus=False;
	bRandPistolsReplace.SetText("Pistols random replacement");
	bRandPistolsReplace.SetHelpText("If checked, random pistols will be spawned in maps instead of enforcer.");
	bRandPistolsReplace.SetFont(F_Normal);
	bRandPistolsReplace.Align=TA_Left;
	bRandPistolsReplace.bChecked=Class'CSSMutator'.default.bRandomPistolReplacement;
	
	bRandSGReplace = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 120, WinWidth - 30, 1));
	bRandSGReplace.bAcceptsFocus=False;
	bRandSGReplace.SetText("Shotguns random replacement");
	bRandSGReplace.SetHelpText("If checked, random Shotguns will be spawned instead of Bio Rifle.");
	bRandSGReplace.SetFont(F_Normal);
	bRandSGReplace.Align=TA_Left;
	bRandSGReplace.bChecked=Class'CSSMutator'.default.bRandomShotgunReplacement;

	bRandSMGReplace = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 140, WinWidth - 30, 1));
	bRandSMGReplace.bAcceptsFocus=False;
	bRandSMGReplace.SetText("SMG random replacement");
	bRandSMGReplace.SetHelpText("If checked, random SMG will be spawned in maps instead of Shock Rifle.");
	bRandSMGReplace.SetFont(F_Normal);
	bRandSMGReplace.Align=TA_Left;
	bRandSMGReplace.bChecked=Class'CSSMutator'.default.bRandomSMGReplacement;

	bRandRiflesReplace = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 160, WinWidth - 30, 1));
	bRandRiflesReplace.bAcceptsFocus=False;
	bRandRiflesReplace.SetText("Rifles random replacement");
	bRandRiflesReplace.SetHelpText("If checked, random Rifles will be spawned in maps");
	bRandRiflesReplace.SetFont(F_Normal);
	bRandRiflesReplace.Align=TA_Left;
	bRandRiflesReplace.bChecked=Class'CSSMutator'.default.bRandomRiflesReplacement;

	bRandSniperReplace = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 180, WinWidth - 30, 1));
	bRandSniperReplace.bAcceptsFocus=False;
	bRandSniperReplace.SetText("Sniper Rifles random replacement");
	bRandSniperReplace.SetHelpText("If checked, random Sniper Rifles will be spawned in maps instead of Sniper Rifle");
	bRandSniperReplace.SetFont(F_Normal);
	bRandSniperReplace.Align=TA_Left;
	bRandSniperReplace.bChecked=Class'CSSMutator'.default.bRandomSniperReplacement;

	boldRep = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 200, WinWidth - 30, 1));
	boldRep.bAcceptsFocus=False;
	boldRep.SetText("Replace OldSkool weapons and items");
	boldRep.SetHelpText("If checked, replaces oldskool weapons and items");
	boldRep.SetFont(F_Normal);
	boldRep.Align=TA_Left;
	boldRep.bChecked=Class'CSSMutator'.default.bReplaceOldSkoolWeapons;

	lblMenuKey = UMenuLabelControl(CreateControl(class'UMenuLabelControl',10, 220, WinWidth - 30, 1));
	lblMenuKey.SetText("Reload Bind Key");
	lblMenuKey.SetFont(F_Normal);

	ButMenuKey = UMenuRaisedButton(CreateControl(class'UMenuRaisedButton', WinWidth - 100, 220, 80.0,35.0));
	ButMenuKey.bAcceptsFocus = False;
	ButMenuKey.Align=TA_Center;
	ButMenuKey.bIgnoreLDoubleClick = True;
	ButMenuKey.bIgnoreMDoubleClick = True;
	ButMenuKey.bIgnoreRDoubleClick = True;

	bPenetrate = UWindowCheckbox(CreateControl(Class'UWindowCheckbox',10, 245, WinWidth - 30, 1));
	bPenetrate.bAcceptsFocus=False;
	bPenetrate.SetText("Bodies/Wall penetration");
	bPenetrate.SetHelpText("If checked, Bullets will penetrate through walls and players");
	bPenetrate.SetFont(F_Normal);
	bPenetrate.Align=TA_Left;
	bPenetrate.bChecked=Class'CSSMutator'.default.bBulletPenetration;

	GunPickupSound = UWindowComboControl(CreateControl(class'UWindowComboControl', 10, 265, WinWidth - 30, 1));
	GunPickupSound.bAcceptsFocus = False;
   	GunPickupSound.SetFont(F_Normal);
   	GunPickupSound.EditBoxWidth = 75;
   	GunPickupSound.AddItem("CS Style", "0");
   	GunPickupSound.AddItem("Default (UT)", "1");
   	GunPickupSound.SetHelpText("Select which type of Pickup sound to play when picking up a weapon");
   	GunPickupSound.SetSelectedIndex(class'CSSMutator'.default.GunPickupSoundType);
   	GunPickupSound.SetEditable(False);
   	GunPickupSound.Text = "Guns Pickup Sound type";

   	AmmoPickupSound = UWindowComboControl(CreateControl(class'UWindowComboControl', 10, 285, WinWidth - 30, 1));
	AmmoPickupSound.bAcceptsFocus = False;
   	AmmoPickupSound.SetFont(F_Normal);
   	AmmoPickupSound.EditBoxWidth = 75;
   	AmmoPickupSound.AddItem("CS Style", "0");
   	AmmoPickupSound.AddItem("Default (UT)", "1");
   	AmmoPickupSound.SetHelpText("Select which type of Pickup sound to play when picking up an ammo");
   	AmmoPickupSound.SetSelectedIndex(class'CSSMutator'.default.AmmoPickupSoundType);
   	AmmoPickupSound.SetEditable(False);
   	AmmoPickupSound.Text = "Ammo Pickup Sound type";

   	Note = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 10, 315, 270, 1));
	Note.Align = TA_Left;
	Note.SetText("Note: Not all settings are present here.");

	Note2 = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 10, 335, 270, 1));
	Note2.Align = TA_Left;
	Note2.SetText("Please check the configuration (.ini) file for other settings.");

   	Close = UWindowSmallButton(CreateControl(class'UWindowSmallButton', WinWidth - 100,WinHeight - 50,80.0,35.0));
    Close.SetText("Close");
    Close.DownSound = Sound'WindowClose';
    Close.NotifyWindow = Self;

    LoadExistingKeys();
	SetAcceptsFocus();
}

function Notify(UWindowDialogControl C, byte E)
{
	Super.Notify(C,E);

	switch(E) 
	{
		case DE_Change: 
			switch(C) 
			{
				case bRecoil:
					if(bRecoil != None)
					{
						class'CSSMutator'.default.bEnableRecoil = bRecoil.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bAmbientAll:
					if(bAmbientAll != None)
					{
						class'CSSMutator'.default.bAllAmbientGlow = bAmbientAll.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bCross:
					if(bCross != None)
					{
						class'CSSMutator'.default.bEnableCrosshair = bCross.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bRandPistols:
					if(bRandPistols != None)
					{
						class'CSSMutator'.default.bRespawnWithRandomPistols = bRandPistols.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bRandPistolsReplace:
					if(bRandPistolsReplace != None)
					{
						class'CSSMutator'.default.bRandomPistolReplacement = bRandPistolsReplace.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bRandSGReplace:
					if(bRandSGReplace != None)
					{
						class'CSSMutator'.default.bRandomShotgunReplacement = bRandSGReplace.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bRandSMGReplace:
					if(bRandSMGReplace != None)
					{
						class'CSSMutator'.default.bRandomSMGReplacement = bRandSMGReplace.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bRandRiflesReplace:
					if(bRandRiflesReplace != None)
					{
						class'CSSMutator'.default.bRandomRiflesReplacement = bRandRiflesReplace.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bRandSniperReplace:
					if(bRandSniperReplace != None)
					{
						class'CSSMutator'.default.bRandomSniperReplacement = bRandSniperReplace.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case boldRep:
					if(boldRep != None)
					{
						class'CSSMutator'.default.bReplaceOldSkoolWeapons = boldRep.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case bPenetrate:
					if(bPenetrate != None)
					{
						class'CSSMutator'.default.bBulletPenetration = bPenetrate.bChecked;
						class'CSSMutator'.static.StaticSaveConfig();
					}
					break;
				case GunPickupSound:
					if(GunPickupSound != None)
					{
               			class'CSSMutator'.default.GunPickupSoundType=Byte(GunPickupSound.GetValue2());
               			class'CSSMutator'.static.StaticSaveConfig();
               		}
               		break;
               	case AmmoPickupSound:
					if(AmmoPickupSound != None)
					{
               			class'CSSMutator'.default.AmmoPickupSoundType=Byte(AmmoPickupSound.GetValue2());
               			class'CSSMutator'.static.StaticSaveConfig();
               		}
               		break;
               	}
               	break;

               	case DE_Click:
					switch(C)
			        {
			        	case ButMenuKey:
			   				if(ButMenuKey != None)
			   				{
		    					bMenu = True;
		        				ButMenuKey.bDisabled = True;
		        			}
		        			break;

					 	case Close:
					 		if(Close != None)
					 		{
					 			Class'CSSMutator'.static.StaticSaveConfig();
								SaveConfig();
			               		ParentWindow.ParentWindow.Close();
			               	}
			               	break;
			        }
		    break;
        }
       	Super.Notify(C,E);
}

function LoadExistingKeys ()
{
	local int i;
	local string KeyName, Alias;

	i=0;
JL0007:
	if ( i < 255 )
	{
		KeyName=GetPlayerOwner().ConsoleCommand("KEYNAME " $ string(i));
		RealKeyName[i]=KeyName;
		if ( KeyName != "" )
		{
			Alias=GetPlayerOwner().ConsoleCommand("KEYBINDING " $ KeyName);
			if ( Caps(Alias) == "MUTATE CSSRELOAD" )
			{
				ButMenuKey.SetText(KeyName);
				OldMenuKey = KeyName;
			}
		}
		i++;
		goto JL0007;
	}
}

function KeyDown( int Key, float X, float Y )
{
   ProcessKey(Key, RealKeyName[Key]);

   bMenu = False;
   ButMenuKey.bDisabled = False;

   lblKeyBind.SetText("");
   ParentWindow.KeyDown(Key,X,Y);
}

function ProcessKey( int KeyNo, string KeyName )
{
    if ( KeyName == "" || KeyName == "Escape" || KeyNo >= 112 && KeyNo <= 117 || KeyNo >= 120 && KeyNo <= 123 || KeyNo >= 48 && KeyNo <= 57 )
	{
		return;
	}

    if (bMenu)
    {
    	SetMenuKey(KeyNo, KeyName);
       	return;
    }
}

function SetMenuKey(int KeyNo, string KeyName)
{
   GetPlayerOwner().ConsoleCommand("SET Input "$KeyName$" mutate cssreload");
   ButMenuKey.SetText(KeyName);
   if(OldMenuKey != "" && OldMenuKey != KeyName)
   {
      GetPlayerOwner().ConsoleCommand("SET Input "$OldMenuKey);
   }
}

defaultproperties
{
}