//Straight away taken from XPickups. Thanks FeraliDragon
class CSSPickupCharger extends Inventory;

var() class<Inventory> PickupClass;	//Pickup class to spawn
var() float BeginDelayTime;		//Time to wait after the begin of the game to spawn the pickup
var() vector SpawnOffset;		//Offset to spawn the pickup (NOT RELATIVE TO BASE ROTATION!)
var() bool bRotPickup;			//bRotationPickup equivalent
var() rotator PickupRotOffset;		//Pickup start rotation offset
var() float PickupRespawnTime;		//Custom respawn time
var() bool bAutoAlignPickup;		//Align pickup rotation to the charger rotation
var(Triggering) bool bSpawnTriggered;	//Trigger First Spawn
var(Triggering) bool bTriggerToggle;	//Activate or deactivate pickup
var(Triggering) name CollectedEvent;	//Collected Event
var(Triggering) name SpawnEvent;	//Spawn Event
var(Triggering) bool bSpawnEventOnce;	//Spawn Event only at first spawn?
var(Triggering) float RetriggerWaitTime;//Time to wait until next triggered spawn, set to 0 to make the pickup charger triggerable only once
var(Triggering) bool bTriggeredMachine; //Trigger a spawn of a pickup, but like if the pickup was a soda xD (once picked up, it won't respawn until you trigger this again)

var(PickupParticles) bool bStay;	//When True, particles will stay even when the Pickup is there

var(WildCard) bool bRandom;
var(WildCard) Class<Inventory> RandomPickups[16];
var(WildCard) float RandRespawnTime;			//Static respawn time
var(WildCard) bool bUseRandomRespawnTime;
var(WildCard) float RandRespawnTimeMin;
var(WildCard) float RandRespawnTimeMax;

var(Weapons) bool bWeaponStay;	//Only for weapons
var(Weapons) bool bNeverStays;	//Set this for super weapons

var(SinglePlayer) bool bSPMode;

var CSSPickupBase MarkedPick;
var bool bForceRot;


function PostBeginPlay()
{
}

//Deco base and particle handling
function PreBeginPlay()
{

local CSSPickupBase PickB;
local int i;
local vector X, Y, Z;

	//Spawn base part
	PickB = Spawn(Class'CSSPickupBase',,, Location, Rotation);
	PickB.Mesh = Mesh;
	
	For( i=0; i<8; i++)
	{
		PickB.MultiSkins[i] = MultiSkins[i];
	}

	For( i=0; i<16; i++)
	{
		if (RandomPickups[i] != None && Class<CSSPickupCharger>(RandomPickups[i]) != None)
			PickB.RandomPickups[i] = Class<CSSPickupCharger>(RandomPickups[i]).default.PickupClass;
		else
			PickB.RandomPickups[i] = RandomPickups[i];
	}

	PickB.SpawnOffset = SpawnOffset;
	PickB.bRotPickup = bRotPickup;
	PickB.AmbientGlow = AmbientGlow;
	PickB.DrawScale = DrawScale;
	PickB.bStay = bStay;
	PickB.ScaleGlow = ScaleGlow;
	PickB.AmbientGlow = AmbientGlow;
	PickB.LODBias = LODBias;
	PickB.PickupRotOffset = PickupRotOffset;
	PickB.Tag = Tag;
	PickB.bSpawnTriggered = bSpawnTriggered;
	PickB.bTriggerToggle = bTriggerToggle;
	PickB.bRandom = bRandom;
	PickB.RandRespawnTime = RandRespawnTime;
	PickB.CollectedEvent = CollectedEvent;
	PickB.SpawnEvent = SpawnEvent;
	PickB.bSpawnEventOnce = bSpawnEventOnce;
	PickB.RetriggerWaitTime = RetriggerWaitTime;
	PickB.bTriggeredMachine = bTriggeredMachine;
	PickB.RandRespawnTimeMin = RandRespawnTimeMin;
	PickB.RandRespawnTimeMax = RandRespawnTimeMax;
	PickB.bUseRandomRespawnTime = bUseRandomRespawnTime;
	PickB.bAutoAlignPickup = bAutoAlignPickup;
	PickB.Texture = Texture;
	PickB.bSPMode = bSPMode;
	PickB.bWeaponStay = bWeaponStay;
	PickB.bNeverStays = bNeverStays;

	SetTimer(0.1, False);
	MarkedPick = PickB;

	//Destroy();
}

function Timer()
{
	if (MarkedPick != None)
	{
		MarkedPick.bForceRot = bForceRot;
		MarkedPick.PickupRespawnTime = PickupRespawnTime;
		MarkedPick.BeginDelayTime = BeginDelayTime;
		MarkedPick.PickupClass = PickupClass;

		if (CollectedEvent == '' && Event != '')
			MarkedPick.CollectedEvent = Event;

		if (MyMarker != None)
		{
			MarkedPick.PMarker = MyMarker;
			MyMarker.Tag = Tag;
		}
	}

	Destroy();
}

//---------------------------------------------------------------
//Cancel several inventory functions
//---------------------------------------------------------------

function BecomePickup(){}

function BecomeItem(){}

function GiveTo( pawn Other ){}

function inventory SpawnCopy( pawn Other ){}

function SetRespawn(){}

function Activate(){}

event TravelPreAccept(){}

function bool HandlePickupQuery( inventory Item ){}

function Inventory SelectNext(){}

function DropFrom(vector StartLocation){}


event float BotDesireability( pawn Bot )
{
	local Inventory AlreadyHas;
	local float desire;
	local bool bChecked;

	desire = MaxDesireability;

	if ( RespawnTime < 10 )
	{
		bChecked = true;
		AlreadyHas = Bot.FindInventoryType(PickupClass); 
		if ( (AlreadyHas != None) 
			&& (AlreadyHas.Charge >= Charge) )
				return -1;
	}

	if( bIsAnArmor )
	{
		if ( !bChecked )
			AlreadyHas = Bot.FindInventoryType(PickupClass); 
		if ( AlreadyHas != None )
			desire *= (1 - AlreadyHas.Charge * AlreadyHas.ArmorAbsorption * 0.00003);
		
		desire *= (Charge * 0.005);
		desire *= (ArmorAbsorption * 0.01);
		return desire;
	}
	else return desire;
}

auto state Pickup
{

ignores ZoneChange, Touch, Landed, Timer, BeginState, EndState;

function bool ValidTouch( actor Other ){}

function CheckTouching(){}

Begin:
GotoState('');

}

state Activated
{
	function BeginState(){}

	function EndState(){}

	function Activate(){}

Begin:
}
State Sleeping
{
Begin:
}

function ActivateTranslator(bool bHint){}

defaultproperties
{
    BeginDelayTime=2.00
    SpawnOffset=(X=0.00,Y=0.00,Z=48.00),
    bRotPickup=True
    PickupRespawnTime=20.00
    bAutoAlignPickup=True
    RandRespawnTime=30.00
    RandRespawnTimeMin=28.00
    RandRespawnTimeMax=50.00
    bRotatingPickup=False
    RemoteRole=ROLE_DumbProxy
    Mesh=None
    AmbientGlow=0
    bTravel=False
    bCollideActors=False
}
