class Armor_Kevlar extends Armor2;

#exec MESH MODELIMPORT MESH=KevlarMesh MODELFILE=Models\Armor\KevlarMesh.psk
#exec MESH ORIGIN MESH=KevlarMesh X=0 Y=0 Z=5.5 YAW=0 PITCH=0 ROLL=0

#exec ANIM IMPORT ANIM=KevlarMeshAnims ANIMFILE=Models\Armor\KevlarMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=KevlarMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec ANIM SEQUENCE ANIM=KevlarMeshAnims SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec ANIM DIGEST ANIM=KevlarMeshAnims
#exec MESH DEFAULTANIM MESH=KevlarMesh ANIM=KevlarMeshAnims

#exec MESHMAP SCALE MESHMAP=KevlarMesh X=1.0 Y=1.0 Z=1.0

#exec TEXTURE IMPORT NAME=KevlarBodyPick FILE=Textures\Armor\KevlarBodyPick.bmp GROUP=Armor LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=KevlarMesh NUM=0 TEXTURE=KevlarBodyPick

#exec AUDIO IMPORT NAME="KevlarPick" FILE=Sounds\PickupSounds\KevlarPickup.wav GROUP="Armor"

function PostBeginPlay()
{
     if(Class'CSSMutator'.default.bAllAmbientGlow)
     {
          AmbientGlow = 64;
          bAmbientGlow = True;
     }
     else
     {
          AmbientGlow = 0;
          bAmbientGlow = False;
     }
     Super.PostBeginPlay();
}

defaultproperties
{
     AmbientGlow=0
     bDisplayableInv=True
     PickupMessage="You got the Kevlar Armor."
     ItemName="Kevlar Armor"
     RespawnTime=30.000000
     PickupViewMesh=SkeletalMesh'CSSWeapons.KevlarMesh'
     Charge=100
     ArmorAbsorption=75
     Physics=PHYS_Falling
     bIsAnArmor=True
     AbsorptionPriority=7
     MaxDesireability=2.000000
     PickupSound=Sound'CSSWeapons.Armor.KevlarPick'
     PickupViewScale=1.70
     DrawScale=1.70
     Mesh=SkeletalMesh'CSSWeapons.KevlarMesh'
     CollisionRadius=32.000000
     CollisionHeight=8.000000
}