/////////////////////////////////////////////////////////////////////////////
// UE3Library.cpp

#include "stdafx.h"
#include "UE3Library.h"

extern "C" {HINSTANCE hInstance;}
extern "C" {TCHAR GVersion[32]	=TEXT("1.0");}
extern "C" {TCHAR GLogname[32]	=TEXT("UT99Query");}
extern "C" {TCHAR GEventname[32]=TEXT("Log");}

static FMallocDebug	Malloc;

// Critical section used by MallocThreadSafeProxy for synchronization
static FCriticalSectionWin MallocCriticalSection;

// Thread safe malloc proxy, rendering any FMalloc thread safe
static FMallocThreadSafeProxy MallocThreadSafeProxy( &Malloc, &MallocCriticalSection );

static FOutputDeviceFile			Log;
static FOutputDeviceWindowsError	Error;
static FFeedbackContextWindows		AppWarn;
static FFileManagerWindows			FileManager;
static FOutputDeviceConsoleWindows	LogConsole;
static FSynchronizeFactoryWin		SynchronizeFactory;
static FThreadFactoryWin			ThreadFactory;

extern TCHAR GCmdLine[4096];

// Thread used for async IO manager.
FRunnableThread* AsyncIOThread;

/////////////////////////////////////////////////////////////////////////////
// Init

INT CUE3Library::Init( const TCHAR* CmdLine )
{
	// This is done in appXenonInit on Xenon.
	GSynchronizeFactory = &SynchronizeFactory;
	GThreadFactory = &ThreadFactory;

	appInit(
		CmdLine,
		&MallocThreadSafeProxy,
		&Log,
		&LogConsole,
		&Error,
		&AppWarn,
		&FileManager
		);

	// Exit if wanted.
	if( GIsRequestingExit )
	{
		appPreExit();
		// appExit is called outside guarded block.
		return 1;
	}
	
	GIsRunning = 1;
	return 0;
}

CUE3Library GLibrary;

/////////////////////////////////////////////////////////////////////////////
// Exit

void CUE3Library::Exit()
{
	GIsRunning = 0;
	GLogConsole = NULL;
	appPreExit();
}

/////////////////////////////////////////////////////////////////////////////
// Tick

/*
void CUE3Library::Tick()
{
	DWORD CurrentFrameCycles = appCycles();
}
*/

/////////////////////////////////////////////////////////////////////////////
// <<eof>> UE3Library.cpp
/////////////////////////////////////////////////////////////////////////////
