/////////////////////////////////////////////////////////////////////////////
// TrayWndProc.cpp

#include "stdafx.h"
#include "App.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////////
// TrayMessage

BOOL CMainFrame::TrayMessage(DWORD dwMessage)
{
	/*
	CString sTip;
	sTip.LoadString(AFX_IDS_APP_TITLE);
	if( sTip.IsEmpty() )
		sTip = _T( "You Bastard!" );
	sTip += _T(":Disable");
	*/

	HICON hIcon;
	LPCTSTR pszTip;

	if( m_bStart == TRUE )
	{
		if( m_hIconEnable == NULL )
			m_hIconEnable = LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_ENABLE) );
		hIcon = m_hIconEnable;
		pszTip = m_sQueryEnable;
	}
	else
	{
		if( m_hIconDisable == NULL )
			m_hIconDisable = LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DISABLE) );
		hIcon = m_hIconDisable;
		pszTip = m_sQueryDisable;
	}


	m_nid.cbSize			= sizeof(NOTIFYICONDATA);
	m_nid.hWnd				= m_hWnd;
	m_nid.uID				= IDR_MAINFRAME;
	m_nid.uFlags			= NIF_MESSAGE|NIF_ICON;
	m_nid.uCallbackMessage	= WindowTrayMessage;
	m_nid.hIcon				= hIcon;
	m_nid.uFlags			= NIF_MESSAGE|NIF_ICON|NIF_TIP;
	//lstrcpyn(m_nid.szTip,(LPCTSTR)sTip,sizeof(m_nid.szTip)/sizeof(m_nid.szTip[0]));
	lstrcpyn(m_nid.szTip,(LPCTSTR)pszTip,sizeof(m_nid.szTip)/sizeof(m_nid.szTip[0]));
	return Shell_NotifyIcon(dwMessage,&m_nid);
}

////////////////////////////////////////////////////////////////////////////////
// OnShowFrame
//
//    .

void CMainFrame::OnShowFrame()
{
	if( IsWindowVisible() )
	{
		ShowWindow(SW_MINIMIZE);
		return;
	}

	if( theApp.m_bShowFrame )
		ShowWindow(SW_SHOWMAXIMIZED);
	else 
		ShowWindow(SW_RESTORE);

	SetForegroundWindow();
	SetFocus();
}

////////////////////////////////////////////////////////////////////////////////
// TrayWndProc
//
//   .

LRESULT CMainFrame::TrayWndProc(WPARAM wParam, LPARAM lParam)
{
	UINT msg = (UINT)lParam;
	switch( msg )
	{
	case WM_LBUTTONDBLCLK:
		//OnShowFrame();
		break;
	case WM_RBUTTONDOWN:
		break;
	case WM_LBUTTONUP:
		{
			static BOOL bBusy = FALSE;
			if( bBusy == FALSE )
			{
				bBusy = TRUE;
				OnShowFrame();
				bBusy = FALSE;
			}
		}
		break;

	case WM_RBUTTONUP:// Display popup menu.
		CMenu pPopupMenu;
		pPopupMenu.LoadMenu(IDR_TRAYMENU);
		CMenu* subMenu=(CMenu*)pPopupMenu.GetSubMenu(0);
		CPoint pPoint;
		GetCursorPos(&pPoint);
		DisplayTrayPopupMenu(subMenu,pPoint);
	}
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////
// DisplayTrayPopupMenu

void CMainFrame::DisplayTrayPopupMenu(CMenu* pPopupMenu, CPoint pPoint)
{
	CMenu menu;
	if( !menu.LoadMenu(IDR_TRAYMENU) )
		return;

	::SetMenuDefaultItem(menu,0,TRUE);

	CWnd* pWnd = AfxGetMainWnd();
    pWnd->SetForegroundWindow();

	//  /  :
	if( !IsWindowVisible() )
	{
		//   - disabled.
		//pPopupMenu->EnableMenuItem(ID_TRAY_HIDE_WINDOW,MF_BYCOMMAND | MF_DISABLED | MF_GRAYED);
		//   - .
		//pPopupMenu->CheckMenuItem(ID_TRAY_HIDE_WINDOW, MF_CHECKED);

		//  .
		pPopupMenu->RemoveMenu(ID_TRAY_HIDE_WINDOW, MF_BYCOMMAND);

	} else {
		//   - disabled.
		//pPopupMenu->EnableMenuItem(ID_TRAY_SHOW_WINDOW,MF_BYCOMMAND|MF_GRAYED);		
		//   - .
		//pPopupMenu->CheckMenuItem(ID_TRAY_SHOW_WINDOW, MF_CHECKED);

		//  .
		pPopupMenu->RemoveMenu(ID_TRAY_SHOW_WINDOW, MF_BYCOMMAND);
	}

	//  /  :
	if( !m_bStart )
	{
		//  .
		pPopupMenu->RemoveMenu(ID_TRAY_QUERY_STOP, MF_BYCOMMAND);

	} else {
		//  .
		pPopupMenu->RemoveMenu(ID_TRAY_QUERY_START, MF_BYCOMMAND);
	}

    ::TrackPopupMenu(pPopupMenu->m_hMenu,0,pPoint.x,pPoint.y,0,pWnd->GetSafeHwnd(),NULL);
	pWnd->PostMessage(WM_NULL,0,0);
}

//////////////////////////////////////////////////////////////////////
// SetTrayIcon
//
//    .

void CMainFrame::SetTrayIcon(HICON hIcon)
{
	// First make sure we got a valid icon.
	if( hIcon==NULL )
		return;

	// Now check if we are already enabled.
	if( m_bIconEnabled==TRUE )
	{
		// We are, so update.
		m_nid.hIcon = hIcon;

		// Only icon.
		m_nid.uFlags = NIF_ICON;
		Shell_NotifyIcon(NIM_MODIFY,&m_nid);
	}
}

////////////////////////////////////////////////////////////////////////////////
// SetTrayTooltip
//
//   , .

void CMainFrame::SetTrayTooltip(LPCTSTR lpTooltip)
{
	// Tooltip can be empty, we don't care.
	m_sTooltip = lpTooltip;

	// If we are enabled.
	if( m_bIconEnabled == TRUE )
	{
		// Do an update.
		lstrcpy(m_nid.szTip,m_sTooltip);

		// Tooltip only.
		m_nid.uFlags = NIF_TIP;
		Shell_NotifyIcon(NIM_MODIFY,&m_nid);
	}
}

////////////////////////////////////////////////////////////////////////////////
// OnTrayMenuItem1

void CMainFrame::OnTrayMenuItem1()
{
	/*
	static BOOL bRun = 0;
	bRun = !bRun;
	if( bRun )
	{
		CWnd* pWnd=AfxGetMainWnd();
		pWnd->MessageBox(_T("Hi!"),_T("Message"),MB_OK|MB_SETFOREGROUND|MB_TOPMOST);
	}
	*/
	static BOOL bRun = FALSE;
	if( bRun == FALSE )
	{
		bRun = TRUE;
		CWnd* pWnd=AfxGetMainWnd();
		pWnd->MessageBox(_T("Hi!"),_T("Message"),MB_OK|MB_SETFOREGROUND|MB_TOPMOST);
		bRun = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////////
// AddTrayIcon

void CMainFrame::AddTrayIcon(int nIndex)
{
	HICON hIcon=NULL;

	switch(nIndex)
	{
	case NUMBER01:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT01));
		break;
	case NUMBER02:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT02));
		break;
	case NUMBER03:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT03));
		break;
	case NUMBER04:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT04));
		break;
	case NUMBER05:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT05));
		break;
	case NUMBER06:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT06));
		break;
	case NUMBER07:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT07));
		break;
	case NUMBER08:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT08));
		break;
	case NUMBER09:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT09));
		break;
	case NUMBER10:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT10));
		break;
	case NUMBER11:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT11));
		break;
	case NUMBER12:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT12));
		break;
	case NUMBER13:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT13));
		break;
	case NUMBER14:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT14));
		break;
	case NUMBER15:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT15));
		break;
	case NUMBER16:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT16));
		break;
	case NUMBER17:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT17));
		break;
	case NUMBER18:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT18));
		break;
	case NUMBER19:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT19));
		break;
	case NUMBER20:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT20));
		break;
	case NUMBER21:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DIGIT21));
		break;

	case APP_START:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_ENABLE));
		break;
	case APP_STOP:
		hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DISABLE));
		break;

	default:
		if( nIndex > 21 )
			hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_DEFAULT));
		else
			hIcon=LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_ENABLE));
		break;
	}

	m_bIconEnabled = TRUE;
	SetTrayIcon(hIcon);
}

////////////////////////////////////////////////////////////////////////////////
// AddTrayMessage

void CMainFrame::AddTrayMessage(LPCTSTR pszMessage)
{
	CString sMessage;

	if( m_nPlayerID > 0 )
	{
		sMessage.Format( _T( "Players: %d\n%s" ), m_nPlayerID, pszMessage );
		sMessage.TrimRight( _T("\n") );
	}
	else
		sMessage.Format( _T( "%s" ), pszMessage );

	SetTrayTooltip( sMessage );
}

/////////////////////////////////////////////////////////////////////////////
// <<EOF>> TrayWndProc.cpp
/////////////////////////////////////////////////////////////////////////////
