////////////////////////////////////////////////////////////////////////////////
// ReadmeDlg.cpp

#include "stdafx.h"
#include "App.h"
#include "ReadmeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define README_MIN_X_SIZE 630
#define README_MIN_Y_SIZE 340
LONG ReadmeDlg_minX = README_MIN_X_SIZE;
LONG ReadmeDlg_minY = README_MIN_Y_SIZE;

////////////////////////////////////////////////////////////////////////////////
// CReadmeDlg

CReadmeDlg::CReadmeDlg() : CDialog(CReadmeDlg::IDD)
{
	//{{AFX_DATA_INIT(CReadmeDlg)

	//   .
	SetMinSize(ReadmeDlg_minX, ReadmeDlg_minY);

	m_hIcon = LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_ICON_TEXTDOC));
	m_sTitle = _T("");	//  .
	m_sText = _T("");	// .
	//}}AFX_DATA_INIT
}

void CReadmeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_README_EDIT1, m_pEdit);
	DDX_Control(pDX, IDC_README_CLOSE, m_btClose);
}

BEGIN_MESSAGE_MAP(CReadmeDlg, CDialog)
	ON_WM_GETMINMAXINFO()
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_README_CLOSE, &CReadmeDlg::OnClose)
END_MESSAGE_MAP()

////////////////////////////////////////////////////////////////////////////////
// CReadmeDlg message handlers

void CReadmeDlg::OnOK()
{
	CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////
// OnCancel

void CReadmeDlg::OnCancel() 
{
	//CDialog::OnCancel();
}

////////////////////////////////////////////////////////////////////////////////
// OnDestroy

void CReadmeDlg::OnDestroy() 
{
	CDialog::OnDestroy();
}

//////////////////////////////////////////////////////////////////////////////
// OnClose

void CReadmeDlg::OnClose()
{
	EndDialog(0);
}

void CReadmeDlg::SetMinSize(LONG x, LONG y )
{
	m_cxMin = x;
	m_cyMin = y;
	m_fxMin = 2*(GetSystemMetrics(SM_CXFRAME)+
		      GetSystemMetrics(SM_CXEDGE))   +
		      m_cxMin;
	m_fyMin = 2*(GetSystemMetrics(SM_CYFRAME)+
		      GetSystemMetrics(SM_CYEDGE))   +
              GetSystemMetrics(SM_CYCAPTION) +
              GetSystemMetrics(SM_CYMENU)    +
			  m_cyMin;
}
void CReadmeDlg::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
	lpMMI->ptMinTrackSize.x = m_fxMin;
	lpMMI->ptMinTrackSize.y = m_fyMin;
}

////////////////////////////////////////////////////////////////////////////////
// OnInitDialog

BOOL CReadmeDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon,TRUE);

	if( m_sTitle.IsEmpty() )
		m_sTitle = _T("Readme");
	SetWindowText( m_sTitle );

	//  :
	//m_hFont.CreatePointFont(128,TEXT("TAHOMA"),NULL);
	//m_pListIP.SetFont(&m_hFont,TRUE);

	if( m_sText.IsEmpty() )
		m_sText = _T("Welcome");
	m_pEdit.SetWindowText( m_sText );

	CRect rect;
	GetClientRect(&rect);
	CSize size=rect.Size();
	//m_pEdit.MoveWindow(CRect(5,5,size.cx-5,size.cy-5));
	m_pEdit.MoveWindow(CRect(5,5,size.cx-5,size.cy-50));

	int nHeight		= size.cy / 15;
	int nWidth		= size.cx / 9;
	int nVertical	= size.cy / -15 + size.cy - 10;
	m_btClose.SetWindowPos(NULL, 5, nVertical, nWidth, nHeight, 20);

	return TRUE;
}

void CReadmeDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	//   ,   .
	if( IsWindowVisible() )
	{
		int nHeight		= cy / 15;
		int nWidth		= cx / 9;
		int nVertical	= cy / -15 + cy - 10;
		m_btClose.SetWindowPos(NULL, 5, nVertical, nWidth, nHeight, 20);
		m_pEdit.MoveWindow( CRect(5,5,cx-5,nVertical-8) );
		
		Invalidate();
	}
}

////////////////////////////////////////////////////////////////////////////////
// <<eof>> ReadmeDlg.cpp
////////////////////////////////////////////////////////////////////////////////
