////////////////////////////////////////////////////////////////////////////////
// QueryServer.h

#ifndef __QUERYSERVER_H__
#define __QUERYSERVER_H__

#define QUERY_DELAY 700

typedef int	SOCKLEN;
#define MSG_NOSIGNAL 0
#define MAXRECVDATASIZE 4096
#define IP(sin_addr,n) sin_addr.S_un.S_un_b.s_b##n

class QueryServer
{
public:
	QueryServer();
	~QueryServer();

	void Disconnect();
	ULONG GetAddr(const TCHAR* Hostname, struct in_addr* inaddr=NULL);
	void SetHostname(const TCHAR* Hostname);
	void SendMsg(const FString& Text);

	BOOL Start(const TCHAR* Hostaddress, int Port, const TCHAR* Magicstring);
	BOOL BindPort(int InPort = 2000, BOOL bUseNextAvailable = TRUE);
	int SendTo(const TCHAR* Hostaddress, int Port, const TCHAR* Magicstring);
	BOOL RecvFrom();

	CString GetResponse() const
	{
		return m_sResponse;
	};

	// Variables.
	BOOL	m_bConnected;
	SOCKET	m_UDPSoket;
	int		m_UDPPort;

protected:
	int StatBytesSent;
	int StatBytesReceived;
	CString m_sResponse;

private:
	const TCHAR* m_Hostname;
};

//
// Functions.
//
UBOOL InitSockets(FString& Error);
UBOOL SetNonBlocking(int Socket);
UBOOL SetSocketReuseAddr(int Socket, UBOOL ReUse=1);
UBOOL SetSocketLinger(int Socket);
TCHAR* SocketError(int Code=-1);
UBOOL IpMatches(sockaddr_in& A, sockaddr_in& B);
void IpGetBytes(in_addr Addr, BYTE& Ip1, BYTE& Ip2, BYTE& Ip3, BYTE& Ip4);
void IpSetBytes(in_addr& Addr, BYTE Ip1, BYTE Ip2, BYTE Ip3, BYTE Ip4);
void IpGetInt(in_addr Addr, DWORD& Ip);
void IpSetInt(in_addr& Addr, DWORD Ip);
FString IpString(in_addr Addr, int Port=0);

#endif//__QUERYSERVER_H__

////////////////////////////////////////////////////////////////////////////////
// <<eof>> QueryServer.h
////////////////////////////////////////////////////////////////////////////////
