////////////////////////////////////////////////////////////////////////////////
// QueryServer.cpp

#include "stdafx.h"
#include "App.h"
#include "QueryServer.h"

BOOL GWSAInitialized;

////////////////////////////////////////////////////////////////////////////////
// InitSockets

UBOOL InitSockets( FString& Error )
{
	GWSAInitialized = 1;
	return GWSAInitialized;

/*
	// Init WSA.
	static UBOOL Tried = 0;
	if( !Tried )
	{
		Tried = 1;
		WSADATA WSAData;
		int Code = WSAStartup( 0x0101, &WSAData );
		if( Code==0 )
		{
			//GHostByNameCriticalSection	= GSynchronizeFactory->CreateCriticalSection();
			GWSAInitialized			= 1;
			debugf
			(
				NAME_Init,
				TEXT("WinSock: version %i.%i (%i.%i), MaxSocks=%i, MaxUdp=%i"),
				WSAData.wVersion>>8,WSAData.wVersion&255,
				WSAData.wHighVersion>>8,WSAData.wHighVersion&255,
				WSAData.iMaxSockets,WSAData.iMaxUdpDg
			);
			//debugf( NAME_Init, TEXT("WinSock: %s"), WSAData.szDescription );
		} else {
			TCHAR Error256[256];
			appSprintf( Error256, TEXT("WSAStartup failed (%s)"), SocketError(Code) );
			Error = FString::Printf( TEXT("%s"), Error256 );
		}
	}
	return GWSAInitialized;
	*/
}

////////////////////////////////////////////////////////////////////////////////
// SocketError
//
//     .

TCHAR* SocketError( int Code )
{
	if( Code == -1 )
		Code = WSAGetLastError();
	switch( Code )
	{
		case WSAEINTR:				return TEXT("WSAEINTR");
		case WSAEBADF:				return TEXT("WSAEBADF");
		case WSAEACCES:				return TEXT("WSAEACCES");
		case WSAEFAULT:				return TEXT("WSAEFAULT");
		case WSAEINVAL:				return TEXT("WSAEINVAL");
		case WSAEMFILE:				return TEXT("WSAEMFILE");
		case WSAEWOULDBLOCK:		return TEXT("WSAEWOULDBLOCK");
		case WSAEINPROGRESS:		return TEXT("WSAEINPROGRESS");
		case WSAEALREADY:			return TEXT("WSAEALREADY");
		case WSAENOTSOCK:			return TEXT("WSAENOTSOCK");
		case WSAEDESTADDRREQ:		return TEXT("WSAEDESTADDRREQ");
		case WSAEMSGSIZE:			return TEXT("WSAEMSGSIZE");
		case WSAEPROTOTYPE:			return TEXT("WSAEPROTOTYPE");
		case WSAENOPROTOOPT:		return TEXT("WSAENOPROTOOPT");
		case WSAEPROTONOSUPPORT:	return TEXT("WSAEPROTONOSUPPORT");
		case WSAESOCKTNOSUPPORT:	return TEXT("WSAESOCKTNOSUPPORT");
		case WSAEOPNOTSUPP:			return TEXT("WSAEOPNOTSUPP");
		case WSAEPFNOSUPPORT:		return TEXT("WSAEPFNOSUPPORT");
		case WSAEAFNOSUPPORT:		return TEXT("WSAEAFNOSUPPORT");
		case WSAEADDRINUSE:			return TEXT("WSAEADDRINUSE");
		case WSAEADDRNOTAVAIL:		return TEXT("WSAEADDRNOTAVAIL");
		case WSAENETDOWN:			return TEXT("WSAENETDOWN");
		case WSAENETUNREACH:		return TEXT("WSAENETUNREACH");
		case WSAENETRESET:			return TEXT("WSAENETRESET");
		case WSAECONNABORTED:		return TEXT("WSAECONNABORTED");
		case WSAECONNRESET:			return TEXT("WSAECONNRESET");
		case WSAENOBUFS:			return TEXT("WSAENOBUFS");
		case WSAEISCONN:			return TEXT("WSAEISCONN");
		case WSAENOTCONN:			return TEXT("WSAENOTCONN");
		case WSAESHUTDOWN:			return TEXT("WSAESHUTDOWN");
		case WSAETOOMANYREFS:		return TEXT("WSAETOOMANYREFS");
		case WSAETIMEDOUT:			return TEXT("WSAETIMEDOUT");
		case WSAECONNREFUSED:		return TEXT("WSAECONNREFUSED");
		case WSAELOOP:				return TEXT("WSAELOOP");
		case WSAENAMETOOLONG:		return TEXT("WSAENAMETOOLONG");
		case WSAEHOSTDOWN:			return TEXT("WSAEHOSTDOWN");
		case WSAEHOSTUNREACH:		return TEXT("WSAEHOSTUNREACH");
		case WSAENOTEMPTY:			return TEXT("WSAENOTEMPTY");
		case WSAEPROCLIM:			return TEXT("WSAEPROCLIM");
		case WSAEUSERS:				return TEXT("WSAEUSERS");
		case WSAEDQUOT:				return TEXT("WSAEDQUOT");
		case WSAESTALE:				return TEXT("WSAESTALE");
		case WSAEREMOTE:			return TEXT("WSAEREMOTE");
		case WSAEDISCON:			return TEXT("WSAEDISCON");
		case WSASYSNOTREADY:		return TEXT("WSASYSNOTREADY");
		case WSAVERNOTSUPPORTED:	return TEXT("WSAVERNOTSUPPORTED");
		case WSANOTINITIALISED:		return TEXT("WSANOTINITIALISED");
		case WSAHOST_NOT_FOUND:		return TEXT("WSAHOST_NOT_FOUND");
		case WSATRY_AGAIN:			return TEXT("WSATRY_AGAIN");
		case WSANO_RECOVERY:		return TEXT("WSANO_RECOVERY");
		case WSANO_DATA:			return TEXT("WSANO_DATA");
		case 0:						return TEXT("WSANO_ERROR");
		default:					return TEXT("WSA_Unknown");
	}
}

////////////////////////////////////////////////////////////////////////////////
// bindnextport
//
// Bind to next available port.
//     .

int bindnextport( SOCKET s, struct sockaddr_in* addr, int portcount, int portinc )
{
	for( int i=0; i<portcount; ++i )
	{
		if( !bind( s, (sockaddr*)addr, sizeof(sockaddr_in) ) )
		{
			if (ntohs(addr->sin_port) != 0)
				return ntohs(addr->sin_port);
			else
			{
				// 0     ,
				//   ,    
				struct sockaddr_in boundaddr;
				SOCKLEN size = sizeof(boundaddr);
				getsockname ( s, (sockaddr*)(&boundaddr), &size);
				return ntohs(boundaddr.sin_port);
			}
		}
		if( addr->sin_port==0 )
			break;
		addr->sin_port = htons( ntohs(addr->sin_port) + portinc );
	}
	return 0;
}

UBOOL IpMatches( sockaddr_in& A, sockaddr_in& B )
{
	return	A.sin_addr.S_un.S_addr == B.sin_addr.S_un.S_addr
	&&		A.sin_port             == B.sin_port
	&&		A.sin_family           == B.sin_family;
}
void IpGetBytes( in_addr Addr, BYTE& Ip1, BYTE& Ip2, BYTE& Ip3, BYTE& Ip4 )
{
	Ip1 = IP(Addr,1);
	Ip2 = IP(Addr,2);
	Ip3 = IP(Addr,3);
	Ip4 = IP(Addr,4);
}
void IpSetBytes( in_addr& Addr, BYTE Ip1, BYTE Ip2, BYTE Ip3, BYTE Ip4 )
{
	IP(Addr,1) = Ip1;
	IP(Addr,2) = Ip2;
	IP(Addr,3) = Ip3;
	IP(Addr,4) = Ip4;
}
void IpGetInt( in_addr Addr, DWORD& Ip )
{
	Ip = Addr.S_un.S_addr;
}
void IpSetInt( in_addr& Addr, DWORD Ip )
{
	Addr.S_un.S_addr = Ip;
}
FString IpString( in_addr Addr, int Port )
{
	FString Result = FString::Printf( TEXT("%i.%i.%i.%i"), IP(Addr,1), IP(Addr,2), IP(Addr,3), IP(Addr,4) );
	if( Port )
		Result += FString::Printf( TEXT(":%i"), Port );
	return Result;
}
UBOOL SetNonBlocking( int Socket )
{
	DWORD NoBlock = 1;
	return ioctlsocket( Socket, FIONBIO, &NoBlock ) == 0;
}
UBOOL SetSocketReuseAddr( int Socket, UBOOL ReUse )
{
	int optval = ReUse?1:0;
	return setsockopt( Socket, SOL_SOCKET, SO_REUSEADDR, (char *)&optval, sizeof(int) );
}
UBOOL SetSocketLinger( int Socket )
{
	LINGER ling;
	ling.l_onoff  = 1;	// linger on
	ling.l_linger = 0;	// timeout in seconds
	return ( setsockopt( Socket, SOL_SOCKET, SO_LINGER, (LPSTR)&ling, sizeof(ling) ) == 0 );
}

////////////////////////////////////////////////////////////////////////////////
// 

QueryServer::QueryServer()
{
	m_UDPSoket			= INVALID_SOCKET;
	GWSAInitialized		= 1;
	StatBytesReceived	= 0;
	m_sResponse.Empty();
}

////////////////////////////////////////////////////////////////////////////////
// 

QueryServer::~QueryServer()
{
	Disconnect();
}

////////////////////////////////////////////////////////////////////////////////
// Disconnect

void QueryServer::Disconnect()
{
	//   ,  .
	if( m_bConnected ) {
		//   .
		m_bConnected = FALSE;
	}

	//  .
	if( m_UDPSoket != INVALID_SOCKET)
	{
		warnf(TEXT("Closing UDP socket, port: %d"), m_UDPPort);
		closesocket( m_UDPSoket );
		m_UDPSoket = INVALID_SOCKET;
	}
}

////////////////////////////////////////////////////////////////////////////////
// SetHostname

void QueryServer::SetHostname(const TCHAR* Hostname)
{
	m_Hostname = Hostname;
}

////////////////////////////////////////////////////////////////////////////////
// SendMsg

void QueryServer::SendMsg( const FString& Text )
{
	/*
	CWnd* pWnd = AfxGetMainWnd();
	if( pWnd )
	{
		// Get edit control to display response.
		CHistoryEdit* pEdt=(CHistoryEdit*)pWnd->GetDlgItem(IDC_EDIT1);
		if( pEdt==NULL )
			return;
	
		// Get number of lines originally.
		int nLineOrig = pEdt->GetLineCount();

		// Get original window text.
		//CString sText;
		//pEdt->GetWindowText( sText );
		FString Msg = FString::Printf( TEXT( "%s\n" ),Text );

		// Put append text to the edit control.
		//pEdt->AppendString( *Text );
		pEdt->AppendString( *Msg );
	}
	*/
}

////////////////////////////////////////////////////////////////////////////////
// GetAddr

ULONG QueryServer::GetAddr(const TCHAR* Hostname, struct in_addr* inaddr)
{
	u_long Result=INADDR_ANY;
	LPHOSTENT HostEnt=NULL;
	struct in_addr InAddr;
	if( *Hostname ) {
		InAddr.s_addr=inet_addr( TCHAR_TO_ANSI(Hostname) );
		if(( InAddr.s_addr==INADDR_NONE ) && ( lstrcmpi( Hostname,TEXT("255.255.255.255") ))) {
			HostEnt=gethostbyname( TCHAR_TO_ANSI(Hostname) );
			if( HostEnt ) {
				Result=*((u_long *)(HostEnt->h_addr));
				if( inaddr )
					inaddr->s_addr=*((u_long *)(HostEnt->h_addr));
			} else {
				Result=INADDR_ANY;
				if( inaddr )
					inaddr->s_addr=INADDR_ANY;
			}
		} else {
			Result=InAddr.s_addr;
			if( inaddr )
				inaddr->s_addr=InAddr.s_addr;
		}
	}
	return Result;
}

////////////////////////////////////////////////////////////////////////////////
// Start

BOOL QueryServer::Start( const TCHAR* Hostaddress, int Port, const TCHAR* Magicstring )
{
	BOOL Result = 0x0FFFFFFFF;
	//const FString& Msg = TEXT("Query Server: Start");
	//SendMsg( Msg );

	// ,    - .
	if( appStrlen( Hostaddress ) == 0 || Port == 0  || Port < 0 )
	{
		//const FString& Error = TEXT("-->FAILED: QueryServer: Start: appStrlen() Hostaddress");
		//SendMsg( Error );
		debugf( TEXT("-->FAILED: QueryServer: Start: appStrlen() Hostaddress") );
		return Result;
	}

	//  .
	Result = BindPort();
	if( Result == -1 )
	{
		//const FString& Error = TEXT("-->FAILED: QueryServer: BindPort");
		//SendMsg( Error );
		Disconnect();
		return Result;
	}

	//  , .
	m_bConnected = TRUE;

	//   .
	Result = SendTo( Hostaddress, Port, Magicstring );
	if( Result <= 0 )
	{
		//const FString& Error = TEXT("-->FAILED: QueryServer: SendTo");
		//SendMsg( Error );
		//debugf( TEXT("-->FAILED: QueryServer: SendTo") );
		Disconnect();
		return -1;
	}

	// .
	Sleep( QUERY_DELAY );

	//   .
	Result = RecvFrom();
	if( Result == -1 )
	{
		//const FString& Error = TEXT("-->FAILED: QueryServer: RecvFrom");
		//SendMsg( Error );
		Disconnect();
		return Result;
	}

	Disconnect();

	//const FString& Msg = TEXT("Query Server: Disconnect");
	//SendMsg( Msg );

	return 0;
}

////////////////////////////////////////////////////////////////////////////////
// BindPort
//
//    .
//      , 
//  ,    .
//  ,  : 2000, "bUseNextAvailable = TRUE"
//    ,  : 2001 
// 2002  ..

BOOL QueryServer::BindPort( int InPort, BOOL bUseNextAvailable )
{
	//  ,   IP:
	in_addr BindAddr;
	IpSetInt( BindAddr, INADDR_ANY );

	if( GWSAInitialized )
	{
		if( m_UDPSoket==INVALID_SOCKET )
		{
			m_UDPSoket = socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
			if( m_UDPSoket != INVALID_SOCKET )
			{
				UBOOL TrueBuffer=1;
				if( setsockopt( m_UDPSoket, SOL_SOCKET, SO_BROADCAST, (char*)&TrueBuffer, sizeof(TrueBuffer) )==0 )
				{
					sockaddr_in Addr;
					Addr.sin_family      = AF_INET;
					Addr.sin_addr        = BindAddr;
					Addr.sin_port        = htons(InPort);

					int boundport = bindnextport( m_UDPSoket, &Addr, bUseNextAvailable ? 20 : 1, 1 );
					if( boundport )
					{
						DWORD NoBlock = 1;
						if( ioctlsocket( m_UDPSoket, FIONBIO, &NoBlock )==0 )
						{
							// Success.
							//*(int*)Result = boundport;
							m_UDPPort = ntohs( Addr.sin_port );
							
							//    .
							//SOCKLEN size = sizeof(Addr);
							//getsockname ( m_UDPSoket, (sockaddr*)(&Addr), &size);
							//int port = ntohs( Addr.sin_port );
							
							warnf(TEXT("Opening UDP socket, port: %d"), m_UDPPort);
							return 0;
						}
						else
							debugf( TEXT("-->FAILED: BindPort: ioctlsocket") );
					}
					else
						debugf( TEXT("-->FAILED: BindPort: bind") );
				}
				else
					debugf( TEXT("-->FAILED: BindPort: setsockopt") );
			}
			else
				debugf( TEXT("-->FAILED: BindPort: socket") );
			Disconnect();
		}
		else
			debugf( TEXT("-->FAILED: BindPort: already bound") );
	}
	else
		debugf( TEXT("-->FAILED: BindPort: winsock") );

	return 0x0FFFFFFFF;
}

////////////////////////////////////////////////////////////////////////////////
// SendTo

int QueryServer::SendTo( const TCHAR* Hostaddress, int Port, const TCHAR* Magicstring )
{
	unsigned long ServerAddress = GetAddr( Hostaddress );
	if( !ServerAddress )
		return -1;
	
	struct sockaddr_in Addr;
	Addr.sin_family			= AF_INET;
	Addr.sin_port			= htons((u_short)Port);
	Addr.sin_addr.s_addr	= ServerAddress;

	fd_set fdset;
	FD_ZERO( &fdset );
	FD_SET( m_UDPSoket, &fdset );

	struct timeval tv;
	tv.tv_sec	= 10;
	tv.tv_usec	= 0;

	int SelectStatus = select( m_UDPSoket + 1, NULL, &fdset, NULL, &tv );
	if( SelectStatus==0 || SelectStatus==SOCKET_ERROR )
	{
		warnf( TEXT("-->FAILED: SendTo: checking socket status: %d"), SelectStatus );
		return -2;
	}
	
	//   :
	FString Str = Magicstring;

	// :
	int SentBytes = sendto( m_UDPSoket, TCHAR_TO_ANSI(*Str), sizeof(ANSICHAR)*Str.Len(), MSG_NOSIGNAL, (sockaddr*)&Addr, sizeof(Addr) );
	if( SentBytes == SOCKET_ERROR )
	{
		TCHAR* error = SocketError(WSAGetLastError());
		warnf( TEXT("-->FAILED: SendTo: %s"), error );
		SentBytes = 0;
	}
	else
	{
		debugf( TEXT("QueryServer: Sent %i bytes"), SentBytes);
	}
	return SentBytes;
}

BOOL QueryServer::RecvFrom()
{
	if( !m_sResponse.IsEmpty() )
		m_sResponse.Empty();

	m_sResponse.Preallocate(MAXRECVDATASIZE);

	BYTE Buffer[MAXRECVDATASIZE];

	BOOL Result = 0;
	int Count = 0;
	int SelectStatus = 0;

	int WaitTime = 0;
	TIMEVAL SelectTime = {WaitTime, 0};

	fd_set SocketSet;
	FD_ZERO( &SocketSet );
	FD_SET( m_UDPSoket, &SocketSet );

	struct sockaddr_in FromAddr;
	int FromSize = sizeof(FromAddr);

	for(;;)
	{
		SelectStatus = select( m_UDPSoket + 1, &SocketSet, 0, 0, &SelectTime );
		if ( SelectStatus == SOCKET_ERROR )
		{
			warnf( TEXT("-->FAILED: RecvFrom: checking socket status: %d"), WSAGetLastError());
			Result = -1;
			break;
		}
		else
		if ( SelectStatus == 0 )
		{
			if( WSAGetLastError() == SOCKET_ERROR )
			{
				warnf( TEXT("-->FAILED: RecvFrom: checking socket status: %d"), WSAGetLastError() );
				Result = -2;
			}
			break;
		}

		Count = recvfrom( m_UDPSoket, (char*)Buffer, ARRAY_COUNT(Buffer)-1, MSG_NOSIGNAL, (sockaddr*)&FromAddr, &FromSize );
		if( Count == SOCKET_ERROR )
		{
			if( WSAGetLastError() == WSAEWOULDBLOCK )
			{
				//      .
				warnf( TEXT("-->FAILED: RecvFrom: operation could not be: %d"), WSAGetLastError() );
				Result = -3;
				break;
			}
			else
			if( WSAGetLastError() != WSAECONNRESET )
			{
				// ICMP ,    recv().
				warnf( TEXT("-->FAILED: RecvFrom: ICMP unreachable: %d"), WSAGetLastError() );
				Result = -4;
				break;
			}
		}
		else
		if( Count > 0 )
		{
			StatBytesReceived	+= Count;
			Buffer[Count]		= 0;

			//
			//  .
			//

			//  .
			m_sResponse += *FString((ANSICHAR*)Buffer);

		}
		else
			break;
	}
	if( StatBytesReceived > 0 )
		debugf( TEXT("QueryServer: Received %i bytes"), StatBytesReceived);

	return Result;
}

////////////////////////////////////////////////////////////////////////////////
// <<eof>> QueryServer.cpp
////////////////////////////////////////////////////////////////////////////////
