/////////////////////////////////////////////////////////////////////////////
// MainFrm.h

#pragma once

#define INDEX_NAME	0
#define INDEX_FRAGS	1
#define INDEX_PING	2
#define INDEX_TEAM	3
#define INDEX_MESH	4
#define INDEX_SKIN	5
#define INDEX_FACE	6
#define INDEX_ID	7

#define NUMBER01	1
#define NUMBER02	2
#define NUMBER03	3
#define NUMBER04	4
#define NUMBER05	5
#define NUMBER06	6
#define NUMBER07	7
#define NUMBER08	8
#define NUMBER09	9
#define NUMBER10	10
#define NUMBER11	11
#define NUMBER12	12
#define NUMBER13	13
#define NUMBER14	14
#define NUMBER15	15
#define NUMBER16	16
#define NUMBER17	17
#define NUMBER18	18
#define NUMBER19	19
#define NUMBER20	20
#define NUMBER21	21

#define APP_START	97
#define APP_STOP	98

#define WM_CLICKBUTTONSTART	WM_APP + 200

/////////////////////////////////////////////////////////////////////////////
// CDisplayIC

class CDisplayIC : public CDC
{
public:
	CDisplayIC(){CreateIC(_T("DISPLAY"),NULL,NULL,NULL);}
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

class CMainFrame : public CFrameWnd
{
protected:
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

// Attributes
public:
	BOOL m_bStart;
	BOOL m_bToolbar;
	BOOL m_bStatusbar;
	BOOL m_bExit;
	BOOL m_bSysTray;

	CString m_sAppname;
	CString m_sTempAppname;
	CString m_sServername;

	CString m_sQueryEnable;
	CString m_sQueryDisable;

	//  , .
	CString m_sHostAddress;
	int m_nHostPort;
	CString m_sDefaultHostAddress;
	int m_nDefaultHostPort;

	// Message for debugf.
	CString m_sStartQuery;
	CString m_sEndQuery;

	// ,   :
	CString m_sPlayer;

	//TArray<FString> m_Servers;

	// --- GetInfo ---
	FString m_sHostName;
	int m_nGamePort;
	FString m_sMapName;
	FString m_sMapTitle;
	FString m_sMapDisplayName;
	FString m_sGameType;
	FString m_sGameMode;
	int m_nNumPlayers;
	int m_nMaxPlayers;
	int m_nGameVer;
	int m_nMinNetVer;

	FString m_sTrueString;
	FString m_sFalseString;

	/*
	// --- GetStatus ---
	FString m_sAdminEmailText;
	FString m_sAdminNameText;
	FString m_sChangeLevelsText;
	FString m_sMultiplayerBotsText;
	FString m_sFragLimitText;
	FString m_sTimeLimitText;
	FString m_sGameModeText;
	FString m_sGameTypeText;
	FString m_sGameVersionText;
	FString m_sWorldLogText;
	FString m_sMutatorsText;
	FString m_sTrueString;
	FString m_sFalseString;
	FString m_sServerAddressText;
	FString m_sGoalTeamScoreText;
	FString m_sMinPlayersText;
	FString m_sPlayersText;
	FString m_sMaxTeamsText;
	FString m_sBalanceTeamsText;
	FString m_sPlayersBalanceTeamsText;
	FString m_sFriendlyFireText;
	FString m_sMinNetVersionText;
	FString m_sBotSkillText;
	FString m_sTournamentText;
	FString m_sServerModeText;
	FString m_sDedicatedText;
	FString m_sNonDedicatedText;
	FString m_sWorldLogWorkingText;
	FString m_sWorldLogWorkingTrue;
	FString m_sWorldLogWorkingFalse;
	FString m_sPasswordText;
	FString m_sDefaultPlayerName;
	*/

	FString m_sPlayerName;
	int		m_nPlayerFrags;
	int		m_nPlayerPing;
	FString m_sPlayerTeam;
	FString m_sPlayerMesh;
	FString m_sPlayerSkin;
	FString m_sPlayerFace;
	int		m_nPlayerID;
	FString	m_sPlayerStats;

	int		m_nStatusDone;

// Operations
public:

	//     .
	void SelectMenu(BOOL bMode);

	void DefaultData();
	BOOL GetServerAddressPort(const TCHAR* Stream);
	void CheckFileServer();

	void loadstring();
	void SetMinSize(LONG x, LONG y);
	void BuildItems(int nIndex, LPCTSTR pszText);
	void ClearResponse();

	void AddTrayIcon(int nIndex);
	void AddTrayMessage(LPCTSTR pszMessage);

	void StartTimer();
	void StopTimer();

// ------------------------------------------[ Update Thread ]
	int StartQueryThread();
	int StopQueryThread();
	int HandleQueryPoll();
	friend UINT QueryThreadEntry(LPVOID pParam);

/////////////////////////////////////////////////////////////////////////////
//
//	
//
/////////////////////////////////////////////////////////////////////////////

	BOOL CheckEngine();
	int DoQuery();
	int Int(FString Text);
	FString GetItemName(FString FullName);	
	FString LocalizeTeam(FString TeamNum);
	FString LocalizeSkin(FString SkinName);
	FString LocalizeBoolValue(FString Value);
	FString ParseReply(FString Text, FString Key);
	BOOL GetNextValue(FString In, FString Out, FString Result);
	void AddRule(
		FString PlayerName, int nPlayerFrags, int nPlayerPing, FString PlayerTeam,
		FString PlayerMesh, FString PlayerSkin, FString PlayerFace, int nPlayerID );

	void GetInfo(FString Text);
	void GetStatus(FString Text);

// Overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void ActivateFrame(int nCmdShow = -1);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	void DisplayTrayPopupMenu(CMenu* pPopupMenu, CPoint pPoint);
	LRESULT TrayWndProc(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;

	// .
	BOOL m_bCommonTimer;
	BOOL m_bOptionsTimer1;
	BOOL m_bOptionsTimer2;
	BOOL m_bOptionsTimer3;
	BOOL m_bOptionsTimer4;
	BOOL m_bOptionsTimer5;

	UINT_PTR m_nTimer;
	BOOL m_bBusy;
	int m_nCounter;
	int m_nTimeDelay;

	HICON m_hIcon;
	HICON m_hIconEnable;
	HICON m_hIconDisable;

	BOOL m_bIconEnabled;
	NOTIFYICONDATA m_nid;
	CString m_sTooltip;

	//  T:
	CWinThread* m_pQueryThread;
	BOOL m_bIsQueryThread;

	// ----------------------- [ List columns ] ---
	CString m_sName;
	CString m_sFrags;
	CString m_sPing;
	CString m_sTeam;
	CString m_sMesh;
	CString m_sSkin;
	CString m_sFace;
	CString m_sID;

public:
	//TFrame m_Frame;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMove(int x, int y);
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg BOOL OnQueryEndSession();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnExit();

	afx_msg void OnUpdateToolbar(CCmdUI* pCmdUI);
	afx_msg BOOL OnToolbar(UINT nID);
	afx_msg void OnUpdateStatusbar(CCmdUI* pCmdUI);
	afx_msg BOOL OnStatusbar(UINT nID);

	afx_msg void OnUpdateStart(CCmdUI* pCmdUI);
	afx_msg void OnStart();
	

	afx_msg void OnUpdateOptionsTime1(CCmdUI* pCmdUI);
	afx_msg void OnOptionsTime1();
	afx_msg void OnUpdateOptionsTime2(CCmdUI* pCmdUI);
	afx_msg void OnOptionsTime2();
	afx_msg void OnUpdateOptionsTime3(CCmdUI* pCmdUI);
	afx_msg void OnOptionsTime3();
	afx_msg void OnUpdateOptionsTime4(CCmdUI* pCmdUI);
	afx_msg void OnOptionsTime4();
	afx_msg void OnUpdateOptionsTime5(CCmdUI* pCmdUI);
	afx_msg void OnOptionsTime5();

	//   .
	afx_msg void OnChangeHost();

	//  .
	afx_msg void OnOptionsCloseConsole();

	afx_msg void OnSelectColumns();
	afx_msg void OnFont();
	//}}AFX_MSG
	afx_msg LRESULT OnClickButtonStart(WPARAM wParam, LPARAM lParam);

	afx_msg void OnUpdateSysTray(CCmdUI* pCmdUI);
	afx_msg void OnSysTray();
	afx_msg void OnShowFrame();
	afx_msg void OnTrayMenuItem1();
	//
	// Other stuff.
	afx_msg void OnMPUKBanlist();
	afx_msg void OnMPUKForum();
	afx_msg void OnMadrixis();
	afx_msg void OnVideoSettings();

	DECLARE_MESSAGE_MAP()

private:
	BOOL TrayMessage(DWORD dwMessage);
	void SetTrayIcon(HICON hIcon);
	void SetTrayTooltip(LPCTSTR lpTooltip);

	LONG  m_cxMin;     // Minimum client size
	LONG  m_cyMin;
	LONG  m_fyMin;     // Minimum frame size that includes borders, the frame, the toolbar
	LONG  m_fxMin;     // and the status bar to have a client area of m_cxMin*m_cyMin
};

/////////////////////////////////////////////////////////////////////////////
// <<eof>> MainFrm.h
/////////////////////////////////////////////////////////////////////////////
