/////////////////////////////////////////////////////////////////////////////
// MainFrm.cpp

#include "stdafx.h"
#include "App.h"
#include "ChangeColumns.h"
#include "QueryServer.h"
#include "ReadmeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MIN_X_SIZE 440
#define MIN_Y_SIZE 340
LONG minX = MIN_X_SIZE;
LONG minY = MIN_Y_SIZE;

#define TIMER_WINDOW	1972	//  
#define TIMER_DELAY		1000	//  , 1 .

#define TIMER_WORK_DELAY_DEBUG	9000//  , 9 .

BOOL GCounter;
BOOL GConfirmExit;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame
//
IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_ACTIVATE()
	ON_WM_GETMINMAXINFO()
	ON_WM_SIZE()
	ON_WM_MOVE()
	ON_WM_TIMER()
	ON_WM_QUERYENDSESSION()
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	//
	// Exit.
	ON_COMMAND(ID_APP_EXIT, OnExit)
	//
	// Start query.
	ON_UPDATE_COMMAND_UI(ID_FILE_START, OnUpdateStart)
	ON_COMMAND(ID_FILE_START, OnStart)
	//
	// Tool bar.
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBAR, OnUpdateToolbar)
	ON_COMMAND_EX(ID_VIEW_TOOLBAR, OnToolbar)
	//
	// Status bar.
	ON_UPDATE_COMMAND_UI(ID_VIEW_STATUS_BAR, OnUpdateStatusbar)
	ON_COMMAND_EX(ID_VIEW_STATUS_BAR, OnStatusbar)

	ON_MESSAGE(WM_CLICKBUTTONSTART, OnClickButtonStart)
	//
	// Tray.
	ON_REGISTERED_MESSAGE(WindowTrayMessage, CMainFrame::TrayWndProc)
	ON_COMMAND(ID_VIEW_TRAY, OnSysTray)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TRAY, OnUpdateSysTray)
	ON_COMMAND(ID_TRAY_SHOW_WINDOW, OnShowFrame)
	ON_COMMAND(ID_TRAY_HIDE_WINDOW, OnShowFrame)
	
	ON_COMMAND(ID_TRAY_QUERY_START, OnStart)
	ON_COMMAND(ID_TRAY_QUERY_STOP, OnStart)
	ON_COMMAND(ID_TRAYMENUEXIT, OnExit)
	//
	// Select columns.
	ON_COMMAND(ID_VIEW_SELECTCOLUMNS, OnSelectColumns)
	//
	//  .
	ON_COMMAND(ID_VIEW_FONT, OnFont)
	//
	// Options time.
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_TIME1, OnUpdateOptionsTime1)
	ON_COMMAND(ID_OPTIONS_TIME1, OnOptionsTime1)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_TIME2, OnUpdateOptionsTime2)
	ON_COMMAND(ID_OPTIONS_TIME2, OnOptionsTime2)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_TIME3, OnUpdateOptionsTime3)
	ON_COMMAND(ID_OPTIONS_TIME3, OnOptionsTime3)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_TIME4, OnUpdateOptionsTime4)
	ON_COMMAND(ID_OPTIONS_TIME4, OnOptionsTime4)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_TIME5, OnUpdateOptionsTime5)
	ON_COMMAND(ID_OPTIONS_TIME5, OnOptionsTime5)
	//
	// Options change address.
	ON_COMMAND(ID_OPTIONS_CHANGEHOST, OnChangeHost)
	//
	// Close console.
	ON_COMMAND(ID_OPTIONS_CLOSECONSOLE, OnOptionsCloseConsole)
	//
	// Other stuff.
	ON_COMMAND(ID_OTHERSTUFF_MPUK1, OnMPUKBanlist)
	ON_COMMAND(ID_OTHERSTUFF_MPUK2, OnMPUKForum)
	ON_COMMAND(ID_OTHERSTUFF_MADRIXIS, OnMadrixis)
	ON_COMMAND(ID_OTHERSTUFF_VIDEO, OnVideoSettings)

	//}}AFX_MSG_MAP	
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Status line indicator.
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

//     -   .
static UINT BASED_CODE buttons[] =
{
	//   ,     "toolbar.bmp".
	ID_FILE_START,
	ID_APP_ABOUT,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

CMainFrame::CMainFrame()
{
	//   .
	SetMinSize(minX, minY);

	//  .
	m_hIcon			= AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hIconEnable	= AfxGetApp()->LoadIcon(IDI_ICON_ENABLE);
	m_hIconDisable	= AfxGetApp()->LoadIcon(IDI_ICON_DISABLE);

	// .
	m_bSysTray		= FALSE;
	m_sTooltip		= _T("");
	m_bIconEnabled	= FALSE;

	// .
	m_pQueryThread		= NULL;
	m_bIsQueryThread	= FALSE;
	
	//    .
	m_bExit			= FALSE;
	m_bStart		= FALSE;
	m_bToolbar		= TRUE;
	m_bStatusbar	= TRUE;

	GCounter		= FALSE;
	GConfirmExit	= FALSE;

	// .
	m_bOptionsTimer1= FALSE;
	m_bOptionsTimer2= FALSE;
	m_bOptionsTimer3= FALSE;
	m_bOptionsTimer4= FALSE;
	m_bOptionsTimer5= FALSE;

	m_bCommonTimer	= 3;		// ,  3 - 20 seconds.
	m_nTimer		= NULL;
	m_bBusy			= FALSE;
	m_nTimeDelay	= 5;
	m_nCounter		= 0;

	//   : , , .
	/*
	GColumnsName	= TRUE;
	GColumnsFrags	= TRUE;
	GColumnsPing	= TRUE;	
	// , .
	GColumnsTeam	= TRUE;
	GColumnsMesh	= TRUE;
	GColumnsSkin	= TRUE;
	GColumnsFace	= TRUE;
	GColumnsID		= TRUE;
	*/
	m_sName		= _T("Name");
	m_sFrags	= _T("Frags");
	m_sPing		= _T("Ping");
	m_sTeam		= _T("Team");
	m_sMesh		= _T("Mesh");
	m_sSkin		= _T("Skin");
	m_sFace		= _T("Face");
	m_sID		= _T("ID");

	m_sAppname		=_T("");
	m_sTempAppname	=_T("");
	m_sServername	=_T("");
	m_sQueryEnable	=_T("");
	m_sQueryDisable	=_T("");

	//
	//  , .
	//
	// Default Madrixis: Multiplay :: Public DM #13 (Deck16 - All Weapons)
	m_sDefaultHostAddress	= TEXT("85.236.100.115");
	m_nDefaultHostPort		= 8178;
	m_sHostAddress			= m_sDefaultHostAddress;
	m_nHostPort				= m_nDefaultHostPort;

	// ---------------------------------------------------
	//
	// Q U E R Y
	//
	// ---------------------------------------------------

	// --- GetInfo ---
	m_sHostName			= TEXT("");
	m_nGamePort			= 0;
	m_sMapName			= TEXT("");
	m_sMapTitle			= TEXT("");
	m_sMapDisplayName	= TEXT("");
	m_sGameType			= TEXT("");
	m_sGameMode			= TEXT("");
	m_nNumPlayers		= 0;
	m_nMaxPlayers		= 0;
	m_nGameVer			= 0;
	m_nMinNetVer		= 0;

	/*
	// --- GetStatus ---
	m_sAdminEmailText			=TEXT( "Admin Email" );
	m_sAdminNameText			=TEXT( "Admin Name" );
	m_sChangeLevelsText			=TEXT( "Change Levels" );
	m_sMultiplayerBotsText		=TEXT( "Bots in Multiplayer" );
	m_sFragLimitText			=TEXT( "Frag Limit" );
	m_sTimeLimitText			=TEXT( "Time Limit" );
	m_sGameModeText				=TEXT( "Game Mode" );
	m_sGameTypeText				=TEXT( "Game Type" );
	m_sGameVersionText			=TEXT( "Game Version" );
	m_sWorldLogText				=TEXT( "ngWorldStats" );
	m_sMutatorsText				=TEXT( "Mutators" );
	m_sTrueString				=TEXT( "Enabled" );
	m_sFalseString				=TEXT( "Disabled" );
	m_sServerAddressText		=TEXT( "Server Address" );
	m_sGoalTeamScoreText		=TEXT( "Required Team Score" );
	m_sMinPlayersText			=TEXT( "Bots Enter Game for Min. of" );
	m_sPlayersText				=TEXT( "Players" );
	m_sMaxTeamsText				=TEXT( "Max Teams" );
	m_sBalanceTeamsText			=TEXT( "Bots Balance Teams" );
	m_sPlayersBalanceTeamsText	=TEXT( "Force Team Balance" );
	m_sFriendlyFireText			=TEXT( "Friendly Fire Damage" );
	m_sMinNetVersionText		=TEXT( "Min. Compatible Version" );
	m_sBotSkillText				=TEXT( "Bot Skill" );
	m_sTournamentText			=TEXT( "Tournament Mode" );
	m_sServerModeText			=TEXT( "Server Mode" );
	m_sDedicatedText			=TEXT( "Dedicated" );
	m_sNonDedicatedText			=TEXT( "Non-Dedicated" );
	m_sWorldLogWorkingText		=TEXT( "ngWorldStats Status" );
	m_sWorldLogWorkingTrue		=TEXT( "Processing Stats Correctly" );
	m_sWorldLogWorkingFalse		=TEXT( "Not Processing Stats Correctly" );
	m_sPasswordText				=TEXT( "Requires Password" );

	// --- 3 ---
	m_sDefaultPlayerName	=TEXT( "Player" );
	*/

	m_sPlayerName			=TEXT( "" );
	m_nPlayerFrags			=0;
	m_nPlayerPing			=0;
	m_sPlayerTeam			=TEXT( "255" );
	m_sPlayerMesh			=TEXT( "" );
	m_sPlayerSkin			=TEXT( "" );
	m_sPlayerFace			=TEXT( "" );
	m_nPlayerID				=0;
	m_sPlayerStats			=TEXT( "" );
	m_nStatusDone			=FALSE;

	m_sTrueString			=TEXT( "Enabled" );
	m_sFalseString			=TEXT( "Disabled" );

	// ,   :
	m_sPlayer = TEXT( "" );

	loadstring();
}

/////////////////////////////////////////////////////////////////////////////
// loadstring
//
//  .
//
void CMainFrame::loadstring()
{
	//   .
	CString sAppname;
	sAppname.LoadString(AFX_IDS_APP_TITLE);
	if( sAppname.IsEmpty() )
	{
		sAppname = _T( "You Bastard!" );
	}
	m_sAppname += sAppname;

	//   ":Enable".
	CString sEnable;
	sEnable.LoadString(IDS_QUERY_ENABLE);
	if( sEnable.IsEmpty() )
	{
		sEnable = _T( "You Bastard!" );
	}
	m_sQueryEnable	+= sAppname;
	m_sQueryEnable	+= sEnable;

	//   ":Disable".
	CString sDisable;
	sDisable.LoadString(IDS_QUERY_DISABLE);
	if( sDisable.IsEmpty() )
	{
		sDisable = _T( "You Bastard!" );
	}
	m_sQueryDisable	+= sAppname;
	m_sQueryDisable	+= sDisable;

	//
	// For debugf.
	//
	
	//   "Start of query".
	m_sStartQuery.LoadString(IDS_DEBUGF_START);
	if( m_sStartQuery.IsEmpty() )
	{
		m_sStartQuery = _T( "You Bastard!" );
	}

	//   "End of query".
	m_sEndQuery.LoadString(IDS_DEBUGF_END);
	if( m_sEndQuery.IsEmpty() )
	{
		m_sEndQuery = _T( "You Bastard!" );
	}

}

/////////////////////////////////////////////////////////////////////////////
// ~CMainFrame
//
CMainFrame::~CMainFrame()
{
}
/////////////////////////////////////////////////////////////////////////////
// OnExit
//
void CMainFrame::OnExit()
{
	m_bExit = TRUE;
	PostMessage(WM_CLOSE);
}
/////////////////////////////////////////////////////////////////////////////
// OnDestroy
//
void CMainFrame::OnDestroy()
{
	CFrameWnd::OnDestroy();

	//  .
	StopQueryThread();

	//    .
	if( m_bSysTray )
		TrayMessage(NIM_DELETE);

	//
	//  .
	//
	CWinApp* pApp = AfxGetApp();

	//  :  /  (  ).
	pApp->WriteProfileInt(pszSection,_T("SystemTray"),m_bSysTray);

	pApp->WriteProfileInt(pszSection,_T("Toolbar"),m_bToolbar);
	pApp->WriteProfileInt(pszSection,_T("Statusbar"),m_bStatusbar);

	// ,  .
	if( m_bCommonTimer == 0 || m_bCommonTimer < 0 || m_bCommonTimer > 5)
		m_bCommonTimer = 3;
	pApp->WriteProfileInt(pszSection,_T("OptionsTimer"),m_bCommonTimer);

	//  .
	pApp->WriteProfileInt(pszSection,pszAppstart,m_bStart);
}

/////////////////////////////////////////////////////////////////////////////
// OnQueryEndSession
//
BOOL CMainFrame::OnQueryEndSession()
{
	CWnd* pWnd = AfxGetMainWnd();
	pWnd->FindWindow(pszAppclass,NULL);
	if( pWnd->IsWindowVisible() ) {
		pWnd->GetLastActivePopup();
		if( pWnd->IsIconic() ) {
			pWnd->ShowWindow(SW_RESTORE);
      	}		
		pWnd->SetForegroundWindow();
	}

	/*
	if( GConfirmExit==TRUE )
	{
		if( AfxMessageBox(_T("Query in progress. Do you want to end query, and terminate program?"),MB_YESNO | MB_ICONQUESTION) != IDYES) 
		{
			return 0;
		}
	}
	*/
	return 1;
}
/////////////////////////////////////////////////////////////////////////////
// OnClose
//
void CMainFrame::OnClose()
{
	// Confirm, if running others process ?
	if( GConfirmExit==TRUE )
	{
		if( AfxMessageBox(_T("Query in progress. Do you want to end query, and terminate program?"),
			MB_YESNO|MB_ICONQUESTION) != IDYES)
		{
			return;
		}
	}
	CFrameWnd::OnClose();
}

/////////////////////////////////////////////////////////////////////////////
// OnCreate

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if( CFrameWnd::OnCreate(lpCreateStruct)==-1 )
	{
		debugf( TEXT("-->FAILED: MainFrame: OnCreate") );
		return -1;
	}

	// Custom window messages.
	WindowTrayMessage = ::RegisterWindowMessage( TEXT("UT99ServerQueryOpen") );
	if( WindowTrayMessage == 0 )
	{
		debugf( TEXT("-->FAILED: Register Window Message") );
		return -1;
	}
	
	// Create toolbar.
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		debugf( TEXT("-->FAILED: Create toolbar") );
		return -1;
	}

	// TODO:  ,   .
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);

	// Create Staus Bar.
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		debugf( TEXT("-->FAILED: Create statusbar") );
		return -1;
	}
	// TODO:   ,    .
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	
	//
	//  -,   ,
	//   "Close console".
	//
	SelectMenu( GIsConsole );


	//
	//  .
	//
	CWinApp* pApp = AfxGetApp();

	//  /  (  ).
	m_bSysTray = pApp->GetProfileInt(pszSection,_T("SystemTray"),FALSE);
	if( m_bSysTray == TRUE )
	{
		//    .
		TrayMessage(NIM_ADD);
	}

	//  /  (Toolbar / Statusbar).
	m_bToolbar = pApp->GetProfileInt(pszSection,_T("Toolbar"),TRUE);
	m_bStatusbar = pApp->GetProfileInt(pszSection,_T("Statusbar"),TRUE);
	
	CControlBar* pBar=NULL;
	pBar=GetControlBar(AFX_IDW_TOOLBAR);
	ShowControlBar(pBar,m_bToolbar,FALSE);

	pBar=NULL;
	pBar=GetControlBar(AFX_IDW_STATUS_BAR);
	ShowControlBar(pBar,m_bStatusbar,FALSE);

	//  .
	m_bStart = pApp->GetProfileInt(pszSection,pszAppstart,FALSE);

	//   ,    3 (20 ).
	m_bCommonTimer = pApp->GetProfileInt(pszSection,_T("OptionsTimer"),FALSE);
	if( m_bCommonTimer == FALSE ) {
		m_nTimeDelay	= TIMER_QUERY_DELAY3;
		m_bCommonTimer	= 3;
		m_bOptionsTimer3 = TRUE;
	}
	if( m_bCommonTimer == 1 ) {
		m_nTimeDelay = TIMER_QUERY_DELAY1;
		m_bOptionsTimer1 = TRUE;
	}
	if( m_bCommonTimer == 2 ) {
		m_nTimeDelay	= TIMER_QUERY_DELAY2;
		m_bOptionsTimer2 = TRUE;
	}
	if( m_bCommonTimer == 3 ) {
		m_nTimeDelay	= TIMER_QUERY_DELAY3;
		m_bOptionsTimer3 = TRUE;
	}
	if( m_bCommonTimer == 4 ) {
		m_nTimeDelay	= TIMER_QUERY_DELAY4;
		m_bOptionsTimer4 = TRUE;
	}
	if( m_bCommonTimer == 5 ) {
		m_nTimeDelay	= TIMER_QUERY_DELAY5;
		m_bOptionsTimer5 = TRUE;
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// PreCreateWindow
//
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	CFrameWnd::PreCreateWindow(cs);

	WNDCLASS wndcls;
	BOOL Result = CFrameWnd::PreCreateWindow(cs);

	HINSTANCE hInstance = AfxGetInstanceHandle();

	// ,    .
	if( !::GetClassInfo(hInstance,pszAppclass,&wndcls) )
	{
		// Get default stuff.
		::GetClassInfo(hInstance,cs.lpszClass,&wndcls);
		wndcls.style &=~WS_EX_CLIENTEDGE;

		//   .
		wndcls.lpszClassName=pszAppclass;
		//wndcls.hIcon = ::LoadIcon(hInstance, MAKEINTRESOURCE(IDR_MAINFRAME));
		wndcls.hIcon = m_hIcon;
		ASSERT(wndcls.hIcon!=NULL);
		if( !AfxRegisterClass(&wndcls) )
			AfxThrowResourceException();
	}
	cs.lpszClass = pszAppclass;

	//      .
	CDisplayIC dc;
	CRect rectDisplay(0,0,dc.GetDeviceCaps(HORZRES),dc.GetDeviceCaps(VERTRES));

	CRect rect = theApp.m_rectFrame;
	if( rect.Width() > 0 && rect.Height() > 0 )
	{
		if( rectDisplay.PtInRect(rect.TopLeft()) && rectDisplay.PtInRect(rect.BottomRight()) )
		{
			cs.x	= rect.left;
			cs.y	= rect.top;
			cs.cx	= rect.Width();
			cs.cy	= rect.Height();
		}
	}
	else//    ,
	{	// -     ,
		// -    " ".
		int nWidth	= 800;
		int nHeight	= 576;		
		int nTemp	= rectDisplay.Width();
		if( nWidth > nTemp )
		{
			nWidth = 640;
			nHeight = 480;
		}
		cs.cx = nWidth;	//  .
		cs.cy = nHeight;//  .
		cs.x =( rectDisplay.Width() - cs.cx ) / 2;
		cs.y =( rectDisplay.Height() - cs.cy ) / 2; 
	}

	cs.style &= ~ FWS_ADDTOTITLE;//     " - Untitled".
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	return Result;
}

/////////////////////////////////////////////////////////////////////////////
// SetMinSize
//
void CMainFrame::SetMinSize(LONG x, LONG y )
{
	m_cxMin = x;
	m_cyMin = y;
	m_fxMin = 2*(GetSystemMetrics(SM_CXFRAME)+
		      GetSystemMetrics(SM_CXEDGE))   +
		      m_cxMin;
	m_fyMin = 2*(GetSystemMetrics(SM_CYFRAME)+
		      GetSystemMetrics(SM_CYEDGE))   +
              GetSystemMetrics(SM_CYCAPTION) +
              GetSystemMetrics(SM_CYMENU)    +
			  m_cyMin;
}
/////////////////////////////////////////////////////////////////////////////
// OnGetMinMaxInfo
//
void CMainFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
	lpMMI->ptMinTrackSize.x = m_fxMin;
	lpMMI->ptMinTrackSize.y = m_fyMin;
}

/////////////////////////////////////////////////////////////////////////////
// SelectMenu
//
//     .
//    "Close console".
//
void CMainFrame::SelectMenu(BOOL bMode)
{
	if( bMode==TRUE )
	{
		SetMenu(NULL);
		::DestroyMenu( GetMenu()->GetSafeHmenu() );
		CMenu menu;
		menu.LoadMenuW(IDR_MENU_CONSOLE);//  
		SetMenu(&menu);
	}
	else
    {
		SetMenu(NULL);
		::DestroyMenu(GetMenu()->GetSafeHmenu());
		CMenu menu;
		menu.LoadMenuW(IDR_MAINFRAME);
		SetMenu(&menu);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics
//
#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}
void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// ActivateFrame
//
//   ,   ..
//
void CMainFrame::ActivateFrame(int nCmdShow)
{
	if( m_hIcon == NULL )
		m_hIcon = LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_MAINFRAME));

	AfxGetApp()->m_pMainWnd->SetIcon( m_hIcon, FALSE );

	if( m_bStart==TRUE )
		PostMessage(WM_CLICKBUTTONSTART);

	if( m_bSysTray )
	{
		ShowWindow(SW_HIDE);
	}
	else
	{
		CFrameWnd::ActivateFrame(nCmdShow);
		OnIdleUpdateCmdUI();
		UpdateWindow();
	}
}
////////////////////////////////////////////////////////////////////////////////
// OnMove
//
void CMainFrame::OnMove(int x, int y) 
{
	CFrameWnd::OnMove(x, y);

	WINDOWPLACEMENT wp;
	wp.length = sizeof(wp);
	GetWindowPlacement(&wp);
	theApp.m_rectFrame = wp.rcNormalPosition;

	CView* pView = GetActiveView();
	if( pView!=NULL )
		pView->SendMessage(WM_MOVE);
}
////////////////////////////////////////////////////////////////////////////////
// OnSize
//
void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	if(nType == SIZE_MINIMIZED)
	{
		if( m_bSysTray )
		{
			ShowWindow(SW_HIDE);
		}
	} else {
		theApp.m_bShowFrame=( nType==SIZE_MAXIMIZED );
		if( nType==SIZE_RESTORED )
			GetWindowRect( theApp.m_rectFrame );
	}
}

/////////////////////////////////////////////////////////////////////////////
// ClearResponse
//
//  .
//
void CMainFrame::ClearResponse()
{
	CMainFrame *pFrame = DYNAMIC_DOWNCAST(CMainFrame, AfxGetApp()->m_pMainWnd);
	if( pFrame )
	{
		// Get a pointer to the container view.
		CAppView* pContView = DYNAMIC_DOWNCAST(CAppView, pFrame->GetActiveView());
		if( pContView )
		{
			pContView->ClearResponse();
		}
	}
}
/////////////////////////////////////////////////////////////////////////////
// BuildItems
//
void CMainFrame::BuildItems(int nIndex, LPCTSTR pszText)
{
	CMainFrame *pFrame = DYNAMIC_DOWNCAST(CMainFrame, AfxGetApp()->m_pMainWnd);
	if( pFrame )
	{
		// Get a pointer to the container view.
		CAppView* pContView = DYNAMIC_DOWNCAST(CAppView, pFrame->GetActiveView());
		if( pContView )
		{
			pContView->BuildItems(0, nIndex, pszText );

			/*
			pContView->BuildItems(0,INDEX_NAME,_T("Shvonder") );
			pContView->BuildItems(0,INDEX_FRAGS,_T("27"));
			pContView->BuildItems(0,INDEX_PING,_T("105"));

			pContView->BuildItems(0,INDEX_TEAM,_T("255"));
			pContView->BuildItems(0,INDEX_MESH,_T("Male Soldier"));
			pContView->BuildItems(0,INDEX_SKIN,_T("FCommandoSkins"));
			pContView->BuildItems(0,INDEX_FACE,_T("Boss"));
			pContView->BuildItems(0,INDEX_ID,_T("1"));
			*/

		}
	}
}

////////////////////////////////////////////////////////////////////////////////
// OnClickButtonStart
//
LRESULT CMainFrame::OnClickButtonStart(WPARAM wParam, LPARAM lParam)
{
	m_bStart = FALSE;
	OnStart();

	return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Tool Bar.
//
void CMainFrame::OnUpdateToolbar(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck( m_bToolbar );
}
BOOL CMainFrame::OnToolbar(UINT nID)
{
	m_bToolbar = m_bToolbar ? FALSE : TRUE;
	ASSERT(ID_VIEW_TOOLBAR == AFX_IDW_TOOLBAR);
	CControlBar* pBar = GetControlBar(nID);
	if( pBar != NULL )
	{
		//ShowControlBar(pBar, (pBar->GetStyle() & WS_VISIBLE) == 0, FALSE);
		ShowControlBar(pBar, m_bToolbar, FALSE);
		return TRUE;
	}
	return FALSE;
}
////////////////////////////////////////////////////////////////////////////////
// Status Bar.
//
void CMainFrame::OnUpdateStatusbar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( m_bStatusbar );
}
BOOL CMainFrame::OnStatusbar(UINT nID)
{
	m_bStatusbar = m_bStatusbar ? FALSE : TRUE;
	ASSERT(ID_VIEW_STATUS_BAR == AFX_IDW_STATUS_BAR);
	CControlBar* pBar = GetControlBar(nID);
	if( pBar != NULL )
	{
		//ShowControlBar(pBar, (pBar->GetStyle() & WS_VISIBLE) == 0, FALSE);
		ShowControlBar(pBar, m_bStatusbar, FALSE);
		return TRUE;
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// OnSelectColumns
//
//  .
//
void CMainFrame::OnSelectColumns()
{
	CChangeColumns dlg;
	dlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// OnFont
//
//  .
//
void CMainFrame::OnFont()
{
	CMainFrame *pFrame = DYNAMIC_DOWNCAST(CMainFrame, AfxGetApp()->m_pMainWnd);
	if( pFrame )
	{
		CAppView* pContView = DYNAMIC_DOWNCAST(CAppView, pFrame->GetActiveView());
		if( pContView )
		{
			//     .
			pContView->ChangeFont();
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// OnChangeHost
//
//   .
//
void CMainFrame::OnChangeHost()
{
	//CFavoriteDlg fDlg;
	//fDlg.DoModal();
	//return;

	CString sText;
	sText.LoadString(IDS_MSG1);
	if( sText.IsEmpty() ) {
		sText = _T( "You Bastard!" );
	}

	CReadmeDlg dlg;
	dlg.m_sTitle	= _T("No change (sorry)");
	dlg.m_sText		= sText;
	dlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// OnOptionsCloseConsole
//
//  .
//
void CMainFrame::OnOptionsCloseConsole()
{
	GLogConsole->Show( FALSE );
	GIsConsole = FALSE;

	SelectMenu(GIsConsole);
	//AfxGetApp()->m_pMainWnd->SendMessage(ID_OPTIONS_CLOSECONSOLE);
}

/////////////////////////////////////////////////////////////////////////////
// Tray (   ).
//
LRESULT CMainFrame::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	LRESULT retval = 0;
	switch(message)
	{
	case WM_TIMER:
		{
			if( wParam==TIMER_WINDOW )
			{
				if( GIsQuery == FALSE )
				{
					if( m_nCounter == m_nTimeDelay )
					{
						m_bBusy		= FALSE;
						m_nCounter	= 0;
						StopTimer();
						return retval;
					}

					m_bBusy	= TRUE;
					
					//   .
					++m_nCounter;
				}
			}
		}
		break;

	case WM_CLOSE:
		{
		if( m_bExit == TRUE )
		{
			PostMessage(WM_CLOSE);
			return CFrameWnd::WindowProc(message,wParam,lParam);
		}
		if( m_bSysTray == TRUE )
		{
			ShowWindow(SW_HIDE);
			return retval;
		}
		PostMessage(WM_CLOSE);
		return CFrameWnd::WindowProc(message,wParam,lParam);
		}

	if( message == WindowTrayMessage )
		return TrayWndProc( wParam, lParam );

	default:
		return CFrameWnd::WindowProc(message,wParam,lParam);
	}
	return retval;
}

////////////////////////////////////////////////////////////////////////////////
// OnUpdateSysTray
//
void CMainFrame::OnUpdateSysTray(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck( m_bSysTray );	
}
/////////////////////////////////////////////////////////////////////////////
// OnSysTray
//
void CMainFrame::OnSysTray()
{
	m_bSysTray = !m_bSysTray;
	if( m_bSysTray )
	{
		// Add icon to system tray.
		TrayMessage(NIM_ADD);
		m_bIconEnabled = TRUE;

		if( m_nPlayerID > 0 )
			AddTrayIcon( m_nPlayerID );

		if( !m_sPlayer.IsEmpty() )
			AddTrayMessage(m_sPlayer);
		else
			AddTrayMessage(m_sQueryEnable);

		if( !m_sPlayer.IsEmpty() )
			m_sPlayer.Empty();
	}
	else
	{
		// Delete icon to system tray.
		TrayMessage(NIM_DELETE);
		m_bIconEnabled = FALSE;
	}
}

/////////////////////////////////////////////////////////////////////////////
// OnTimer
//
void CMainFrame::OnTimer(UINT nIDEvent) 
{
}

/////////////////////////////////////////////////////////////////////////////
// StartTimer
//
void CMainFrame::StartTimer()
{
	if( m_nTimer != NULL )
		StopTimer();

	m_nCounter = 0;

	m_nTimer = SetTimer(TIMER_WINDOW,TIMER_DELAY,0);
	if( m_nTimer==NULL )
	{
		//   ,   ,  .
		AfxGetApp()->m_pMainWnd->ShowWindow(SW_HIDE);
		AfxMessageBox( _T("-->FAILED: SetTimer()" ), MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
		ExitProcess( 0x0FFFFFFFF );
	}
}
/////////////////////////////////////////////////////////////////////////////
// StopTimer
//
void CMainFrame::StopTimer()
{
	if( m_nTimer != NULL )
	{
		KillTimer(m_nTimer);
		m_nTimer = NULL;
	}
}

//////////////////////////////////////////////////////////////////////////////
// CheckEngine

BOOL CMainFrame::CheckEngine()
{
	BOOL Result = 0;
	if( m_bIsQueryThread == FALSE )
		Result = 0x0FFFFFFFF;
	return Result;

	//while( m_bIsQueryThread == FALSE )
	//{
	//	Sleep(5);
	//}
}

/////////////////////////////////////////////////////////////////////////////
// OnStart
//
void CMainFrame::OnStart()
{
	m_bStart = m_bStart ? FALSE : TRUE;

	if( m_bStart )
	{
		if( !m_sServername.IsEmpty() )
			m_sServername.Empty();

		//  .
		AfxGetApp()->m_pMainWnd->SetIcon( m_hIconEnable, FALSE );

		if( m_bSysTray == TRUE )
		{
			DefaultData();

			AddTrayIcon( m_nPlayerID );
			AddTrayMessage( m_sQueryEnable );

			/*
			//  .
			AddTrayIcon( m_nPlayerID );

			//   -     .
			//AddTrayMessage( m_sQueryEnable );
			if( !m_sPlayer.IsEmpty() )
				AddTrayMessage(m_sPlayer);
			else
				AddTrayMessage(m_sQueryEnable);

			if( !m_sPlayer.IsEmpty() )
				m_sPlayer.Empty();

			if( m_nPlayerID > 0 )
				AddTrayIcon( m_nPlayerID );
			*/
		}

		StartQueryThread();
	}
	else
	{
		//  .
		AfxGetApp()->m_pMainWnd->SetWindowText( m_sAppname );

		//  .
		AfxGetApp()->m_pMainWnd->SetIcon( m_hIcon, FALSE );

		//  .
		StopQueryThread();

		//  .
		DefaultData();
		
		if( m_bSysTray == TRUE )
		{
			//    .
			AddTrayIcon( APP_STOP );

			//  , .
			AddTrayMessage( m_sQueryDisable );
		}
		
		GCounter	= 0;
		m_bBusy		= FALSE;
		m_nCounter	= 0;
	}
}
void CMainFrame::OnUpdateStart(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck( m_bStart );
}

/////////////////////////////////////////////////////////////////////////////
// StartQueryThread
//
int CMainFrame::StartQueryThread()
{
	m_bIsQueryThread = TRUE;

	m_pQueryThread=AfxBeginThread( QueryThreadEntry, this );
	m_pQueryThread->m_bAutoDelete=FALSE;
	m_pQueryThread->SetThreadPriority( THREAD_PRIORITY_LOWEST );
	if( m_pQueryThread==NULL )
	{
			m_bIsQueryThread=FALSE;
			AfxMessageBox(_T("-->FAILED: Could not create thread.\nYour system may be misbehaving."),MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
			//debugf( TEXT("-->FAILED: Could not create thread") );
			AfxGetApp()->m_pMainWnd->SendMessage(WM_CLOSE);
			return 1;
	}
	debugf( TEXT("Handle poll main: Start") );
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// StopQueryThread
//
int CMainFrame::StopQueryThread()
{
	StopTimer();

	m_bIsQueryThread = FALSE;

	if( m_pQueryThread != NULL )
	{
		WaitForSingleObject( m_pQueryThread->m_hThread, INFINITE );
		delete m_pQueryThread;
		m_pQueryThread = NULL;

		debugf( TEXT("Handle poll main: Stop") );
		return 0;
	}
	if( m_pQueryThread!=NULL)
	{
		debugf( TEXT("-->FAILED: Handle poll main: Stop") );
		return 1;
	}
	return 0;
}
/////////////////////////////////////////////////////////////////////////////
// QueryThreadEntry
//
UINT QueryThreadEntry(LPVOID pParam)
{
	CMainFrame* pThis=(CMainFrame*)pParam;

	int Result = 0;
	while( pThis->m_bIsQueryThread )
	{
		Result = pThis->HandleQueryPoll();
		if( Result==0x0FFFFFFFF )
		{
			return Result;
		}
		Sleep(20);
	}	
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// HandleQueryPoll

int CMainFrame::HandleQueryPoll()
{
	int Result = CheckEngine();
	if( Result == 0x0FFFFFFFF )
		return Result;
	
	if( m_bBusy == TRUE )
		return Result;

	//  .
	GIsQuery = TRUE;
	
	Result = DoQuery();
	if( Result == 0x0FFFFFFFF )
	{
		return Result;
	}
	if( Result == -2 || Result == -3 )
	{	
		//     .
		if( !m_sServername.IsEmpty() )
			m_sServername.Empty();

		m_sTempAppname.Format( _T("%s (Running)"), m_sAppname );
		AfxGetApp()->m_pMainWnd->SetWindowText( m_sTempAppname );
		
		m_nPlayerID = 0;
		if( !m_sPlayer.IsEmpty() )
			m_sPlayer.Empty();
		if( m_bSysTray == TRUE )
		{
			AddTrayMessage(m_sQueryEnable);
		}
	}

	// Test
	//
	//ClearResponse();
	//BuildItems( INDEX_NAME, _T("Shvonder") );
	//BuildItems( INDEX_NAME, _T("TEST") );

	//     .
	if( m_sServername.IsEmpty() )
	{
		m_sTempAppname.Format( _T("%s (Running)"), m_sAppname );
		AfxGetApp()->m_pMainWnd->SetWindowText( m_sTempAppname );
	}
	else
	{
		m_sTempAppname.Format( _T("%s - %s"), m_sAppname, m_sServername );
		AfxGetApp()->m_pMainWnd->SetWindowText( m_sTempAppname );
	}

	if( m_bSysTray == TRUE )
	{
		//    .
		AddTrayIcon(m_nPlayerID);

		//    .
		if( !m_sPlayer.IsEmpty() )
			AddTrayMessage(m_sPlayer);
		else
			AddTrayMessage(m_sQueryEnable);

		if( !m_sPlayer.IsEmpty() )
			m_sPlayer.Empty();
	}

	Result = CheckEngine();
	if( Result )
		return Result;

	GIsQuery = FALSE;
	m_bBusy = TRUE;

	StartTimer();
	return Result;
}

/////////////////////////////////////////////////////////////////////////////
// <<eof>> MainFrm.cpp
/////////////////////////////////////////////////////////////////////////////
