/////////////////////////////////////////////////////////////////////////////
// ListViewEx.h

#pragma once

#include "HeaderCtrlEx.h"

class CListViewEx : public CListView
{
	DECLARE_DYNAMIC(CListViewEx)

public:
	CListViewEx();
	virtual ~CListViewEx();

	//    .
	void ColumnVisible(int nIndex, BOOL bVisible);

	BOOL SaveState(LPCTSTR szSection);
	BOOL RestoreState(LPCTSTR szSection);
	BOOL VerifyOrderArray(int* piArray, int nCount);
	BOOL SetItemUserData(int nItem, DWORD_PTR dwData);

	CListViewEx& GetListCtrlExt()
	{
		return *this;
	}
	CHeaderCtrlEx* GetHeaderCtrl()
	{
		return m_pHeader;
	}

// Overrides
protected:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CListViewEx)
	public:
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

	int GetColumnCount();
	BOOL DeleteAllColumns();
	BOOL SortTextItems(int nCol, BOOL bAscending, int low = 0, int high = -1);

// Implementation
protected:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:	
	CHeaderCtrlEx* m_pHeader;

	int		m_nSortedCol;
	BOOL	m_bSortAscending;

	typedef struct ColumnInfo
	{
		int m_nColumn;
		ColumnInfo(int nColumn);
	}ColumnInfo;

	typedef struct ItemData
	{
		DWORD_PTR m_dwUserData;
		ItemData(DWORD_PTR dwUserData = NULL);
		virtual ~ItemData();
	}ItemData;

	CPtrArray m_pData;
	CPtrArray m_pInfo;

	int m_cxClient;

protected:
	void RepaintSelectedItems();
	BOOL DeleteAllItemsData();
	BOOL DeleteAllColumnInfo();
	DWORD_PTR GetItemDataInternal(int nItem) const;
	
	// Generated message map functions
protected:
	//{{AFX_MSG(CListViewEx)
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnItemclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnNmRclickHeader(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg LRESULT OnInsertItem(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnInsertColumn(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteColumn(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// <<eof>> ListViewEx.h
/////////////////////////////////////////////////////////////////////////////
