/////////////////////////////////////////////////////////////////////////////
// ListViewEx.cpp

#include "stdafx.h"
#include "ListViewEx.h"
#include "resource.h"
#include "ChangeColumns.h"
#include "AppStrings.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CListViewEx

CListViewEx::ColumnInfo::ColumnInfo(int nColumn)
{
}
CListViewEx::ItemData::ItemData(DWORD_PTR dwUserData)
	:m_dwUserData(dwUserData)
{
}
CListViewEx::ItemData::~ItemData()
{
}

IMPLEMENT_DYNAMIC(CListViewEx, CListView)

CListViewEx::CListViewEx()
	:m_pHeader(NULL)
	,m_cxClient(0)
{
	m_nSortedCol		= -1;
	m_bSortAscending	= TRUE;

	m_pHeader = new CHeaderCtrlEx;
}

CListViewEx::~CListViewEx()
{
	DeleteAllItemsData();
	DeleteAllColumnInfo();
	delete m_pHeader;
}
void CListViewEx::OnDestroy() 
{
	CListView::OnDestroy();

	//   .
	SaveState( pszSection );
}

BEGIN_MESSAGE_MAP(CListViewEx, CListView)
	//{{AFX_MSG_MAP(CListViewEx)
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_NOTIFY(NM_RCLICK, 0, OnNmRclickHeader)
	ON_NOTIFY(HDN_ITEMCLICKA, 0, OnItemclick) 
	ON_NOTIFY(HDN_ITEMCLICKW, 0, OnItemclick)
	//}}AFX_MSG_MAP
	ON_MESSAGE(LVM_INSERTITEM, OnInsertItem)
	ON_MESSAGE(LVM_INSERTCOLUMN, OnInsertColumn)
	ON_MESSAGE(LVM_DELETECOLUMN, OnDeleteColumn)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListViewEx diagnostics

#ifdef _DEBUG
void CListViewEx::AssertValid() const
{
	CListView::AssertValid();
}
void CListViewEx::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CListViewEx message handlers

void CListViewEx::OnInitialUpdate() 
{
	CListView::OnInitialUpdate();

	DWORD dwOldStyle = GetStyle();
	ModifyStyle(LVS_TYPEMASK, LVS_REPORT);
	::SetWindowLong(m_hWnd, GWL_STYLE, dwOldStyle);
	if( m_pHeader->m_hWnd == NULL )
	{
		HWND hWnd = (HWND)::SendMessage(m_hWnd,LVM_GETHEADER,0,0);
		m_pHeader->SubclassWindow(hWnd);
	}
}

/////////////////////////////////////////////////////////////////////////////
//    .

void CListViewEx::ColumnVisible(int nIndex, BOOL bVisible)
{
	m_pHeader->SetVisible(nIndex,bVisible);
}

void CListViewEx::OnSize(UINT nType, int cx, int cy)
{
	m_cxClient = cx;
	CListView::OnSize(nType, cx, cy);
}

void CListViewEx::OnPaint() 
{
	if( (GetStyle() & LVS_TYPEMASK)==LVS_REPORT )
	{
		CRect rcAllLabels;
		GetListCtrl().GetItemRect(0,rcAllLabels,LVIR_BOUNDS);
		if( rcAllLabels.right < m_cxClient )
		{
			CPaintDC dc(this);

			CRect rcClip;
			dc.GetClipBox(rcClip);

			rcClip.left=min(rcAllLabels.right-1,rcClip.left);
			rcClip.right=m_cxClient;

			InvalidateRect(rcClip,FALSE);
		}
	}
	CListView::OnPaint();
}

void CListViewEx::OnKillFocus(CWnd* pNewWnd) 
{
	CListView::OnKillFocus(pNewWnd);

	// check if we are losing focus to label edit box
	if(pNewWnd != NULL && pNewWnd->GetParent() == this)
		return;

	// repaint items that should change appearance
	if((GetStyle() & LVS_TYPEMASK) == LVS_REPORT)
		RepaintSelectedItems();
}

void CListViewEx::OnSetFocus(CWnd* pOldWnd) 
{
	CListView::OnSetFocus(pOldWnd);
	
	// check if we are getting focus from label edit box
	if(pOldWnd!=NULL && pOldWnd->GetParent()==this)
		return;

	// repaint items that should change appearance
	if((GetStyle() & LVS_TYPEMASK)==LVS_REPORT)
		RepaintSelectedItems();
}

LRESULT CListViewEx::OnInsertItem(WPARAM wParam, LPARAM lParam)
{
	int nPos = (int)Default();
	LPLVITEM pItem = (LPLVITEM)lParam;
	SetItemUserData(nPos, pItem->iItem);
	return nPos;
}

LRESULT CListViewEx::OnInsertColumn(WPARAM wParam, LPARAM lParam)
{
	int nPos = (int)Default(); // call default control procedure

	LPLVCOLUMN pCol = (LPLVCOLUMN)lParam;
	CHeaderCtrlEx::CItemData* pData = new CHeaderCtrlEx::CItemData(pCol->cx, TRUE, TRUE);
	m_pHeader->SetItemData((int)wParam, (DWORD_PTR)pData);

	return nPos;
}

LRESULT CListViewEx::OnDeleteColumn(WPARAM wParam, LPARAM lParam)
{
	CHeaderCtrlEx::CItemData* pData = (CHeaderCtrlEx::CItemData*)m_pHeader->GetItemData((int)wParam);
	if( pData )
		delete pData;

	return Default();
}

int CListViewEx::GetColumnCount()
{
	if( m_pHeader )
		return m_pHeader->GetItemCount();

	LVCOLUMN col;
	col.mask = LVCF_WIDTH;
	int Result = 0;
	while( GetListCtrl().GetColumn( ++Result, &col) );
	return Result;
}

BOOL CListViewEx::SetItemUserData(int nItem, DWORD_PTR dwData)
{
	ItemData* pData = (ItemData*)GetItemDataInternal(nItem);
	if( pData )
		pData->m_dwUserData = dwData;
	else
	{
		pData = new ItemData(dwData);
		m_pData.Add(pData);
	}
	return GetListCtrl().SetItemData(nItem, (DWORD_PTR)pData);
}

DWORD_PTR CListViewEx::GetItemDataInternal(int nItem) const
{
	return GetListCtrl().GetItemData(nItem);
}

BOOL CListViewEx::DeleteAllColumns()
{
	while( GetListCtrl().DeleteColumn(0) );
	return( GetColumnCount()==0 );
}

BOOL CListViewEx::DeleteAllItemsData()
{
	while(m_pData.GetSize() > 0)
	{
		ItemData* pData = (ItemData*)m_pData.GetAt(0);
		if( pData )
			delete pData;

		m_pData.RemoveAt(0);
	}
	return TRUE;
}

BOOL CListViewEx::DeleteAllColumnInfo()
{
	while( m_pInfo.GetSize() > 0 )
	{
		ColumnInfo* pData = (ColumnInfo*)m_pInfo.GetAt(0);
		if( pData )
			delete pData;

		m_pInfo.RemoveAt(0);
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//       .
//  .

void CListViewEx::OnItemclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	HD_NOTIFY *phdn = (HD_NOTIFY *) pNMHDR;
	if( phdn->iButton == 0 )
	{
		if( phdn->iItem == m_nSortedCol )
			m_bSortAscending = !m_bSortAscending;
		else
			m_bSortAscending = TRUE;

		m_nSortedCol = phdn->iItem;
		SortTextItems(m_nSortedCol,m_bSortAscending);

		m_pHeader->SetSortImage(m_nSortedCol,m_bSortAscending);
	}
	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
//    .

void CListViewEx::OnNmRclickHeader(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMHEADER phdr = reinterpret_cast<LPNMHEADER>(pNMHDR);

	CMenu menu;
	CPoint point;
	GetCursorPos(&point);

	/*
	int nHeaderItemCount = m_pHeader->GetItemCount();
	int nHeaderRemovableItemCount = m_pHeader->GetRemovableItemCount();
	if(nHeaderItemCount > nHeaderRemovableItemCount && menu.CreatePopupMenu())
	{
		const int TEXT_LEN = 64;
		const TCHAR TEXT_TAIL[] = _T("...");
		TCHAR szText[TEXT_LEN + sizeof(TEXT_TAIL) - 1];
		
		HDITEM hdi;
		hdi.mask		= HDI_TEXT;
		hdi.pszText		= szText;
		hdi.cchTextMax	= TEXT_LEN;

		int nCount = m_pHeader->GetItemCount();
		for(int i = 0;i < nCount;++i)
		{
			if(! m_pHeader->GetItem(i, &hdi))
				return;

			if(hdi.cchTextMax == TEXT_LEN - 1)
				lstrcat(szText, TEXT_TAIL);

			UINT nFlags = MF_STRING;
			if(! m_pHeader->GetRemovable(i))
				nFlags |= MF_GRAYED | MF_CHECKED;

			if(m_pHeader->GetVisible(i))
				nFlags |= MF_CHECKED;

			if(! menu.AppendMenu(nFlags, i + 1, szText))
				return;
		}
		UINT nIndex = menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD, point.x, point.y, this);
		if(nIndex > 0)
		{
			--nIndex;
			BOOL bVisible = m_pHeader->GetVisible(nIndex);
			m_pHeader->SetVisible(nIndex,! bVisible);
		}
	}
	*/

	if( menu.CreatePopupMenu() )
	{
		TCHAR szText[] = _T("Select Columns...");
		UINT nFlags = MF_STRING;
		if( !menu.AppendMenu(nFlags, 1, szText) )
			return;
		
		UINT nIndex = menu.TrackPopupMenu(
			TPM_LEFTALIGN|TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x,point.y,this);
		if( nIndex > 0 )
		{
				CChangeColumns dlg;
				dlg.DoModal();
		}
	}
	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
//   .

BOOL CListViewEx::SaveState(LPCTSTR szSection)
{
	CWinApp* pApp = (CWinApp*)AfxGetApp();
	int nCount = m_pHeader->GetItemCount();
	pApp->WriteProfileInt(szSection,_T("ColumnCount"),nCount);

	int* nColOrder = new int[nCount];
	m_pHeader->GetOrderArray(nColOrder,nCount);
	pApp->WriteProfileBinary(szSection,_T("ColumnOrder"),(BYTE*)nColOrder,sizeof(int) * nCount);
	delete []nColOrder;

	int* nColWidth = new int[nCount];
	m_pHeader->GetWidthArray(nColWidth,nCount);
	pApp->WriteProfileBinary(szSection,_T("ColumnWidth"),(BYTE*)nColWidth,sizeof(int) * nCount);
	delete []nColWidth;

	int* nColVisible = new int[nCount];
	m_pHeader->GetVisibleArray(nColVisible,nCount);
	pApp->WriteProfileBinary(szSection,_T("ColumnVisible"),(BYTE*)nColVisible,sizeof(int) * nCount);
	delete []nColVisible;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//   .

BOOL CListViewEx::RestoreState(LPCTSTR szSection)
{
	CWinApp* pApp = (CWinApp*)AfxGetApp();
	int nCount = pApp->GetProfileInt(szSection,_T("ColumnCount"), 0);
	if(nCount != m_pHeader->GetItemCount())
		return FALSE;

	UINT nBytes;
	BOOL bReturn = FALSE;

	int* nColOrder = NULL;
	if((pApp->GetProfileBinary(szSection,_T("ColumnOrder"),(BYTE**)&nColOrder,&nBytes) && nBytes == sizeof(int) * nCount))
	{
		bReturn = VerifyOrderArray(nColOrder,nCount) && m_pHeader->SetOrderArray(nCount,nColOrder);
		ASSERT(bReturn);
	}
	delete []nColOrder;
	if(! bReturn)
		return FALSE;

	bReturn = FALSE;
	int* nColWidth = NULL;
	if((pApp->GetProfileBinary(szSection,_T("ColumnWidth"),(BYTE**)&nColWidth,&nBytes) && nBytes == sizeof(int) * nCount))
		bReturn = m_pHeader->SetWidthArray(nCount,nColWidth);
	delete []nColWidth;
	if(! bReturn)
		return FALSE;

	bReturn = FALSE;
	int* nColVisible = NULL;
	if((pApp->GetProfileBinary(szSection,_T("ColumnVisible"),(BYTE**)&nColVisible,&nBytes) && nBytes == sizeof(int) * nCount))
		bReturn = m_pHeader->SetVisibleArray(nCount,nColVisible);
	delete []nColVisible;

	return bReturn;
}

BOOL CListViewEx::VerifyOrderArray(int* piArray, int nCount)
{
	for(int i = 0;i < nCount;++i)
	{
		if(! (piArray[i] >= 0 && piArray[i] <= nCount - 1))
			return FALSE;

		// Compare with items after current one.
		for(int j = i + 1;j < nCount;++j)
		{
			if(piArray[i] == piArray[j])
				return FALSE;
		}
	}
	return TRUE;
}

void CListViewEx::RepaintSelectedItems()
{
	CRect rcBounds, rcLabel;

	// Invalidate focused item so it can repaint 
	int nItem = GetListCtrl().GetNextItem(-1, LVNI_FOCUSED);

	if(nItem != -1)
	{
		GetListCtrl().GetItemRect(nItem, rcBounds, LVIR_BOUNDS);
		GetListCtrl().GetItemRect(nItem, rcLabel, LVIR_LABEL);
		rcBounds.left = rcLabel.left;

		InvalidateRect(rcBounds, FALSE);
	}

	// Invalidate selected items depending on LVS_SHOWSELALWAYS
	if(!(GetStyle() & LVS_SHOWSELALWAYS))
	{
		for(nItem = GetListCtrl().GetNextItem(-1, LVNI_SELECTED);
			nItem != -1; nItem = GetListCtrl().GetNextItem(nItem, LVNI_SELECTED))
		{
			GetListCtrl().GetItemRect(nItem, rcBounds, LVIR_BOUNDS);
			GetListCtrl().GetItemRect(nItem, rcLabel, LVIR_LABEL);
			rcBounds.left = rcLabel.left;

			InvalidateRect(rcBounds, FALSE);
		}
	}
	UpdateWindow();
}

/////////////////////////////////////////////////////////////////////////////
// SortTextItems	- Sort the list based on column text
// Returns			- Returns true for success
// nCol				- column that contains the text to be sorted
// bAscending		- indicate sort order
// low				- row to start scanning from - default row is 0
// high				- row to end scan. -1 indicates last row

BOOL CListViewEx::SortTextItems(int nCol, BOOL bAscending, int low, int high)
{
	if( nCol >= ((CHeaderCtrl*)GetDlgItem(0))->GetItemCount() )
		return FALSE;

	if( high == -1 )
		high = GetListCtrl().GetItemCount() - 1;

	int lo = low;
	int hi = high;
	CString midItem;

	if( hi <= lo )
		return FALSE;

	midItem = GetListCtrl().GetItemText( (lo+hi)/2, nCol );

	// loop through the list until indices cross
	while( lo <= hi )
	{
		// rowText will hold all column text for one row
		CStringArray rowText;

		// find the first element that is greater than or equal to
		// the partition element starting from the left Index.
		if( bAscending ) {
			while( ( lo < high ) && ( GetListCtrl().GetItemText(lo, nCol) < midItem ) )
				++lo;
		}
		else {
			while( ( lo < high ) && ( GetListCtrl().GetItemText(lo, nCol) > midItem ) )
				++lo;
		}

		// find an element that is smaller than or equal to
		// the partition element starting from the right Index.
		if( bAscending ) {
			while( ( hi > low ) && ( GetListCtrl().GetItemText(hi, nCol) > midItem ) )
				--hi;
		}

		else {
			while( ( hi > low ) && ( GetListCtrl().GetItemText(hi, nCol) < midItem ) )
				--hi;
		}

		// if the indexes have not crossed, swap
		// and if the items are not equal
		if( lo <= hi )
		{
			// swap only if the items are not equal
			if( GetListCtrl().GetItemText(lo, nCol) != GetListCtrl().GetItemText(hi, nCol))
			{
				// swap the rows
				LV_ITEM lvitemlo, lvitemhi;
				int nColCount =
					((CHeaderCtrl*)GetDlgItem(0))->GetItemCount();
				rowText.SetSize( nColCount );
				int i;
				for( i=0; i<nColCount; i++)
					rowText[i] = GetListCtrl().GetItemText(lo, i);
				lvitemlo.mask = LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
				lvitemlo.iItem = lo;
				lvitemlo.iSubItem = 0;
				lvitemlo.stateMask = LVIS_CUT | LVIS_DROPHILITED |
					LVIS_FOCUSED | LVIS_SELECTED |
					LVIS_OVERLAYMASK | LVIS_STATEIMAGEMASK;
				
				lvitemhi = lvitemlo;
				lvitemhi.iItem = hi;
				
				GetListCtrl().GetItem( &lvitemlo );
				GetListCtrl().GetItem( &lvitemhi );
				
				for( i=0; i<nColCount; i++)
					GetListCtrl().SetItemText(lo, i, GetListCtrl().GetItemText(hi, i));
				
				lvitemhi.iItem = lo;
				GetListCtrl().SetItem( &lvitemhi );
				
				for( i=0; i<nColCount; i++)
					GetListCtrl().SetItemText(hi, i, rowText[i]);
				
				lvitemlo.iItem = hi;
				GetListCtrl().SetItem( &lvitemlo );
			}
			
			++lo;
			--hi;
		}
	}
	
	// If the right index has not reached the left side of array
	// must now sort the left partition.
	if( low < hi )
		SortTextItems( nCol, bAscending , low, hi);
	
	// If the left index has not reached the right side of array
	// must now sort the right partition.
	if( lo < high )
		SortTextItems( nCol, bAscending , lo, high );
	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// <<eof>> ListViewEx.cpp
/////////////////////////////////////////////////////////////////////////////
