/////////////////////////////////////////////////////////////////////////////
// HeaderCtrlEx.h

#pragma once

class CHeaderCtrlEx : public CHeaderCtrl
{
	DECLARE_DYNAMIC(CHeaderCtrlEx)

public:
	int m_nOffset;

	class CItemData
	{
	public:
		CItemData(int nWidth, BOOL bRemovable, BOOL bVisible)
		{
			m_nWidth = nWidth;
			m_bVisible = bVisible;
			m_bRemovable = bRemovable;
		}
		int m_nWidth;
		BOOL m_bVisible;
		BOOL m_bRemovable;
	};

public:
	CHeaderCtrlEx();
	virtual ~CHeaderCtrlEx();

	//{{AFX_VIRTUAL(CHeaderCtrlEx)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

	int SetSortImage( int nCol, BOOL bAsc );
	int GetItemWidth(int nIndex);
	int IndexToOrder(int nIndex);
	int FindVisibleItem(int nIndex);
	BOOL SetItemWidth(int nIndex, int nWidth);
	BOOL GetWidthArray(int* piArray, int nCount);
	BOOL SetWidthArray(int nCount, int* piArray);
	DWORD_PTR GetItemData(int nIndex);
	BOOL SetItemData(int nIndex, DWORD_PTR dwData);
	BOOL GetVisibleArray(int* piArray, int nCount);
	BOOL SetVisibleArray(int nCount, int* piArray);
	BOOL GetVisible(int nIndex);
	void SetVisible(int nIndex, BOOL bVisible);
	BOOL GetRemovable(int nIndex);
	void SetRemovable(int nIndex, BOOL bRemovable);
	void ResetItemWidth(int nIndex);
	BOOL SetOrderArray(int nCount, LPINT piArray);
	int GetVisibleItemCount();
	int GetRemovableItemCount();

protected:
	BOOL m_nItemWidth;
	CPoint m_ptDragEnd;
	CPoint m_ptDragMove;
	CPoint m_ptDragStart;
	int m_nDraggingItem;
	BOOL m_bDragFullWindow;

	int  m_nSortCol;
	BOOL m_bSortAsc;

protected:
	void DrawDragDivider();
	void BeginDragDivider();
	int	ItemFromPoint(CPoint point);
	void EndDragDivider(BOOL bSubmit);

protected:
	//{{AFX_MSG(CHeaderCtrlEx)
	afx_msg void OnDestroy();
	afx_msg void OnCaptureChanged(CWnd* pWnd);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG
	afx_msg LRESULT OnHdnEndDrag(WPARAM wParam, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg void OnWindowPosChanging(WINDOWPOS FAR* lpwndpos);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// <<eof>> HeaderCtrlEx.h
/////////////////////////////////////////////////////////////////////////////
