// GDIPlusLoader.h
//
//  ,       .
//

#pragma once

#include <gdiplus.h>

//
// Class GdiPlusImageFile 
//
class GdiPlusImageFile
{
public:
	Gdiplus::Bitmap* m_pBitmap;

public:
	GdiPlusImageFile()
	{
		m_pBitmap = NULL;
	}
	GdiPlusImageFile(LPCWSTR pFile)
	{
		m_pBitmap = NULL;
		Load( pFile );
	}
	virtual ~GdiPlusImageFile()
	{
		Empty();
	}
	void Empty()
	{
		delete m_pBitmap;
		m_pBitmap = NULL;
	}
	BOOL Load(LPCWSTR pFile)
	{
		Empty();
		m_pBitmap = Gdiplus::Bitmap::FromFile(pFile);
		return m_pBitmap->GetLastStatus() == Gdiplus::Ok;
	}
	operator Gdiplus::Bitmap*() const
	{
		return m_pBitmap;
	}
};

//
// Class GdiPlusImageResource
//
class GdiPlusImageResource : public GdiPlusImageFile
{
protected:
	HGLOBAL m_hBuffer;

public:
	GdiPlusImageResource()
	{
		m_hBuffer = NULL;
	}
	GdiPlusImageResource(LPCTSTR pName, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL)
	{
		m_hBuffer = NULL;
		Load(pName, pType, hInst);
	}
	GdiPlusImageResource(UINT id, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL)
	{
		m_hBuffer = NULL;
		Load(id, pType, hInst);
	}
	GdiPlusImageResource(UINT id, UINT type, HMODULE hInst = NULL)
	{
		m_hBuffer = NULL;
		Load(id, type, hInst);
	}
	virtual ~GdiPlusImageResource()
	{
		Empty();
	}

	void Empty();

	BOOL Load(LPCTSTR pName, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL);

	BOOL Load(UINT id, LPCTSTR pType = RT_RCDATA, HMODULE hInst = NULL)
	{
		return Load(MAKEINTRESOURCE(id), pType, hInst);
	}
	
	BOOL Load(UINT id, UINT type, HMODULE hInst = NULL)
	{
		return Load(MAKEINTRESOURCE(id), MAKEINTRESOURCE(type), hInst);
	}
};

inline void GdiPlusImageResource::Empty()
{
	GdiPlusImageFile::Empty();
	if ( m_hBuffer )
	{
		::GlobalUnlock(m_hBuffer);
		::GlobalFree(m_hBuffer);
		m_hBuffer = NULL;
	}
}

inline BOOL GdiPlusImageResource::Load(LPCTSTR pName, LPCTSTR pType, HMODULE hInst)
{
	Empty();
	
	HRSRC hResource = ::FindResource(hInst, pName, pType);
	if( !hResource )
		return 0x0FFFFFFFF;	// .  -1.

	DWORD imageSize = ::SizeofResource(hInst, hResource);
	if( !imageSize )
		return 0x0FFFFFFFF;	// .  -1.
	
	const void* pResourceData = ::LockResource( ::LoadResource(hInst, hResource) );
	if( !pResourceData )
		return 0x0FFFFFFFF;	// .  -1.

	m_hBuffer = ::GlobalAlloc(GMEM_MOVEABLE, imageSize);
	if( m_hBuffer )
	{
		void* pBuffer = ::GlobalLock(m_hBuffer);
		if ( pBuffer )
		{
			CopyMemory(pBuffer, pResourceData, imageSize);
			IStream* pStream = NULL;
			if( ::CreateStreamOnHGlobal(m_hBuffer, FALSE, &pStream) == S_OK)
			{
				m_pBitmap = Gdiplus::Bitmap::FromStream(pStream);
				pStream->Release();
				if ( m_pBitmap )
				{ 
					if ( m_pBitmap->GetLastStatus() == Gdiplus::Ok )
						return 0;	// ,  0.

					delete m_pBitmap;
					m_pBitmap = NULL;
				}
			}
			::GlobalUnlock(m_hBuffer);
		}
		::GlobalFree(m_hBuffer);
		m_hBuffer = NULL;
	}
	return 0x0FFFFFFFF;	// .  -1.
}

//
// <<eof>> GDIPlusLoader.h
//
