//////////////////////////////////////////////////////////////////////////////
// FavoriteDlg.cpp

#include "stdafx.h"
#include "App.h"
#include "FavoriteDlg.h"

using namespace Gdiplus;

UINT GWidth, GHeight;	// ,  

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CFavoriteDlg::CFavoriteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFavoriteDlg::IDD, pParent)
{
	//m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFavoriteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//DDX_Control(pDX, IDC_ZABOUT_CLOSE, m_btClose);
	//DDX_Control(pDX, IDC_START, m_btStart);
	//DDX_Control(pDX, IDC_HYPERLINK, m_static1);
}

BEGIN_MESSAGE_MAP(CFavoriteDlg, CDialog)
	//}}AFX_MSG_MAP
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_WM_DESTROY()	
	//ON_BN_CLICKED(IDC_ZABOUT_CLOSE, &CFavoriteDlg::OnClose)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
END_MESSAGE_MAP()

int CFavoriteDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if( CDialog::OnCreate(lpCreateStruct) == 0x0FFFFFFFF )
		return 0x0FFFFFFFF;

	if( GGDIResult==0x0FFFFFFFF )
		return 0x0FFFFFFFF;

	return 0;
}

CFavoriteDlg::~CFavoriteDlg(void)
{
}

BOOL CFavoriteDlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->wParam == VK_ESCAPE&&GetKeyState(VK_ESCAPE)<0 )
	{
		OnExit();
		return TRUE; // Key processed.
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CFavoriteDlg::OnExit()
{
	SendMessage(WM_CLOSE);
}
void CFavoriteDlg::OnClose()
{
	EndDialog(0);
}
void CFavoriteDlg::OnDestroy() 
{
	CDialog::OnDestroy();

	// :
	if( m_pImage != NULL )
	{
		m_pImage.Empty();
	}
}

//////////////////////////////////////////////////////////////////////////////
// OnPaint

void CFavoriteDlg::OnPaint()
{
	//  .
	OnFlame();

	CDialog::OnPaint();
}

//////////////////////////////////////////////////////////////////////////////
// OnFlame
//
//   .
//
void CFavoriteDlg::OnFlame()
{
	if( m_pImage==NULL )
	{
		SendMessage(WM_CLOSE);
		return;
	}

	CPaintDC dc(this);
	Graphics graphics(dc);

	CRect rect;
	GetClientRect(&rect);
	int nWidth = rect.right-rect.left;	// .
	int nHeight = rect.bottom-rect.top;	// .

	//   .
	graphics.DrawImage(m_pImage, rect.left, rect.top, nWidth, nHeight);
}

BOOL CFavoriteDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//SetIcon(m_hIcon, TRUE);		// Set big icon
	//SetIcon(m_hIcon, FALSE);	// Set small icon

	// TODO: Add extra initialization here

	BOOL Result;

	//     .
	Result=m_pImage.Load(IDB_FAVORITE1);
	if( Result==0x0FFFFFFFF )
	{
		debugf( TEXT("-->FAILED: Favorite load image") );
		//   :
		//MessageBox(TEXT("-->FAILED: Load: ImageResource"),TEXT("Fatal Error"),MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
		//ExitProcess(0);
	}

	//   , , :
	GWidth = m_pImage.m_pBitmap->GetWidth();
	GHeight= m_pImage.m_pBitmap->GetHeight();

	//     :
	if( GWidth < 200 || GHeight < 200 )
	{
		//   :
		GWidth = 640;
		GHeight = 480;
	}
	
	SetWindowPos(NULL,NULL,NULL,GWidth,GHeight,SWP_NOZORDER|SWP_NOMOVE);
	
	// :
	//Invalidate(FALSE);

	// Set Window Name:
	//SetWindowText( _T( "My favorite place" ) );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFavoriteDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	/*
	CWnd* pWnd;
	pWnd = GetDlgItem(IDC_ZABOUT_CLOSE);
	if( pWnd )
		pWnd->SetWindowPos(NULL, cx + cx / -7 + 5, 30, cx / 7 - 10, cy / 15, 20);
	*/

	Invalidate(FALSE);
	//Invalidate(TRUE);
}

void CFavoriteDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	static BOOL bShow = bShow ? FALSE : TRUE;

	if( bShow )
	{
		ShowWindow(SW_MAXIMIZE);
		Invalidate(FALSE);
		bShow = FALSE;
	}
	else
	{
		ShowWindow(SW_RESTORE);
		Invalidate(FALSE);
		bShow = TRUE;
	}
}

void CFavoriteDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	SendMessage(WM_CLOSE);
	return;

	static BOOL bShow = bShow ? FALSE : TRUE;

	if( bShow )
	{
		ShowWindow(SW_MAXIMIZE);
		Invalidate(FALSE);
		bShow = FALSE;
	}
	else
	{
		ShowWindow(SW_RESTORE);
		Invalidate(FALSE);
		bShow = TRUE;
	}
}

//////////////////////////////////////////////////////////////////////////////
// <<eof>> FavoriteDlg.cpp
//////////////////////////////////////////////////////////////////////////////
