/////////////////////////////////////////////////////////////////////////////
// AppView.h

#pragma once

#include "ListViewEx.h"

class CAppView : public CListViewEx
{
protected:
	CAppView();
	DECLARE_DYNCREATE(CAppView)

// Attributes
public:
	CAppDoc* GetDocument();

// Operations
public:

	//    .
	void ColumnVisible(int nColumn, BOOL bVisible);

	void ChangeFont();
	void ClearResponse();
	void BuildItems(int nItem, int nSubItem, LPCTSTR pszText);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAppView)
	public:
	//virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CAppView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	//UINT_PTR m_Timer;

// Generated message map functions
protected:
	void LoadProfileFont(LPCTSTR Section, LOGFONT* plf);
	void SaveProfileFont(LPCTSTR Section, const LOGFONT* plf, LOGFONT* plfOld);

	//{{AFX_MSG(CAppView)
	afx_msg void OnDestroy();
	//afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	CListCtrl* m_pListCtrl;

	// Change font.
	CFont m_pFont;
	static LOGFONT NEAR m_lfDefFont;
	static LOGFONT NEAR m_lfDefFontOld;
};

#ifndef _DEBUG  // debug version in AppView.cpp
inline CAppDoc* CAppView::GetDocument()
   { return (CAppDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
// <<eof>> AppView.h
/////////////////////////////////////////////////////////////////////////////
