/////////////////////////////////////////////////////////////////////////////
// AppView.cpp

#include "stdafx.h"
#include "App.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

LOGFONT NEAR CAppView::m_lfDefFont;
LOGFONT NEAR CAppView::m_lfDefFontOld;

/////////////////////////////////////////////////////////////////////////////
// CAppView

IMPLEMENT_DYNCREATE(CAppView, CListViewEx)

BEGIN_MESSAGE_MAP(CAppView, CListViewEx)
	//{{AFX_MSG_MAP(CAppView)
	ON_WM_DESTROY()
	//ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAppView construction/destruction

CAppView::CAppView()
{
}
CAppView::~CAppView()
{
}
BOOL CAppView::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style |= LVS_REPORT;
	return CListView::PreCreateWindow(cs);
}

void CAppView::OnInitialUpdate()
{
	CListViewEx::OnInitialUpdate();

	m_pListCtrl = &GetListCtrl();

	//   .
	LoadProfileFont(pszSection,&m_lfDefFont);
	m_lfDefFontOld = m_lfDefFont;
	if( m_lfDefFont.lfHeight != 0 )
	{
		m_pFont.CreateFontIndirect(&m_lfDefFont);
		m_pListCtrl->SetFont(&m_pFont);
	}
	/*
	else
	{
		//   .
		CString sFont;
		//sFont.LoadString(IDS_FONT);
		sFont = _T("Tahoma");
		memset(&m_lfDefFont,0,sizeof(m_lfDefFont));
		m_lfDefFont.lfHeight=16;
		m_lfDefFont.lfWeight=FW_NORMAL;
		lstrcpy(m_lfDefFont.lfFaceName,sFont);
		VERIFY(m_pFont.CreateFontIndirect(&m_lfDefFont));
		m_pListCtrl->SetFont(&m_pFont);
	}
	*/

	m_pListCtrl->SetExtendedStyle(
		LVS_EX_FULLROWSELECT |
		LVS_EX_HEADERDRAGDROP |
		LVS_EX_INFOTIP);

	GetListCtrlExt().DeleteAllColumns();

	//
	//  .
	//
	m_pListCtrl->InsertColumn(0, _T("Name"), LVCFMT_LEFT, 100);
	m_pListCtrl->InsertColumn(1, _T("Frags"), LVCFMT_LEFT, 100);
	m_pListCtrl->InsertColumn(2, _T("Ping"), LVCFMT_LEFT, 100);
	m_pListCtrl->InsertColumn(3, _T("Team"), LVCFMT_LEFT, 100);
	m_pListCtrl->InsertColumn(4, _T("Mesh"), LVCFMT_LEFT, 100);
	m_pListCtrl->InsertColumn(5, _T("Skin"), LVCFMT_LEFT, 100);
	m_pListCtrl->InsertColumn(6, _T("Face"), LVCFMT_LEFT, 100);
	m_pListCtrl->InsertColumn(7, _T("ID"), LVCFMT_LEFT, 100);


	//
	//  .
	//
	/*
	BuildItems(0,INDEX_NAME,_T("Shvonder") );
	BuildItems(0,INDEX_FRAGS,_T("27"));
	BuildItems(0,INDEX_PING,_T("105"));

	BuildItems(0,INDEX_TEAM,_T("255"));
	BuildItems(0,INDEX_MESH,_T("Male Soldier"));
	BuildItems(0,INDEX_SKIN,_T("FCommandoSkins"));
	BuildItems(0,INDEX_FACE,_T("Boss"));
	BuildItems(0,INDEX_ID,_T("1"));
	*/

	//  : 0, 1, 2 ( Name, Frags, Ping ).
	GetListCtrlExt().GetHeaderCtrl()->SetRemovable(0,FALSE);
	GetListCtrlExt().GetHeaderCtrl()->SetRemovable(1,FALSE);
	GetListCtrlExt().GetHeaderCtrl()->SetRemovable(2,FALSE);

	//   .
	GetListCtrlExt().RestoreState( pszSection );
}

/////////////////////////////////////////////////////////////////////////////
// CAppView diagnostics

#ifdef _DEBUG
void CAppView::AssertValid() const
{
	CListView::AssertValid();
}
void CAppView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
CAppDoc* CAppView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAppDoc)));
	return (CAppDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAppView message handlers

void CAppView::OnDestroy() 
{
	CListViewEx::OnDestroy();

	//  .
	SaveProfileFont(pszSection,&m_lfDefFont,&m_lfDefFontOld);
}

////////////////////////////////////////////////////////////////////////////////
//   .
//
void CAppView::SaveProfileFont(LPCTSTR Section, const LOGFONT* plf, LOGFONT* plfOld)
{
	CWinApp* pApp=AfxGetApp();
	if( plf->lfHeight!=plfOld->lfHeight )
		pApp->WriteProfileInt(Section,pszFontHeight,plf->lfHeight);
	if( plf->lfHeight!=0 )
	{
		if( plf->lfHeight!=plfOld->lfHeight )
			pApp->WriteProfileInt(Section,pszFontHeight,plf->lfHeight);
		if( plf->lfWeight!=plfOld->lfWeight )
			pApp->WriteProfileInt(Section,pszFontWeight,plf->lfWeight);
		if( plf->lfItalic!=plfOld->lfItalic )
			pApp->WriteProfileInt(Section,pszFontItalic,plf->lfItalic);
		if( plf->lfUnderline!=plfOld->lfUnderline )
			pApp->WriteProfileInt(Section,pszFontUnderline,plf->lfUnderline);
		if( plf->lfPitchAndFamily!=plfOld->lfPitchAndFamily )
			pApp->WriteProfileInt(Section,pszFontPitchAndFamily,plf->lfPitchAndFamily);
		if( plf->lfCharSet!=plfOld->lfCharSet )
			pApp->WriteProfileInt(Section,pszFontCharSet,plf->lfCharSet);
		if( _tcscmp(plf->lfFaceName,plfOld->lfFaceName)!=0 )
			pApp->WriteProfileString(Section,pszFontFaceName,(LPCTSTR)plf->lfFaceName);
	}
	*plfOld = *plf;
}

////////////////////////////////////////////////////////////////////////////////
//   .
//
void CAppView::LoadProfileFont(LPCTSTR Section, LOGFONT* plf)
{
	CWinApp* pApp=AfxGetApp();
	plf->lfHeight=pApp->GetProfileInt(Section,pszFontHeight,0);
	if( plf->lfHeight!=0 )
	{
		plf->lfWeight=pApp->GetProfileInt(Section,pszFontWeight,0);
		plf->lfItalic=(BYTE)pApp->GetProfileInt(Section,pszFontItalic,0);
		plf->lfUnderline=(BYTE)pApp->GetProfileInt(Section,pszFontUnderline,0);
		plf->lfPitchAndFamily=(BYTE)pApp->GetProfileInt(Section,pszFontPitchAndFamily,0);
		plf->lfCharSet=(BYTE)pApp->GetProfileInt(Section,pszFontCharSet,DEFAULT_CHARSET);
		CString sFont=pApp->GetProfileString(Section,pszFontFaceName,pszFontSystem);
		lstrcpyn((TCHAR*)plf->lfFaceName,sFont,sizeof plf->lfFaceName);
		plf->lfFaceName[sizeof plf->lfFaceName-1]=0;
	}
}

////////////////////////////////////////////////////////////////////////////////
//  .
//
void CAppView::BuildItems(int nItem, int nSubItem, LPCTSTR pszText)
{
	if( nSubItem==0 )
		m_pListCtrl->InsertItem(nSubItem, pszText);
	else
		m_pListCtrl->SetItemText(nItem, nSubItem, pszText);
}

////////////////////////////////////////////////////////////////////////////////
//  .
//
void CAppView::ClearResponse()
{
	m_pListCtrl->DeleteAllItems();
	ASSERT( m_pListCtrl->GetItemCount()==0 );
}

////////////////////////////////////////////////////////////////////////////////
//    .

void CAppView::ColumnVisible(int nColumn, BOOL bVisible)
{
	GetListCtrlExt().ColumnVisible(nColumn, bVisible);
}

/////////////////////////////////////////////////////////////////////////////
// ChangeFont

void CAppView::ChangeFont()
{
	// Get current font description.
	CFont* pFont=m_pListCtrl->GetFont();

	LOGFONT lf;
	if( pFont!=NULL )
		pFont->GetObject(sizeof(LOGFONT),&lf);
	else
		::GetObject(GetStockObject(SYSTEM_FONT),sizeof(LOGFONT),&lf);

	CFontDialog dlg(&lf, CF_SCREENFONTS|CF_INITTOLOGFONTSTRUCT);
	if( dlg.DoModal()==IDOK )
	{
		m_pFont.DeleteObject();
		if( m_pFont.CreateFontIndirect(&lf) )
		{
			CWaitCursor wait;

			m_pListCtrl->SetFont(&m_pFont);
			m_lfDefFont=lf;

			wait.Restore();

			Invalidate();
		}
	}
}

void CAppView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	//UINT uFlags=0;
	//int nHitItem=GetListCtrl().HitTest(point,&uFlags);
	//CListViewEx::OnLButtonDown(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
// OnLButtonDblClk
//
//  .    .
//
void CAppView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	//UINT uFlags=0;
	//int nHitItem=GetListCtrl().HitTest(point,&uFlags);
	//TCHAR szBuff[256] = TEXT("");

	FString URL;
	const TCHAR* Madrixis = TEXT( "[4F]madrixis" );
	const TCHAR* Heathcliff = TEXT( "Heathcliff_UK" );

	int i;
	if( m_pListCtrl->GetSelectedCount() > 0 )
	{
		for( i=(m_pListCtrl->GetItemCount()-1); i>=0; --i )
		{
			if( m_pListCtrl->GetItemState(i,LVIS_SELECTED)==LVIS_SELECTED )
			{
				LVITEM lvi;
				TCHAR svText[256];
				
				// Get item information.
				lvi.iItem		= i;
				lvi.iSubItem	= 0;
				lvi.mask		= LVIF_PARAM | LVIF_IMAGE | LVIF_TEXT;
				lvi.pszText		= svText;
				lvi.cchTextMax	= 256;
				m_pListCtrl->GetItem(&lvi);

				CWaitCursor wait;

				//lstrcpy(svText, Heathcliff );
				if( appStrcmp(svText, Madrixis)==0 )
				{
					URL = TEXT( "https://forums.multiplay.com/members/19067-Madrixis" );
					appLaunchURL( *URL, NULL, NULL );
					wait.Restore();
					return;
				}
				if( appStrcmp(svText, Heathcliff)==0 )
				{
					URL = TEXT( "https://forums.multiplay.com/members/1119531?s=3fd9f3bb91e98a03dc2fb3c09b7d8852" );
					appLaunchURL( *URL, NULL, NULL );
					wait.Restore();
					return;
				}
				
				URL = FString::Printf(
					TEXT( "https://www.google.com/#q=%s&newwindow=1&tbs=li:1" ), svText);

				//const TCHAR* URL;
				//URL = TEXT("http://bot1.multiplay.co.uk/cgi-bin/flash/bans.cgi?player=latest");
				appLaunchURL( *URL,NULL,NULL );
				
				wait.Restore();
			}
		}
	}
	//CListViewEx::OnLButtonDblClk(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
// <<eof>> AppView.cpp
/////////////////////////////////////////////////////////////////////////////
