/////////////////////////////////////////////////////////////////////////////
// App.cpp

#include "stdafx.h"
#include "App.h"
#include "UE3Library.h"
#include "ZAboutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BOOL GIsConsole;

using namespace Gdiplus;
BOOL GGDIResult;

//   .
BOOL GIsQuery;

//const TCHAR GVersion[]=TEXT("1.0");
UINT WindowTrayMessage;

//   : , , .
BOOL GColumnsName;
BOOL GColumnsFrags;
BOOL GColumnsPing;
// , .
BOOL GColumnsTeam;
BOOL GColumnsMesh;
BOOL GColumnsSkin;
BOOL GColumnsFace;
BOOL GColumnsID;

BEGIN_MESSAGE_MAP(CApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, &CApp::OnAppAbout)
END_MESSAGE_MAP()

CApp::CApp()
{
}
CApp theApp;

/////////////////////////////////////////////////////////////////////////////
// OnParseCommand

BOOL CApp::OnParseCommand()
{
	const TCHAR* Cmd = appCmdLine();

	//    .
	if( ParseCommand(&Cmd,TEXT("-RESET")) || ParseCommand(&Cmd,TEXT("/RESET")) )
	{
		DefaultConfig(NULL);
		return 1;
	}

	//  Log ( console  ).
	if( ParseCommand(&Cmd,TEXT("-LOG")) || ParseCommand(&Cmd,TEXT("/LOG")) )
	{
		GLogConsole->Show( TRUE );
		//GLogConsole->Show( FALSE );
		GIsConsole = TRUE;

		//   "".
		HWND hwndConsole = GetConsoleWindow();
		if( hwndConsole != 0 )
		{
			//   .
			//SetWindowLongPtr( hwndConsole, GWL_USERDATA, GetWindowLongPtr( hwndConsole, GWL_WNDPROC ) );
			//SetWindowLongPtr( hwndConsole, GWL_WNDPROC, (__int3264)(LONG_PTR)CatchEnterProc );

			HMENU hConsoleMenu = GetSystemMenu(hwndConsole, FALSE);
			if( hConsoleMenu !=0 )
				RemoveMenu(hConsoleMenu, SC_CLOSE, MF_BYCOMMAND);
			
			//     .
			CString sTitle;
			sTitle.Format(_T("%s - Log"), AfxGetApp()->m_pszExeName);
			SetConsoleTitle( sTitle );
		}
		return 2;
	}

	//     .
	if( ParseCommand(&Cmd,TEXT("-HELP")) || ParseCommand(&Cmd,TEXT("/HELP")) ||
		ParseCommand(&Cmd,TEXT("-?")) || ParseCommand(&Cmd,TEXT("/?")) )
	{
		CString sAppName = AfxGetApp()->m_pszExeName;
		CString sUsage;
		sUsage.Format(_T("\nUsage:\n%s <options>\n\nOptions:\n-log  (View log to console)  \n-reset  (Sets the initial settings)  \n-help  (You read it)  \n\n"), sAppName);
		MessageBox(NULL,sUsage,pszAppname,MB_OK|MB_ICONINFORMATION|MB_SETFOREGROUND|MB_TOPMOST);
		return 3;
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// InitInstance

BOOL CApp::InitInstance()
{
	//     .
	HWND hWnd=::FindWindow(pszAppclass,NULL);
	if( IsWindow(hWnd) ) {
		HWND tmp=GetLastActivePopup(hWnd);
		if( !IsIconic(tmp) )
			::ShowWindow(tmp,SW_SHOW);
		::ShowWindow(tmp,SW_RESTORE);
		::SetForegroundWindow(tmp);
		::SetFocus(tmp);
		return FALSE;
	}

	//  .
	INT ErrorLevel			= 0;
	GIsStarted				= 1;
	hInstance				= AfxGetInstanceHandle();
	const TCHAR* CmdLine	= GetCommandLine();	
	ErrorLevel				= GLibrary.Init( CmdLine );
	if( ErrorLevel != 0)
	{
		AfxMessageBox( _T("Could not init Library") );
		return FALSE;
	}

	// Initialize Sockets.
	if( !AfxSocketInit() ) 
	{
		AfxMessageBox( _T("Could not init Winsock") );
		return FALSE;
	}

#ifndef _DEBUG
	if( appIsDebuggerPresent() )
		appDebugBreak();
#endif

	CWinApp::InitInstance();

	// Initialize OLE libraries.
	if( !AfxOleInit() )
	{
		AfxMessageBox(IDS_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	//  GDI+
	GdiplusStartupInput gdiplusStartupInput;
	GGDIResult=GdiplusStartup(&m_gdiplusToken, &gdiplusStartupInput, NULL);
	if( GGDIResult!=0 )
	{
		GGDIResult=0x0FFFFFFFF;
		debugf( TEXT("Could not GdiplusStartup") );
	}

	OnParseCommand();
	
	// Set registry key: "Made by Sir Kurgan".
	SetRegistryKey( pszRegkey );

	//  .
	LoadConfig();

	//  ,  / .
	if( m_bShowFrame )
		m_nCmdShow=SW_SHOWMAXIMIZED;
	else 
 		m_nCmdShow=SW_SHOWNORMAL;

	//  .
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CAppDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CAppView));
	if (!pDocTemplate)
	{
		debugf( TEXT("-->FAILED: CSingleDocTemplate") );
		return FALSE;
	}
	AddDocTemplate(pDocTemplate);
	
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	if( !ProcessShellCommand(cmdInfo) )
	{
		debugf( TEXT("-->FAILED: ProcessShellCommand") );
		return FALSE;
	}

	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
//
// .
//
int CApp::ExitInstance() 
{
	SaveConfig();

	//  GDI+
	if( GGDIResult==0 )
	{
		GdiplusShutdown(m_gdiplusToken);
	}

	// Final shut down.
	GLibrary.Exit();
	GIsStarted = 0;

	ExitProcess(0);

	return CWinApp::ExitInstance();
}
////////////////////////////////////////////////////////////////////////////////
//
// CApp message handlers
//

void CApp::SaveConfig()
{
	// . .
	WriteProfileInt(pszSection,pszColumnsName,GColumnsName);
	WriteProfileInt(pszSection,pszColumnsFrags,GColumnsFrags);
	WriteProfileInt(pszSection,pszColumnsPing,GColumnsPing);

	WriteProfileInt(pszSection,pszColumnsTeam,GColumnsTeam);
	WriteProfileInt(pszSection,pszColumnsMesh,GColumnsMesh);
	WriteProfileInt(pszSection,pszColumnsSkin,GColumnsSkin);
	WriteProfileInt(pszSection,pszColumnsFace,GColumnsFace);
	WriteProfileInt(pszSection,pszColumnsID,GColumnsID);

	//   ,  / .
	WriteProfileInt(pszSection,pszShow,m_bShowFrame);
	WriteProfileBinary(pszSection,pszRect,(BYTE*)&m_rectFrame,sizeof(CRect));
	WriteProfileBinary(pszSection,pszMargin,(BYTE*)&m_rectMargin,sizeof(CRect));
}

////////////////////////////////////////////////////////////////////////////////
// LoadConfig

void CApp::LoadConfig()
{
	// . .
	GColumnsName=GetProfileInt(pszSection,pszColumnsName,TRUE);
	GColumnsFrags=GetProfileInt(pszSection,pszColumnsFrags,TRUE);
	GColumnsPing=GetProfileInt(pszSection,pszColumnsPing,TRUE);

	GColumnsTeam=GetProfileInt(pszSection,pszColumnsTeam,TRUE);
	GColumnsMesh=GetProfileInt(pszSection,pszColumnsMesh,TRUE);
	GColumnsSkin=GetProfileInt(pszSection,pszColumnsSkin,TRUE);
	GColumnsFace=GetProfileInt(pszSection,pszColumnsFace,TRUE);
	GColumnsID=GetProfileInt(pszSection,pszColumnsID,TRUE);

	// ,  ,  / .
	m_bShowFrame=GetProfileInt(pszSection,pszShow,FALSE);

	BYTE* pb = NULL;
	UINT nLen = 0;
	if( GetProfileBinary(pszSection,pszRect,&pb,&nLen))
	{
		ASSERT(nLen==sizeof(CRect));
		memcpy(&m_rectFrame,pb,sizeof(CRect));
		delete pb;
	} else
		m_rectFrame.SetRect(0,0,0,0);

	CRect rectScreen(0,0,GetSystemMetrics(SM_CXSCREEN),
	GetSystemMetrics(SM_CYSCREEN));

	CRect rectInt;
	rectInt.IntersectRect(&rectScreen, &m_rectFrame);
	if( rectInt.Width() < 10 || rectInt.Height() < 10 )
		m_rectFrame.SetRect(0,0,0,0);

	if( GetProfileBinary(pszSection, pszMargin, &pb, &nLen) )
	{
		ASSERT( nLen==sizeof(CRect) );
		memcpy( &m_rectMargin, pb, sizeof(CRect) );
		delete pb;
	} else
		m_rectMargin.SetRect( 1800, 1440, 1800, 1440 );
}

////////////////////////////////////////////////////////////////////////////////
// DefaultConfig
//
//    .
//
void CApp::DefaultConfig(HWND hwnd)
{
	TCHAR Buffer[256];
	HKEY hHKCU = HKEY_CURRENT_USER;
	//TCHAR Temp[]=L"Software\\Made by Sir Kurgan\\UT99Query";
	const TCHAR* s1 = TEXT( "Software" );
	const TCHAR* s2 = pszRegkey;
	const TCHAR* s3 = pszAppname;

	FString Target;
	Target = FString::Printf( TEXT( "%s\\%s\\%s" ), s1, s2, s3 );	
	if( RegDeleteKeyRecurse(hHKCU, *Target, Buffer)==0 )
	{
		//    .
		MessageBox(hwnd,TEXT("Successfully settings config default."),pszAppname,MB_OK|MB_ICONINFORMATION|MB_SETFOREGROUND|MB_TOPMOST);
	}
	else
	{
		//   .
		MessageBox(hwnd,TEXT("Sorry, failed setting config default."),pszAppname,MB_OK|MB_ICONWARNING|MB_SETFOREGROUND|MB_TOPMOST);
	}
}

/////////////////////////////////////////////////////////////////////////////
// OnAppAbout
//
//  .
//
void CApp::OnAppAbout()
{
	int x, y;
	CRect rect = theApp.m_rectFrame;

	if( m_bShowFrame )
	{	
		//   .
		x = 0;
		y = 0;	// Vertical.
	}
	else
	{	
		//    .
		x = rect.left + 5;
		y = rect.top + 90;	// Vertical.
	}
	
	ZAboutDlg dlg;
	dlg.m_point = CPoint( x, y );
	dlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// RegDeleteKeyRecurse
//
//   .
//
BOOL RegDeleteKeyRecurse(HKEY hKey, const TCHAR* szSubKey, TCHAR* Buffer)
{
	BOOL Result = 0x0FFFFFFFF;
	HKEY hSubKey;
	TCHAR svSubKeyBuf[MAX_PATH+1];
	if( RegOpenKeyEx(hKey,szSubKey,0,KEY_ALL_ACCESS,&hSubKey)!=ERROR_SUCCESS )
		return Result;
	
	int nCount = 0;
	while( RegEnumKey(hSubKey,nCount,Buffer,MAX_PATH)!=ERROR_NO_MORE_ITEMS )
	{
		if( RegDeleteKeyRecurse(hSubKey,Buffer,svSubKeyBuf)==Result )
		{
			RegCloseKey(hSubKey);
			return Result;
		}
		++nCount;
	}
	
	// !
	RegCloseKey(hSubKey);
	RegDeleteKey(hKey, szSubKey);
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// <<eof>> App.cpp
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// CatchEnterProc -   .

LRESULT CALLBACK CatchEnterProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_CLOSE:
		//SendMessage( hDlg, WM_COMMAND, IDC_BT_EXIT, 0 );
		return TRUE;
	case WM_KEYDOWN:
		if( wParam == VK_RETURN || wParam == VK_ESCAPE )
		{
			return TRUE;
		}
	case WM_KEYUP:
		if( wParam == VK_RETURN || wParam == VK_ESCAPE )
		{
			return TRUE;
		}
	case WM_CHAR:
		if( wParam == 13 || wParam == 27 )
		{
			return TRUE;
		}
	}	
	return CallWindowProc( (WNDPROC)(LONG_PTR)GetWindowLong( hwnd, GWL_USERDATA), hwnd, uMsg, wParam, lParam);
}
