// iCore.cpp

#include "CorePrivate.h"

// Error malloc.
class FMallocError : public FMalloc
{
	void Called( const TCHAR* Str )
	{
		appErrorf( TEXT("Called %s before memory init"), Str );
		check(0);
	}	
	void* Malloc( DWORD Count )
	{
		Called(TEXT("Malloc"));
		return NULL;
	}
	void* Realloc( void* Original, DWORD Count )
	{
		Called(TEXT("Realloc"));
		return NULL;
	}
	void Free( void* Original )
	{
		Called(TEXT("Free"));
	}
	void* PhysicalMalloc( DWORD Count )
	{
		Called(TEXT("PhysicalMalloc"));
		return NULL;
	}
	void PhysicalFree( void* Original )
	{
		Called(TEXT("PhysicalFree"));
	}
	void DumpAllocs()
	{
		Called(TEXT("DumpAllocs"));
	}
	void HeapCheck()
	{
		Called(TEXT("HeapCheck"));
	}
	void Init( UBOOL Reset )
	{
		Called(TEXT("MallocError::Init"));
	}
	void Exit()
	{
		Called(TEXT("MallocError::Exit"));
	}
	void DumpMemoryImage()
	{
		Called(TEXT("MallocError::DumpMemoryImage"));
	}
	void GetAllocationInfo( SIZE_T& Virtual, SIZE_T&Physical)
	{
		Called(TEXT("MallocError::GetAllocationInfo"));
	}
} MallocError;


// Error file manager.
class FFileManagerError : public FFileManager
{
public:
	FArchive* CreateFileReader( const TCHAR* Filename, DWORD Flags, FOutputDevice* Error)
	{
		appErrorf(TEXT("Called FileManagerError::CreateFileReader"));
		return 0;
	}
	FArchive* CreateFileWriter( const TCHAR* Filename, DWORD Flags, FOutputDevice* Error )
	{
		appErrorf(TEXT("Called FileManagerError::CreateFileWriter")); 
		return 0;
	}
	INT FileSize( const TCHAR* Filename )
	{
		return -1;
	}
	UBOOL Delete( const TCHAR* Filename, UBOOL RequireExists=0, UBOOL EvenReadOnly=0 )
	{
		return 0;
	}
	UBOOL IsReadOnly( const TCHAR* Filename )
	{
		return 0;
	}
	DWORD Copy( const TCHAR* Dest, const TCHAR* Src, UBOOL Replace=1, UBOOL EvenIfReadOnly=0, UBOOL Attributes=0, DWORD Compress=FILECOPY_Normal, FCopyProgress* Progress=NULL )
	{
		return COPY_MiscFail;
	}
	UBOOL Move( const TCHAR* Dest, const TCHAR* Src, UBOOL Replace=1, UBOOL EvenIfReadOnly=0, UBOOL Attributes=0 )
	{
		return 0;
	}
	UBOOL MakeDirectory( const TCHAR* Path, UBOOL Tree=0 )
	{
		return 0;
	}
	UBOOL DeleteDirectory( const TCHAR* Path, UBOOL RequireExists=0, UBOOL Tree=0 )
	{
		return 0;
	}
	void FindFiles( TArray<FString>& Result, const TCHAR* Filename, UBOOL Files, UBOOL Directories )
		{}
	
	DOUBLE GetFileAgeSeconds( const TCHAR* Filename )
	{
		return -1.0;
	}
	UBOOL SetDefaultDirectory()
	{
		return 0;
	}
	FString GetCurrentDirectory()
	{
		return TEXT("");
	}
} FileError;

// Exception thrower.
class FThrowOut : public FOutputDevice
{
public:
	void Serialize( const TCHAR* V, EName Event )
	{
		throw( V );
	}
} ThrowOut;

// Null output device.
class FNullOut : public FOutputDevice
{
public:
	void Serialize( const TCHAR* V, enum EName Event )
	{}
} NullOut;

// Dummy saver.
class FArchiveDummySave : public FArchive
{
public:
	FArchiveDummySave() { ArIsSaving = 1; }
} GArchiveDummySave;

// Glogal output device redirector,
// Can be static as FOutputDeviceRedirector explicitely empties TArray on TearDown.
static FOutputDeviceRedirector LogRedirector;

FMemStack GMem;	// Global memory stack.
FOutputDeviceRedirectorBase* GLog = &LogRedirector; // Regular logging.
FOutputDeviceError* GError = NULL; // Critical errors.
FOutputDevice* GNull = &NullOut; // Log to nowhere.
FOutputDevice* GThrow = &ThrowOut; // Exception thrower.
FFeedbackContext* GWarn = NULL; // User interaction and non critical warnings.
FOutputDeviceConsole* GLogConsole = NULL; // Console log hook.
FMalloc* GMalloc = &MallocError; // Memory allocator.
FFileManager* GFileManager = &FileError; // File manager.

// Manages and tracks property editing windows.
TCHAR GErrorHist[4096] = TEXT(""); // For building call stack text dump in guard/unguard mechanism.
TCHAR GYes[64] = TEXT("Yes"); // Localized "yes" text.
TCHAR GNo[64] = TEXT("No"); // Localized "no" text.
TCHAR GTrue[64] = TEXT("True"); // Localized "true" text.
TCHAR GFalse[64] = TEXT("False"); // Localized "false" text.
TCHAR GNone[64] = TEXT("None"); // Localized "none" text.
DOUBLE GSecondsPerCycle = 1.0; // Seconds per CPU cycle for this PC.
DWORD GPageSize = 4096; // Operating system page size.
UBOOL GIsCriticalError = 0; // An appError() has occured.
UBOOL GIsStarted = 0; // Whether execution is happening from within main()/WinMain().
UBOOL GIsGuarded = 0; // Whether execution is happening within main()/WinMain()'s try/catch handler.
UBOOL GIsRunning = 0; // Whether execution is happening within MainLoop().
UBOOL GIsSlowTask = 0; // Whether there is a slow task in progress.
UBOOL GIsRequestingExit = 0; // Indicates that MainLoop() should be exited at the end of the current iteration.
UBOOL GLazyLoad = 1; // Whether TLazyLoad arrays should be lazy-loaded or not.
FArchive* GDummySave = &GArchiveDummySave; // No-op save archive.
DOUBLE GCurrentTime = 0; // Current time.

#if UNICODE
// Whether we're using Unicode or not.
UBOOL GUnicode = 1;
// Whether the OS supports Unicode or not.
UBOOL GUnicodeOS = 0;
#else
// Whether we're using Unicode or not.
UBOOL GUnicode = 0;
// Whether the OS supports Unicode or not.
UBOOL GUnicodeOS	= 0;
#endif

FCriticalSection* GHostByNameCriticalSection;

//
// <<eof>> iCore.cpp
//