// FOutputDeviceWindowsError.h

//
// Handle a critical error.
//
class FOutputDeviceWindowsError : public FOutputDeviceError
{
	INT ErrorPos;
	EName ErrorType;
public:
	FOutputDeviceWindowsError()
	: ErrorPos(0)
	, ErrorType(NAME_None)
	{}
	void Serialize( const TCHAR* Msg, enum EName Event )
	{

#if _DEBUG
		// Just display info and break the debugger.
  		debugf( NAME_Critical, TEXT("appError called while debugging:") );
		debugf( NAME_Critical, Msg );

		if( appIsDebuggerPresent() )
		{	
  			debugf( NAME_Critical, TEXT("Breaking debugger") );
			appDebugBreak();
		}
		else
		{
			/*
			MessageBox( NULL, Msg, GConfig ? (TCHAR *)*LocalizeError(TEXT("Critical"),TEXT("Window")) : TEXT("Critical Error At Startup"), MB_OK|MB_ICONERROR|MB_TASKMODAL );
			if( !GIsCriticalError )
			{
				GIsCriticalError = 1;
				appExit();
			}
			*/

			appRequestExit(1);
		}
#else
		INT Error = GetLastError();
		if( !GIsCriticalError )
		{
			// First appError.
			GIsCriticalError = 1;
			ErrorType        = Event;
			debugf( NAME_Critical, TEXT("appError called:") );
			debugf( NAME_Critical, TEXT("%s"), Msg );

			// Windows error.
			debugf( NAME_Critical, TEXT("Windows GetLastError: %s (%i)"), appGetSystemErrorMessage(Error), Error );

			appStrncpy( GErrorHist, Msg, ARRAY_COUNT(GErrorHist) );
			appStrncat( GErrorHist, TEXT("\r\n\r\n"), ARRAY_COUNT(GErrorHist) );
			ErrorPos = appStrlen(GErrorHist);
			HandleError();
		}
		else debugf( NAME_Critical, TEXT("Error reentered: %s"), Msg );

		appRequestExit( 1 );
#endif
	}
	void HandleError()
	{
		/*
		try
		{
			GIsRunning			= 0;
			GIsCriticalError	= 1;
			GLogConsole			= NULL;
			GErrorHist[ErrorType==NAME_FriendlyError ? ErrorPos : ARRAY_COUNT(GErrorHist)-1]=0;
			MessageBox( NULL, GErrorHist, GConfig ? (TCHAR *)*LocalizeError(TEXT("Critical"),TEXT("Window")) : TEXT("Critical Error At Startup"), MB_OK|MB_ICONERROR|MB_TASKMODAL );
		}
		catch( ... )
		{}
		*/

	}
};

//
//<< eof>> FOutputDeviceWindowsError.h
//
