// FOutputDeviceAnsiError.h

//
// ANSI stdout output device.
//
class FOutputDeviceAnsiError : public FOutputDeviceError
{
	INT ErrorPos;
	EName ErrorType;
	void LocalPrint( const TCHAR* Str )
	{
#if UNICODE
		wprintf(TEXT("%s"),Str);
#else
		printf(TEXT("%s"),Str);
#endif
	}
public:
	FOutputDeviceAnsiError()
	: ErrorPos(0)
	, ErrorType(NAME_None)
	{}
	void Serialize( const TCHAR* Msg, enum EName Event )
	{

#if _DEBUG
		if( appIsDebuggerPresent() )
		{	
			// Just display info and break the debugger.
  			debugf( NAME_Critical, TEXT("appError called while debugging:") );
			debugf( NAME_Critical, Msg );
			debugf( NAME_Critical, TEXT("Breaking debugger") );
			appDebugBreak();
		}
		else
		{
			// Display the error and exit.
  			LocalPrint( TEXT("\nappError called: \n") );
			LocalPrint( Msg );
  			LocalPrint( TEXT("\n") );
			if( !GIsCriticalError )
			{
				GIsCriticalError = 1;
				appExit();
			}
			appRequestExit( 1 );
		}
#else
		if( !GIsCriticalError )
		{
			// First appError.
			GIsCriticalError = 1;
			ErrorType        = Event;
			debugf( NAME_Critical, TEXT("appError called:") );
			debugf( NAME_Critical, Msg );

			// Shut down.
			appStrncpy( GErrorHist, Msg, ARRAY_COUNT(GErrorHist) );
			appStrncat( GErrorHist, TEXT("\r\n\r\n"), ARRAY_COUNT(GErrorHist) );
			ErrorPos = appStrlen(GErrorHist);
			HandleError();
		}
		else debugf( NAME_Critical, TEXT("Error reentered: %s"), Msg );

#ifdef XBOX
		GMalloc->DumpAllocs();
#endif

		appRequestExit( 1 );
#endif
	}
	void HandleError()
	{
		try
		{
			GIsRunning			= 0;
			GIsCriticalError	= 1;
			GLogConsole			= NULL;
			GErrorHist[ErrorType==NAME_FriendlyError ? ErrorPos : ARRAY_COUNT(GErrorHist)-1]=0;
			LocalPrint( GErrorHist );
			LocalPrint( TEXT("\n\nExiting due to error\n") );
		}
		catch( ... )
		{}
	}
};

//
// <<eof>> FOutputDeviceAnsiError.h
//