class TestMutator extends Mutator;

var Stack stackTest;

function PreBeginPlay()
{
	local TestClassA testObject1, testObject2, testObject3, testObject4, testReturnObject;
	local RecyclingFILOStack rStack;

	super.PreBeginPlay();

	log("Test mutator started",'Stack');

	testObject1 = new class'TestClassA';
	if( testObject1 != none )
		log("testObject1 instantiation successful");

	testObject2 = new class'TestClassB';
	if( testObject2 != none )
		log("testObject2 instantiation successful");

	testObject3 = new class'TestClassC';
	if( testObject3 != none )
		log("testObject3 instantiation successful");

	testObject4 = new class'TestClassD';
	if( testObject4 != none )
		log("testObject4 instantiation successful");

	rStack = new class'RecyclingFILOStack';
	if( rStack != none )
		log("stackTest instantiation successful");

	rStack.push( testObject1 );
	rStack.push( testObject2 );
	rStack.push( testObject3 );
	rStack.push( testObject4 );

	log( "Displaying contents of stack" );

	rStack.logStackContents();

	log( "Stack size is" @ rStack.getSize() );

	log( "Stack is empty" @ rStack.isEmpty() );

	log( "Popping an object" );

	testReturnObject = TestClassA(rStack.pop());

	log( "testReturnObject" @ testReturnObject );

	log( "Number of instances in recycler" @ rStack.getInstanceRecycler().getSize() );

	log( "Popping all objects plus a pop when empty " );

	rStack.pop();
	rStack.pop();
	rStack.pop();
	rStack.pop();

	log( "Stack is empty" @ rStack.isEmpty() );

	log( "Displaying contents of stack" );

	rStack.logStackContents();

	log( "Number of instances in recycler" @ rStack.getInstanceRecycler().getSize() );

	log( "Number of instantiations" @ rStack.getNumInstances() );

	log( "Popping an object" );

	rStack.push( testObject1 );

	rStack.logStackContents();

	log( "Number of instantiations" @ rStack.getNumInstances() );

	log( "Number of instances in recycler" @ rStack.getInstanceRecycler().getSize() );
}

defaultproperties
{

}
