// Two-way LinkElement for Unreal Tournament 4.36 by James P.
// Send comments and suggestions to iamfearless@gmail.com

class StackElement extends Object;

var private Object objectReference; // Store refence to an object
var private StackElement previousStackElement; // Reference to previous SE
var private StackElement nextStackElement; // Reference to previous SE

// Setters
function setPrevious( StackElement se )
{
	self.previousStackElement = se;
}

function setNext( StackElement se )
{
	self.nextStackElement = se;
}

function setReference( Object anObject )
{
	self.objectReference = anObject;
}

// Initialize StackElement for reuse
function initialize()
{
	setPrevious( none );
	setNext( none );
	setReference( none ); // Store object for reuse instead ?
}

// Getters
function StackElement getNext()
{
	return nextStackElement;
}

function StackElement getPrevious()
{
	return previousStackElement;
}

function Object getReference()
{
	return objectReference;
}

defaultproperties
{
	objectReference=none
	previousStackElement=none
	nextStackElement=none
}

