// Stack abstract class for Unreal Tournament 4.36 by James P.
// Send comments and suggestions to iamfearless@gmail.com

class Stack extends Object
	abstract;

var private int stackSize;
var private StackElement topStackElement;
var private StackElement bottomStackElement;

var private int stackInstanceCounter;

// Add something to the stack
function push( Object anObject )
{
}

// Remove something to the stack
function Object pop()
{
}

function private StackElement getElement()
{
	local StackElement se;

	se = new class'StackElement';

	if( se != none ) // Instatiation succesful
		stackInstanceCounter++; // Increment instance counter
	else
	{
		log( "Insufficient memory to instantiate a StackElement" , 'Stack' );

		return none;
	}

	return se;
}

// Check if Stack is empty
function bool isEmpty()
{
	if( getBottom() == none && getTop() == none )
		return true;

	return false;
}

function reset()
{
	setSize( 0 );
	setTop( none );
	setBottom( none );
}

// Getters
function int getSize()
{
	return stackSize;
}

function StackElement getTop()
{
	return topStackElement;
}

function StackElement getBottom()
{
	return bottomStackElement;
}

function int getNumInstances()
{
	local int numInstances;

	numInstances = stackInstanceCounter;

	return stackInstanceCounter;
}

// End getters

// Setters

function int setSize( int newSize )
{
	stackSize = newSize;
}

function setTop( StackElement se )
{
	topStackElement = se;
}

function setBottom( StackElement se )
{
	bottomStackElement = se;
}

function int setNumInstances( int newValue )
{
	stackInstanceCounter = newValue;
}

// End setters

function logStackContents()
{
}
