// StackElement Instance Recycler for Unreal Tournament 4.36 by James P.
// LIFO (Last In First Out) version
// This can be used for storing objects for later use
// Inspired by http://www.cs.bu.edu/teaching/cs112/spring-2000/stack/
// Send comments and suggestions to iamfearless@gmail.com

class SEInstanceRecycler extends Stack;

// Todo: Write a parent class that can be used to recycle any type of instance

// Add an object to the Stack
function push( Object se )
{
	local StackElement oldTopStackElement;

	if( se == none || !se.IsA('StackElement') )
		return;

	StackElement( se ).initialize();

	if( isEmpty() ) // if stack is empty
	{
		setBottom( StackElement( se ) );
		getBottom().setPrevious( none );
		setTop( getBottom() ); // Bottom and top StackElement are one and the same
	}
	else
	{
		oldTopStackElement = getTop(); // Save reference to the current top StackElement
		setTop( StackElement( se ) ); // Set topStackElement attribute to refer to the new StackElement
		getTop().setPrevious( oldTopStackElement );
	}

	setSize( getSize() + 1 );
}

// Get an object from the Stack (and suppress corresponding StackElement)
function Object pop()
{
	local StackElement oldTopStackElement;

	if( isEmpty() )
		return none;

	if( getTop() == getBottom() ) // One element left
	{
		setTop( none );
		setBottom( none );
	}
	else
		setTop( getTop().getPrevious() );

	setSize( getSize() - 1 );

	return oldTopStackElement;
}

// Test method
function logStackContents()
{
	local StackElement se;

	se = getTop();

	while( se != none )
	{
		log( se );

		se = se.getPrevious();
	}
}

defaultproperties
{

}
