class LogFloodSimulator extends Mutator;

var FIFOStack msgStack;

var float lastMsgTime; // Time in seconds to delay

var config float delayTime;
var config int numMessages;

var bool bInitialized;

function PostBeginPlay()
{
	local int counter;

	super.PreBeginPlay();

	if (!bInitialized)
    {
        bInitialized = true;
        Enable('Tick');
    }

	log( "Number of log messages" @ numMessages );

	for( counter = 0; counter < numMessages; counter++ )
		addLogMessage( "This is message" @ counter );

	log( "End of flood test" );
}

function Tick(float DeltaTime)
{
	if( msgStack != none && !msgStack.isEmpty() )
	{
		if( Level.TimeSeconds == 0 )
			return;

		if( Level.TimeSeconds > ( lastMsgTime + delayTime ) )
		{
			log( LogMsg( msgStack.pop() ).getLogMessage() );

			lastMsgTime = Level.TimeSeconds;
		}
	}
}

function addLogMessage( coerce string aMessage )
{
	local LogMsg logObject;
	local string outPutMsg;

	if( aMessage != "" )
	{
		logObject = new class'LogMsg';

		if( logObject != none )
			logObject.setLogMessage( aMessage );
		else
			return;

		if( msgStack == none )
		{
			msgStack = new class'FIFOStack';

			if( msgStack == none )
				return;
		}

		msgStack.push( logObject );
	}
}

defaultproperties
{
	delayTime=3
	numMessages=1000
}
