// Stack container for Unreal Tournament 4.36 by James P.
// FIFO (First In First Out) version
// This can be used for storing objects for later use
// Inspired by http://www.cs.bu.edu/teaching/cs112/spring-2000/stack/
// Send comments and suggestions to iamfearless@gmail.com

class FIFOStack extends Stack;

// Add an object to the Stack
function push( Object anObject )
{
	local StackElement se, oldTopStackElement;

	se = getElement(); // get a StackElement

	if( se == none )
	{
		log( "Unable to get StackElement instance" );
		return;
	}

	if( isEmpty() ) // if stack is empty
	{
		setBottom( se );
		getBottom().setNext( none );
		getBottom().setReference( anObject );

		setTop( getBottom() ); // Bottom and top StackElement are one and the same
	}
	else
	{
		oldTopStackElement = getTop(); // Save reference to the current top StackElement
		setTop( se ); // Set topStackElement attribute to refer to the new StackElement
		getTop().setNext( none );
		oldTopStackElement.setNext( getTop() );
		getTop().setReference( anObject ); // Store reference to given object
	}

	setSize( getSize() + 1 );
}

// Get an object from the Stack (and suppress corresponding StackElement)
function Object pop()
{
	local Object anObject;
	local StackElement oldTopStackElement;

	if( isEmpty() )
		return none;

	anObject = getBottom().getReference(); // get object

	if( getTop() == getBottom() )
	{
		setTop( none );
		setBottom( none );
	}
	else
		setBottom( getBottom().getNext() );


	setSize( getSize() - 1 );

	return anObject;
}

// Test method
function logStackContents()
{
	local StackElement se;

	se = getBottom();

	while( se != none )
	{
		log( se.getReference() );

		se = se.getNext();
	}
}

defaultproperties
{

}
