//================================================================================
// TextTools for Unreal Tournament 4.36 by James P.
// A class for mod authors containing some useful functions
// Please give credit to the author if you modify this mod
//================================================================================
// Use class'TextTools'.SomeFunction()

class TextTools extends Object;

// Some code taken from http://wiki.beyondunreal.com/Legacy:Useful_String_Functions

static final function bool isLower( coerce string aString)
{
    return S == Lower(S);
}

static final function bool isUpper( coerce string aString )
{
    return S == Caps(S);
}

static final function bool toUpper( coerce string aString )
{
    return Caps(S);
}

static final function bool toLower( coerce string aString )
{
    return Lower(S);
}

static final function string LTrim(coerce string S)
{
        while (Left(S, 1) == " ")
                S = Right(S, Len(S) - 1);
        return S;
}

static final function string RTrim(coerce string S)
{
        while (Right(S, 1) == " ")
                S = Left(S, Len(S) - 1);
        return S;
}

static final function string Trim(coerce string S)
{
        return LTrim(RTrim(S));
}

/* function string ReplaceText( string Text, string Replace, coerce string With)
{
    local int i;
    local string Output;

    i = InStr(Text, Replace);
    while (i != -1) {
        Output = Output $ Left(Text, i) $ With;
        Text = Mid(Text, i + Len(Replace));
        i = InStr(Text, Replace);
    }
    Output = Output $ Text;
    return Output;
} */

static final function string ReplaceText(coerce string Text, coerce string Replace, coerce string With)
{
        local int i;
        local string Output;

        i = InStr(Text, Replace);
        while (i != -1) {
                Output = Output $ Left(Text, i) $ With;
                Text = Mid(Text, i + Len(Replace));
                i = InStr(Text, Replace);
        }
        Output = Output $ Text;
        return Output;
}

