//================================================================================
// ServerTools for Unreal Tournament 4.36 by James P.
// A class for mod authors containing some useful functions
// Please give credit to the author if you modify this mod
//================================================================================

class ServerTools extends Object;

function bool banIP( string ipString )
{
	local int i;

	if( ipString == "" )
		return;

	if( Level.Game != none )
	{
		if ( Level.Game.CheckIPPolicy( ipString ) )
		{
			for ( i=0; i < 50; i++)
			{
				if ( Level.Game.IPPolicies[ i ] == "" ) // Find empty slot
					break;
			}

			if ( i < 50 ) // Hard limit for standard ippolicies
			{
				Level.Game.IPPolicies[i] = "DENY," $ ipString;
				Level.Game.SaveConfig();

				return true;
			}
		}
	}

	return false;
}

function bool isInServerPackages( string serverPackageName )
{
	local string serverPackages;

	if( ServerPackageName != "" )
	{
		serverPackages = CAPS( ConsoleCommand( "get ini:Engine.Engine.GameEngine ServerPackages" ) );

		if( InStr( CAPS( serverPackages ) , CAPS( serverPackageName ) ) != -1 )
			return true;
	}

	return false;
}

// Code originally by iblokh
// http://forums.epicgames.com/showthread.php?t=450991
function string getServerPort()
{
	local string serverURL;
	local int i;

	serverURL = Level.GetAddressURL();	// Figure out the server's port.

	i = InStr( serverURL, ":" );

	assert(i>=0);
	return Mid(S,i+1);
}

// Date and time in YYYY.MM.DD-HH.MM.SS format
function string getShortAbsoluteTime()
{
	local string absoluteTime;

	AbsoluteTime = string( Level.Year );

	if( Level.Month < 10 )
		AbsoluteTime = AbsoluteTime$".0"$Level.Month;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Month;

	if( Level.Day < 10 )
		AbsoluteTime = AbsoluteTime$".0"$Level.Day;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Day;

	if( Level.Hour < 10 )
		AbsoluteTime = AbsoluteTime$".0"$Level.Hour;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Hour;

	if( Level.Minute < 10 )
		AbsoluteTime = AbsoluteTime$".0"$Level.Minute;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Minute;

	if( Level.Second < 10 )
		AbsoluteTime = AbsoluteTime$".0"$Level.Second;
	else
		AbsoluteTime = AbsoluteTime$"."$Level.Second;

	return absoluteTime;
}
