//================================================================================
// GameTools for Unreal Tournament 4.36 by James P.
// A class for mod authors containing some useful functions
// Please give credit to the author if you modify this mod
//================================================================================
// Use class'GameTools'.SomeFunction()
// Might require this directive when compiled: #exec OBJ LOAD FILE="../System/GameTools.u"

class GameTools extends Object;

/* Game specific */

function float getGameSpeed()
{
	if( Level.Game != none )
		return Level.Game.GameSpeed;

	return -1;
}

function bool setGameSpeed( float newGameSpeed )
{
	if( Level.Game != none )
		Level.Game.SetGameSpeed( newGameSpeed );

	return none;
}

function pauseGame()
{
	ConsoleCommand( "pause" );
}

function recordDemo( string demoName )
{
	if( demoName != "" )
		ConsoleCommand( "demorec" @ demoName );
}

function stopDemo()
{
	ConsoleCommand( "stopdemo" );
}

/* Game information */

function string getGamePauserName()
{
	return Level.Pauser;
}

// Dependencies: none
function bool isMutatorLoaded( class MutatorClass )
{
	local Mutator M;

	if( MutatorClass != none )
	{
		M = Level.Game.BaseMutator;

		while( M != none )
		{
			if( M.Class == MutatorClass )
				return true;

			M = M.NextMutator
		}
	}

	return false;
}

function makeBaseMutator( Mutator newBaseMutator )
{
	local Mutator oldBaseMutator;

	if( Level.Game != none )
	{
		oldBaseMutator = Level.Game.BaseMutator;
		newBaseMutator.NextMutator = oldBaseMutator;
		Level.Game.BaseMutator = newBaseMutator;
	}
}

function string convertSecondsToHMS( float TimeSeconds )
{
	local int hours, minutes, seconds;
	local string hmsString;

	if( timeSeconds <= 0 )
		return;

	hours = timeSeconds / 3600;

	if( hours != 0 )
		hmsString = hours $ "h";

	minutes = TimeSeconds - ( hours * 3600 );

	hmsString = hmsString $ minutes $ "m";

	seconds = TimeSeconds - ( minutes * 60 );

	hmsString = hmsString $ minutes $ "s";

	return timeString;
}

function string getGameTypeName()
{
	if( Level.Game != none )
		return Level.Game.GameName;
}

function broadCastMessage( string message )
{
	if( Level.Game != none )
		BroadcastMessage( message );
}

function int getTimeSinceGameStart()
{
	local float time;

	if( Level.Game != none )
	{
		if( Level.Game.GameReplicationInfo.RemainingTime > 0 )
		{
			time = ( TournamentGameReplicationInfo(Level.Game.GameReplicationInfo).TimeLimit * 60 )
						- Level.Game.GameReplicationInfo.RemainingTime;

			return time;
		}
		else
			return Level.Game.GameReplicationInfo.ElapsedTime;
	}

	return -1;
}

function int getNumberOfPlayers()
{
	local int totalNumPlayers;

	if( Level.Game != none )
	{
		totalNumPlayers = DeathMatchPlus(Level.Game).NumPlayers
			+ DeathMatchPlus(Level.Game).NumBots;

		return totalNumPlayers;
	}

	return -1;
}

function int getNumberOfHumans()
{
	if( Level.Game != none )
		return DeathMatchPlus(Level.Game).NumPlayers;

	return -1;
}

// Dependencies: none
/* function int getNumberOfBots()
{
	//if( Level.Game != none )
		return DeathMatchPlus(Level.Game).NumBots;

	return -1;
} */
