/*
 * Decompiled with CFR 0.152.
 */
package bothandler;

import bothandler.BHBotList;
import bothandler.BHGenerator;
import bothandler.BHLog;
import bothandler.BHState;
import bothandler.BotHandlerApp;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

class BHXExporter {
    BHBotList backup;
    String[] tNBackup;
    BHGenerator gen;
    File userFile;
    int numBots;

    BHXExporter() {
    }

    void generateBigList(BHGenerator generator, File expFile, String version) {
        if (version.equals("XBots055")) {
            this.numBots = 192;
        } else if (version.equals("XBots9b")) {
            this.numBots = 320;
        }
        this.backup = BotHandlerApp.bHLogic.bList;
        BotHandlerApp.bHLogic.bList = new BHBotList(this.numBots);
        this.tNBackup = BotHandlerApp.bHLogic.bSH.takenNames;
        BotHandlerApp.bHLogic.bSH.takenNames = new String[this.numBots];
        if (BHState.bFilledList) {
            for (int i = 0; i < 32; ++i) {
                BotHandlerApp.bHLogic.bList.bAccuracy[i] = this.backup.bAccuracy[i];
                BotHandlerApp.bHLogic.bList.bAlertness[i] = this.backup.bAlertness[i];
                BotHandlerApp.bHLogic.bList.bBotJumpy[i] = this.backup.bBotJumpy[i];
                BotHandlerApp.bHLogic.bList.bCamping[i] = this.backup.bCamping[i];
                BotHandlerApp.bHLogic.bList.bClasses[i] = this.backup.bClasses[i];
                BotHandlerApp.bHLogic.bList.bCombatStyle[i] = this.backup.bCombatStyle[i];
                BotHandlerApp.bHLogic.bList.bFaces[i] = this.backup.bFaces[i];
                BotHandlerApp.bHLogic.bList.bFavoriteWeapon[i] = this.backup.bFavoriteWeapon[i];
                BotHandlerApp.bHLogic.bList.bNames[i] = this.backup.bNames[i];
                BotHandlerApp.bHLogic.bList.bSkills[i] = this.backup.bSkills[i];
                BotHandlerApp.bHLogic.bList.bSkins[i] = this.backup.bSkins[i];
                BotHandlerApp.bHLogic.bList.bStrafingAbility[i] = this.backup.bStrafingAbility[i];
                BotHandlerApp.bHLogic.bList.bTeams[i] = this.backup.bTeams[i];
                BotHandlerApp.bHLogic.bList.bVoiceType[i] = this.backup.bVoiceType[i];
                BotHandlerApp.bHLogic.bSH.takenNames[i] = this.tNBackup[i];
            }
        }
        this.gen = generator;
        if (BHState.bFilledList) {
            this.gen.generate(32, this.numBots);
        } else {
            this.gen.generate(0, this.numBots);
        }
        this.userFile = expFile;
        this.saveXList(version);
        BotHandlerApp.bHLogic.bList = this.backup;
        BotHandlerApp.bHLogic.bSH.takenNames = this.tNBackup;
    }

    void saveXList(String version) {
        try {
            PrintWriter source = new PrintWriter(new FileWriter(this.userFile));
            BHBotList bList = BotHandlerApp.bHLogic.bList;
            BHLog.log("Writing XBot List in the file " + this.userFile.getName());
            if (version.equals("XBots9b")) {
                source.println("[XBots9b.XBotsChallengeBotInfo]");
                for (int i = 0; i < 32; ++i) {
                    source.println("SlotUsed[" + Integer.toString(i) + "]=1");
                }
                source.println("");
            }
            for (int lis = 1; lis < BotHandlerApp.bHLogic.bList.bClasses.length / 32; ++lis) {
                int i;
                if (version.equals("XBots055")) {
                    source.println("[XBots.XBotsBotInfoL0" + Integer.toString(lis) + "]");
                } else if (version.equals("XBots9b")) {
                    source.println("[XBots9b.XBotsBotInfoL0" + Integer.toString(lis) + "]");
                }
                for (i = 0; i < 32; ++i) {
                    source.println("slotUsed[" + Integer.toString(i) + "]=1");
                }
                for (i = 0; i < 32; ++i) {
                    source.println("VoiceType[" + Integer.toString(i) + "]=" + bList.bVoiceType[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    if (bList.bFaces[i + lis * 32].startsWith("[VOID]")) {
                        source.println("BotFaces[" + Integer.toString(i) + "]=");
                        continue;
                    }
                    source.println("BotFaces[" + Integer.toString(i) + "]=" + bList.bFaces[i + lis * 32]);
                }
                source.println("bAdjustSkill=" + bList.bAdjustSkill);
                source.println("bRandomOrder=" + bList.bRandomOrder);
                source.println("Difficulty=" + bList.Difficulty);
                for (i = 0; i < 32; ++i) {
                    source.println("BotNames[" + Integer.toString(i) + "]=" + bList.bNames[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("BotTeams[" + Integer.toString(i) + "]=" + bList.bTeams[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("BotSkills[" + Integer.toString(i) + "]=" + bList.bSkills[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("BotAccuracy[" + Integer.toString(i) + "]=" + bList.bAccuracy[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("CombatStyle[" + Integer.toString(i) + "]=" + bList.bCombatStyle[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("Alertness[" + Integer.toString(i) + "]=" + bList.bAlertness[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("Camping[" + Integer.toString(i) + "]=" + bList.bCamping[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("StrafingAbility[" + Integer.toString(i) + "]=" + bList.bStrafingAbility[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("FavoriteWeapon[" + Integer.toString(i) + "]=" + bList.bFavoriteWeapon[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("BotClasses[" + Integer.toString(i) + "]=" + bList.bClasses[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    if (bList.bSkins[i + lis * 32].startsWith("[VOID]")) {
                        source.println("BotSkins[" + Integer.toString(i) + "]=");
                        continue;
                    }
                    source.println("BotSkins[" + Integer.toString(i) + "]=" + bList.bSkins[i + lis * 32]);
                }
                for (i = 0; i < 32; ++i) {
                    source.println("BotJumpy[" + Integer.toString(i) + "]=" + bList.bBotJumpy[i + lis * 32]);
                }
                source.println("");
            }
            if (source != null) {
                source.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            BHLog.log("ERROR: File Streams in Save File caused an Exception");
        }
    }
}

