/*
 * Decompiled with CFR 0.152.
 */
package bothandler;

import bothandler.BHLog;
import bothandler.BHSkin;
import bothandler.BHType;
import bothandler.BHVoice;
import bothandler.BHWeapon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class BHSettingsImporter {
    static int MAX_TYPEZ = 128;
    static int MAX_SKINZ = 128;
    static int MAX_WEAPZ = 128;
    static int MAX_FACEZ = 16;
    static int MAX_NICKZ = 128;
    static int MAX_VOICEZ = 128;
    static final String settingsAppSectorName = "[APPLICATION_VALUES]";
    static final String settingsBotSectorName = "[BOT_LIST_VALUES]";
    static final String settingsWeaponSectorName = "[WEAPON_APPLICATION_VALUES]";
    static final String settingsVoiceSectorName = "[VOICE_APPLICATION_VALUES]";
    BHSkin[] skinz = new BHSkin[MAX_SKINZ];
    BHWeapon[] weapz = new BHWeapon[MAX_WEAPZ];
    BHType[] typez = new BHType[MAX_TYPEZ];
    BHVoice[] voicez = new BHVoice[MAX_VOICEZ];
    String cClass;
    String cClassName;
    String cVoiceType;
    int cClasses;
    int cIndices;
    int cSkins;
    int cFaces;
    int cFaceNames;
    int cNickNames;
    int cWeaps;
    int cVoiceTypes;
    int cVoices;

    public boolean readSettings(File sourceFile) {
        try {
            String s;
            BufferedReader source = new BufferedReader(new FileReader(sourceFile));
            int mode = 0;
            int subMode = 0;
            int lineCount = 0;
            boolean bAlreadyStartedReading = false;
            this.cClass = "";
            this.cClassName = "";
            this.cVoiceType = "";
            this.cClasses = -1;
            this.cIndices = 0;
            this.cSkins = 0;
            this.cFaces = 0;
            this.cFaceNames = 0;
            this.cNickNames = 0;
            this.cWeaps = 0;
            this.cVoiceTypes = -1;
            this.cVoices = 0;
            BHLog.log("Importing Program settings");
            while ((s = source.readLine()) != null) {
                if (!s.equals("") && !s.startsWith(";")) {
                    if (s.equals(settingsAppSectorName)) {
                        if (!bAlreadyStartedReading) {
                            mode = -300;
                        }
                    } else if (s.equals(settingsBotSectorName)) {
                        mode = 1;
                        bAlreadyStartedReading = true;
                    } else if (s.equals(settingsWeaponSectorName)) {
                        mode = 2;
                        bAlreadyStartedReading = true;
                    } else if (s.equals(settingsVoiceSectorName)) {
                        mode = 3;
                        bAlreadyStartedReading = true;
                    } else if (mode == -300) {
                        subMode = this.scanAppInputString(s, subMode);
                    } else if (mode == 1) {
                        subMode = this.scanBotInputString(s, subMode);
                    } else if (mode == 2) {
                        subMode = this.scanWeaponInputString(s, subMode);
                    } else if (mode == 3) {
                        subMode = this.scanVoiceInputString(s, subMode);
                    }
                    if (subMode == -1) {
                        BHLog.log("Found settings garbage at line " + Integer.toString(lineCount) + ": " + s);
                        subMode = 0;
                    } else if (subMode < -1 || subMode > 3) {
                        BHLog.log("Wrong subMode detected: " + Integer.toString(subMode));
                        subMode = 0;
                    }
                }
                ++lineCount;
            }
            BHLog.log("Importer read " + Integer.toString(lineCount) + " lines");
            if (source != null) {
                source.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            BHLog.log("ERROR: File Streams in Load Settings caused an Exception");
            return false;
        }
        BHLog.log("Import finished, cleaning the settings");
        this.cleanSettings();
        BHLog.log("Printing settings into the log:\n\n");
        this.debugPrintin();
        return true;
    }

    public int scanAppInputString(String s, int subMode) {
        if (s.startsWith("MaxClasses=")) {
            MAX_TYPEZ = Integer.parseInt(s.substring(11));
        } else if (s.startsWith("MaxSkins=")) {
            MAX_SKINZ = Integer.parseInt(s.substring(9));
        } else if (s.startsWith("MaxFaces=")) {
            MAX_FACEZ = Integer.parseInt(s.substring(9));
        } else if (s.startsWith("MaxNickNames=")) {
            MAX_NICKZ = Integer.parseInt(s.substring(13));
        } else if (s.startsWith("MaxWeapons=")) {
            MAX_WEAPZ = Integer.parseInt(s.substring(11));
        } else if (s.startsWith("MaxVoices=")) {
            MAX_VOICEZ = Integer.parseInt(s.substring(10));
        } else if (!s.startsWith("BHVersion=")) {
            subMode = -1;
        }
        return subMode;
    }

    public int scanBotInputString(String s, int subMode) {
        if (subMode == 0) {
            if (s.startsWith("BotClass=")) {
                ++this.cClasses;
                this.cClass = s.substring(9);
                this.typez[this.cClasses] = new BHType();
                this.typez[this.cClasses].tClass = this.cClass;
                this.cIndices = 0;
            } else if (s.startsWith("BotClassName=")) {
                this.typez[this.cClasses].tClassName = this.cClassName = s.substring(13);
            } else if (!s.startsWith("BotClassSource=") && !s.startsWith("BotClassBias=")) {
                if (s.startsWith("BotVoiceType=")) {
                    this.typez[this.cClasses].tVoiceType = this.cVoiceType = s.substring(13);
                } else if (!s.startsWith("BotDefaultVoice=")) {
                    if (s.startsWith("BotSkin=")) {
                        this.skinz[this.cSkins] = new BHSkin();
                        this.skinz[this.cSkins].botClass = this.cClass;
                        this.skinz[this.cSkins].botClassName = this.cClassName;
                        this.skinz[this.cSkins].botVoiceType = this.cVoiceType;
                        this.skinz[this.cSkins].botSkin = s.substring(8);
                        this.typez[this.cClasses].indices[this.cIndices] = this.cSkins;
                        ++this.cIndices;
                    } else if (s.startsWith("BotSkinName=")) {
                        this.skinz[this.cSkins].botSkinName = s.substring(12);
                    } else if (!s.startsWith("BotSkinSource=") && !s.startsWith("BotSkinBias=")) {
                        if (s.startsWith("BotFaces")) {
                            this.skinz[this.cSkins].botFaces = new String[MAX_FACEZ];
                            subMode = 1;
                        } else if (s.startsWith("BotFaceNames")) {
                            this.skinz[this.cSkins].botFaceNames = new String[MAX_FACEZ];
                            subMode = 2;
                        } else if (s.startsWith("BotNickNames")) {
                            this.skinz[this.cSkins].botNickNames = new String[MAX_NICKZ];
                            subMode = 3;
                        } else {
                            subMode = -1;
                        }
                    }
                }
            }
        } else if (subMode == 1) {
            if (s.startsWith("EndBotFaces")) {
                this.cFaces = 0;
                subMode = 0;
            } else {
                this.skinz[this.cSkins].botFaces[this.cFaces] = s.substring(1);
                ++this.cFaces;
            }
        } else if (subMode == 2) {
            if (s.startsWith("EndBotFaceNames")) {
                this.cFaceNames = 0;
                subMode = 0;
            } else {
                this.skinz[this.cSkins].botFaceNames[this.cFaceNames] = s.substring(1);
                ++this.cFaceNames;
            }
        } else if (subMode == 3) {
            if (s.startsWith("EndBotNickNames")) {
                this.cNickNames = 0;
                ++this.cSkins;
                subMode = 0;
            } else {
                this.skinz[this.cSkins].botNickNames[this.cNickNames] = s.substring(1);
                ++this.cNickNames;
            }
        }
        return subMode;
    }

    public int scanWeaponInputString(String s, int subMode) {
        if (s.startsWith("Weapon=")) {
            this.weapz[this.cWeaps] = new BHWeapon();
            this.weapz[this.cWeaps].weapon = s.substring(7);
        } else if (s.startsWith("WeaponName=")) {
            this.weapz[this.cWeaps].weaponName = s.substring(11);
        } else if (s.startsWith("WeaponRange=")) {
            this.weapz[this.cWeaps].weaponRange = s.substring(12);
        } else if (s.startsWith("WeaponPower=")) {
            this.weapz[this.cWeaps].weaponPower = s.substring(12);
            ++this.cWeaps;
        } else {
            subMode = -1;
        }
        return subMode;
    }

    public int scanVoiceInputString(String s, int subMode) {
        if (subMode == 0) {
            if (s.startsWith("VoiceType=")) {
                ++this.cVoiceTypes;
                this.voicez[this.cVoiceTypes] = new BHVoice();
                this.voicez[this.cVoiceTypes].vType = s.substring(10);
            } else if (s.startsWith("VoiceClasses")) {
                this.voicez[this.cVoiceTypes].vVoiceClasses = new String[MAX_VOICEZ];
                subMode = 1;
            } else if (s.startsWith("VoiceNames")) {
                this.voicez[this.cVoiceTypes].vVoiceNames = new String[MAX_VOICEZ];
                subMode = 2;
            } else {
                subMode = -1;
            }
        } else if (subMode == 1) {
            if (s.startsWith("EndVoiceClasses")) {
                this.cVoices = 0;
                subMode = 0;
            } else {
                this.voicez[this.cVoiceTypes].vVoiceClasses[this.cVoices] = s.substring(1);
                ++this.cVoices;
            }
        } else if (subMode == 2) {
            if (s.startsWith("EndVoiceNames")) {
                this.cVoices = 0;
                subMode = 0;
            } else {
                this.voicez[this.cVoiceTypes].vVoiceNames[this.cVoices] = s.substring(1);
                ++this.cVoices;
            }
        }
        return subMode;
    }

    public void cleanSettings() {
        int i;
        int i2;
        int i3;
        int j;
        int i4;
        int lastValue = 0;
        for (int i5 = 0; i5 < MAX_SKINZ; ++i5) {
            if (this.skinz[i5] != null) continue;
            lastValue = i5;
            break;
        }
        BHSkin[] newArray = new BHSkin[lastValue];
        for (i4 = 0; i4 < lastValue; ++i4) {
            newArray[i4] = this.skinz[i4];
        }
        this.skinz = newArray;
        for (i4 = 0; i4 < this.skinz.length; ++i4) {
            int j2;
            int j3;
            for (int j4 = 0; j4 < MAX_FACEZ; ++j4) {
                if (this.skinz[i4].botFaces[j4] != null) continue;
                lastValue = j4;
                break;
            }
            String[] newFaceArray = new String[lastValue];
            for (j3 = 0; j3 < lastValue; ++j3) {
                newFaceArray[j3] = this.skinz[i4].botFaces[j3];
            }
            this.skinz[i4].botFaces = newFaceArray;
            for (j3 = 0; j3 < MAX_FACEZ; ++j3) {
                if (this.skinz[i4].botFaceNames[j3] != null) continue;
                lastValue = j3;
                break;
            }
            String[] newFaceNameArray = new String[lastValue];
            for (j2 = 0; j2 < lastValue; ++j2) {
                newFaceNameArray[j2] = this.skinz[i4].botFaceNames[j2];
            }
            this.skinz[i4].botFaceNames = newFaceNameArray;
            for (j2 = 0; j2 < MAX_NICKZ; ++j2) {
                if (this.skinz[i4].botNickNames[j2] != null) continue;
                lastValue = j2;
                break;
            }
            String[] newNickArray = new String[lastValue];
            for (j = 0; j < lastValue; ++j) {
                newNickArray[j] = this.skinz[i4].botNickNames[j];
            }
            this.skinz[i4].botNickNames = newNickArray;
        }
        for (i4 = 0; i4 < MAX_WEAPZ; ++i4) {
            if (this.weapz[i4] != null) continue;
            lastValue = i4;
            break;
        }
        BHWeapon[] newWeapArray = new BHWeapon[lastValue];
        for (i3 = 0; i3 < lastValue; ++i3) {
            newWeapArray[i3] = this.weapz[i3];
        }
        this.weapz = newWeapArray;
        for (i3 = 0; i3 < MAX_SKINZ; ++i3) {
            if (this.typez[i3] != null) continue;
            lastValue = i3;
            break;
        }
        BHType[] newTypeArray = new BHType[lastValue];
        for (i2 = 0; i2 < lastValue; ++i2) {
            newTypeArray[i2] = this.typez[i2];
        }
        this.typez = newTypeArray;
        for (i2 = 0; i2 < this.typez.length; ++i2) {
            for (int j5 = 0; j5 < MAX_SKINZ; ++j5) {
                if (this.typez[i2].indices[j5] != -1) continue;
                lastValue = j5;
                break;
            }
            int[] newIndexArray = new int[lastValue];
            for (j = 0; j < lastValue; ++j) {
                newIndexArray[j] = this.typez[i2].indices[j];
            }
            this.typez[i2].indices = newIndexArray;
        }
        for (i2 = 0; i2 < MAX_VOICEZ; ++i2) {
            if (this.voicez[i2] != null) continue;
            lastValue = i2;
            break;
        }
        BHVoice[] newVoiceArray = new BHVoice[lastValue];
        for (i = 0; i < lastValue; ++i) {
            newVoiceArray[i] = this.voicez[i];
        }
        this.voicez = newVoiceArray;
        for (i = 0; i < this.voicez.length; ++i) {
            int j6;
            for (int j7 = 0; j7 < MAX_VOICEZ; ++j7) {
                if (this.voicez[i].vVoiceClasses[j7] != null) continue;
                lastValue = j7;
                break;
            }
            String[] newVoiceClassArray = new String[lastValue];
            for (j6 = 0; j6 < lastValue; ++j6) {
                newVoiceClassArray[j6] = this.voicez[i].vVoiceClasses[j6];
            }
            this.voicez[i].vVoiceClasses = newVoiceClassArray;
            for (j6 = 0; j6 < MAX_VOICEZ; ++j6) {
                if (this.voicez[i].vVoiceNames[j6] != null) continue;
                lastValue = j6;
                break;
            }
            String[] newVoiceNameArray = new String[lastValue];
            for (int j8 = 0; j8 < lastValue; ++j8) {
                newVoiceNameArray[j8] = this.voicez[i].vVoiceNames[j8];
            }
            this.voicez[i].vVoiceNames = newVoiceNameArray;
        }
    }

    public void debugPrintin() {
        BHLog.log("Max Classes: " + Integer.toString(MAX_TYPEZ) + "\nMax Skins: " + Integer.toString(MAX_SKINZ) + "\nMax Faces: " + Integer.toString(MAX_FACEZ) + "\nMax NickNames: " + Integer.toString(MAX_NICKZ) + "\nMax Weapons: " + Integer.toString(MAX_WEAPZ) + "\nMax Voices: " + Integer.toString(MAX_VOICEZ));
        BHLog.log("\n\n S K I N S\n=======================================");
        String s = "";
        for (int i = 0; i < this.skinz.length; ++i) {
            int j;
            s = s + "\nSKIN NUMBER " + Integer.toString(i + 1) + "\n  Class:      " + this.skinz[i].botClass + "\n  Class Name: " + this.skinz[i].botClassName + "\n  Voice Type: " + this.skinz[i].botVoiceType + "\n  Skin:       " + this.skinz[i].botSkin + "\n  Skin Name:  " + this.skinz[i].botSkinName;
            s = s + "\n  Face List:";
            for (j = 0; j < this.skinz[i].botFaces.length && !this.skinz[i].botFaces[j].equals(""); ++j) {
                s = s + "\n    " + this.skinz[i].botFaces[j];
            }
            s = s + "\n  Face Name List:";
            for (j = 0; j < this.skinz[i].botFaceNames.length && !this.skinz[i].botFaceNames[j].equals(""); ++j) {
                s = s + "\n    " + this.skinz[i].botFaceNames[j];
            }
            s = s + "\n  Nick Name List:";
            for (j = 0; j < this.skinz[i].botNickNames.length && !this.skinz[i].botNickNames[j].equals(""); ++j) {
                s = s + "\n    " + this.skinz[i].botNickNames[j];
            }
            s = s + "\n";
        }
        BHLog.log(s);
        BHLog.log("\n\n T Y P E S\n=======================================");
        String c = "";
        for (int i = 0; i < this.typez.length; ++i) {
            c = c + "\nCLASS NUMBER " + Integer.toString(i + 1) + "\n  Class: " + this.typez[i].tClass + "\n  Class Name: " + this.typez[i].tClassName + "\n  Voice Type: " + this.typez[i].tVoiceType + "\n  Index List:";
            for (int j = 0; j < this.typez[i].indices.length && this.typez[i].indices[j] != -1; ++j) {
                c = c + "\n    " + this.typez[i].indices[j];
            }
            c = c + "\n";
        }
        BHLog.log(c);
        BHLog.log("\n\n W E A P O N S\n=======================================");
        String w = "";
        for (int i = 0; i < this.weapz.length; ++i) {
            w = w + "\nWEAPON NUMBER " + Integer.toString(i + 1) + "\n  Weapon: " + this.weapz[i].weapon + "\n  Weapon Name: " + this.weapz[i].weaponName + "\n  Weapon Range: " + this.weapz[i].weaponRange + "\n  Weapon Power: " + this.weapz[i].weaponPower + "\n";
        }
        BHLog.log(w);
        BHLog.log("\n\n V O I C E S\n=======================================");
        String u = "";
        for (int i = 0; i < this.voicez.length; ++i) {
            int j;
            u = u + "\nVOICE TYPE NUMBER " + Integer.toString(i + 1) + "\n  Type: " + this.voicez[i].vType + "\n  Voice List:";
            for (j = 0; j < this.voicez[i].vVoiceClasses.length && !this.voicez[i].vVoiceClasses[j].equals(""); ++j) {
                u = u + "\n    " + this.voicez[i].vVoiceClasses[j];
            }
            u = u + "\n  Voice Name List:";
            for (j = 0; j < this.voicez[i].vVoiceNames.length && !this.voicez[i].vVoiceNames[j].equals(""); ++j) {
                u = u + "\n    " + this.voicez[i].vVoiceNames[j];
            }
            u = u + "\n";
        }
        BHLog.log(u + "\n\n");
    }
}

