/*
 * Decompiled with CFR 0.152.
 */
package bothandler;

import bothandler.BHBotList;
import bothandler.BHLog;
import bothandler.BHSettingsHandler;
import bothandler.BHSkin;
import bothandler.BotHandlerApp;

class BHGenerator {
    static final int RAND_INTEGER = -300;
    static final String RAND_STRING = "[BOTHANDLERRANDOMVALUE]";
    static final String DEFAULT_STRING = "";
    boolean genFaces;
    boolean genNames;
    boolean genTeams;
    boolean genClasses;
    boolean genSkins;
    boolean genVoiceType;
    boolean genSkills;
    boolean genAccuracy;
    boolean genCombatStyle;
    boolean genAlertness;
    boolean genCamping;
    boolean genStrafingAbility;
    boolean genFavoriteWeapon;
    boolean genBotJumpy;
    float chaTeams;
    float chaVoiceType;
    float chaSkills;
    float chaAccuracy;
    float chaCombatStyle;
    float chaAlertness;
    float chaCamping;
    float chaStrafingAbility;
    float chaFavoriteWeapon;
    float chaBotJumpy;
    String vFaces;
    String vNames;
    int vTeams;
    String vClasses;
    String vSkins;
    String vVoiceType;
    float vSkillsUp;
    float vSkillsDn;
    float vAccuracyUp;
    float vAccuracyDn;
    float vCombatStyleUp;
    float vCombatStyleDn;
    float vAlertnessUp;
    float vAlertnessDn;
    float vCampingUp;
    float vCampingDn;
    float vStrafingAbilityUp;
    float vStrafingAbilityDn;
    String vFavoriteWeapon;
    int vBotJumpy;

    public BHGenerator() {
        this.setBools(true);
        this.setDefaults();
        this.setChances(0.5f);
    }

    public BHGenerator(boolean a) {
        this.setBools(a);
        this.setDefaults();
        this.setChances(0.5f);
    }

    public BHGenerator(boolean a, String s) {
        this.setBools(a);
        if (s.equals(RAND_STRING)) {
            this.setRandoms();
        }
        if (s.equals(DEFAULT_STRING)) {
            this.setDefaults();
        }
        this.setChances(0.5f);
    }

    public BHGenerator(boolean a, String s, float chance) {
        this.setBools(a);
        if (s.equals(RAND_STRING)) {
            this.setRandoms();
        }
        if (s.equals(DEFAULT_STRING)) {
            this.setDefaults();
        }
        this.setChances(chance);
    }

    public void generate(int i) {
        BHLog.log("Generator activated");
        if (this.genNames) {
            BotHandlerApp.bHLogic.bSH.cleanTakenNames(i);
        }
        BotHandlerApp.bHLogic.bSH.updateRandom();
        BHLog.log("Created new Random class");
        this.logGenValues();
        this.generateFunc(i);
        BHLog.log("Bot generated, printing the result on log:\n\n");
        BotHandlerApp.bHLogic.logBotValues(i);
        BHLog.log("\n\nGeneration complete");
    }

    public void generate(int[] indices) {
        if (indices != null) {
            int i;
            BHLog.log("Generator activated");
            if (this.genNames) {
                BotHandlerApp.bHLogic.bSH.cleanTakenNames(indices);
            }
            BotHandlerApp.bHLogic.bSH.updateRandom();
            BHLog.log("Created new Random class");
            this.logGenValues();
            for (i = 0; i < indices.length; ++i) {
                this.generateFunc(indices[i]);
            }
            BHLog.log("Bots generated, printing the results on log:\n\n");
            for (i = 0; i < indices.length; ++i) {
                BotHandlerApp.bHLogic.logBotValues(indices[i]);
            }
            BHLog.log("\n\nGeneration complete");
        }
    }

    public void generate(int from, int to) {
        int i;
        BHLog.log("Generator activated");
        if (this.genNames) {
            BotHandlerApp.bHLogic.bSH.cleanTakenNames(from, to);
        }
        BotHandlerApp.bHLogic.bSH.updateRandom();
        BHLog.log("Created new Random class");
        this.logGenValues();
        for (i = from; i < to; ++i) {
            this.generateFunc(i);
        }
        BHLog.log("Bots generated, printing the results on log:\n\n");
        for (i = from; i < to; ++i) {
            BotHandlerApp.bHLogic.logBotValues(i);
        }
        BHLog.log("\n\nGeneration complete");
    }

    void generateFunc(int i) {
        BHBotList bB = BotHandlerApp.bHLogic.bList;
        BHSettingsHandler bSH = BotHandlerApp.bHLogic.bSH;
        String[] tempResults = new String[2];
        if (this.genNames || this.genFaces) {
            if (!this.genClasses) {
                this.vClasses = bB.bClasses[i];
            }
            if (!this.genSkins) {
                this.vSkins = bB.bSkins[i];
            }
            if (!this.genFaces) {
                this.vFaces = bB.bFaces[i];
            }
            if (!this.genNames) {
                this.vNames = bB.bNames[i];
            }
            if (this.vNames.equals(DEFAULT_STRING)) {
                this.vNames = " ";
            }
            tempResults = bSH.getFacesAndNames(this.vNames, this.findFace(this.vFaces, this.findSkin(this.vSkins)), this.findSkin(this.vSkins), this.findClass(this.vClasses), i, this.genNames, this.genFaces);
            if (this.genNames) {
                bB.bNames[i] = tempResults[0];
            }
            if (this.genFaces) {
                bB.bFaces[i] = tempResults[1];
            }
            if (this.genSkins) {
                bB.bSkins[i] = tempResults[2];
            }
            if (this.genClasses) {
                bB.bClasses[i] = tempResults[3];
            }
        }
        if (this.genTeams) {
            bB.bTeams[i] = Integer.toString(bSH.getTeams(this.vTeams, this.chaTeams));
        }
        if (this.genFavoriteWeapon) {
            bB.bFavoriteWeapon[i] = bSH.getFavoriteWeapon(this.vFavoriteWeapon, this.chaFavoriteWeapon);
        }
        if (this.genVoiceType) {
            bB.bVoiceType[i] = bSH.getVoiceType(this.vVoiceType, this.chaVoiceType);
        }
        if (this.genSkills) {
            bB.bSkills[i] = this.floatTS(bSH.getSpins(this.vSkillsUp, this.vSkillsDn, 10, this.chaSkills));
        }
        if (this.genAccuracy) {
            bB.bAccuracy[i] = this.floatTS(bSH.getSpins(this.vAccuracyUp, this.vAccuracyDn, 10, this.chaAccuracy));
        }
        if (this.genCombatStyle) {
            bB.bCombatStyle[i] = this.floatTS(bSH.getSpins(this.vCombatStyleUp, this.vCombatStyleDn, 2, this.chaCombatStyle));
        }
        if (this.genAlertness) {
            bB.bAlertness[i] = this.floatTS(bSH.getSpins(this.vAlertnessUp, this.vAlertnessDn, 10, this.chaAlertness));
        }
        if (this.genCamping) {
            bB.bCamping[i] = this.floatTS(bSH.getSpins(this.vCampingUp, this.vCampingDn, 10, this.chaCamping));
        }
        if (this.genStrafingAbility) {
            bB.bStrafingAbility[i] = this.floatTS(bSH.getSpins(this.vStrafingAbilityUp, this.vStrafingAbilityDn, 10, this.chaStrafingAbility));
        }
        if (this.genBotJumpy) {
            bB.bBotJumpy[i] = Math.random() < (double)this.chaBotJumpy ? Integer.toString(1) : Integer.toString(0);
        }
    }

    public void setBools(boolean a) {
        this.genFaces = a;
        this.genNames = a;
        this.genTeams = a;
        this.genClasses = a;
        this.genSkins = a;
        this.genVoiceType = a;
        this.genSkills = a;
        this.genAccuracy = a;
        this.genCombatStyle = a;
        this.genAlertness = a;
        this.genCamping = a;
        this.genStrafingAbility = a;
        this.genFavoriteWeapon = a;
        this.genBotJumpy = a;
    }

    public void setRandoms() {
        this.vFaces = RAND_STRING;
        this.vNames = RAND_STRING;
        this.vTeams = -300;
        this.vClasses = RAND_STRING;
        this.vSkins = RAND_STRING;
        this.vVoiceType = RAND_STRING;
        this.vSkillsUp = 3.0f;
        this.vSkillsDn = -3.0f;
        this.vAccuracyUp = 1.0f;
        this.vAccuracyDn = -1.0f;
        this.vCombatStyleUp = 1.0f;
        this.vCombatStyleDn = -1.0f;
        this.vAlertnessUp = 1.0f;
        this.vAlertnessDn = -1.0f;
        this.vCampingUp = 1.0f;
        this.vCampingDn = 0.0f;
        this.vStrafingAbilityUp = 1.0f;
        this.vStrafingAbilityDn = -1.0f;
        this.vFavoriteWeapon = RAND_STRING;
        this.vBotJumpy = -300;
    }

    public void setDefaults() {
        this.vFaces = DEFAULT_STRING;
        this.vNames = DEFAULT_STRING;
        this.vTeams = 255;
        this.vClasses = DEFAULT_STRING;
        this.vSkins = DEFAULT_STRING;
        this.vVoiceType = DEFAULT_STRING;
        this.vSkillsUp = 0.0f;
        this.vSkillsDn = 0.0f;
        this.vAccuracyUp = 0.0f;
        this.vAccuracyDn = 0.0f;
        this.vCombatStyleUp = 0.0f;
        this.vCombatStyleDn = 0.0f;
        this.vAlertnessUp = 0.0f;
        this.vAlertnessDn = 0.0f;
        this.vCampingUp = 0.0f;
        this.vCampingDn = 0.0f;
        this.vStrafingAbilityUp = 0.0f;
        this.vStrafingAbilityDn = 0.0f;
        this.vFavoriteWeapon = DEFAULT_STRING;
        this.vBotJumpy = 0;
    }

    public void setChances(float value) {
        this.chaTeams = value;
        this.chaVoiceType = value;
        this.chaSkills = value;
        this.chaAccuracy = value;
        this.chaCombatStyle = value;
        this.chaAlertness = value;
        this.chaCamping = value;
        this.chaStrafingAbility = value;
        this.chaFavoriteWeapon = value;
        this.chaBotJumpy = value;
    }

    int findClass(String s) {
        if (s.equals(RAND_STRING)) {
            return -300;
        }
        int pos = -300;
        for (int i = 0; i < BotHandlerApp.bHLogic.typez.length; ++i) {
            if (!BotHandlerApp.bHLogic.typez[i].tClass.equals(s)) continue;
            pos = i;
        }
        return pos;
    }

    int findWeapon(String s) {
        if (s.equals(RAND_STRING)) {
            return -300;
        }
        int pos = -300;
        for (int i = 0; i < BotHandlerApp.bHLogic.weapz.length; ++i) {
            if (!BotHandlerApp.bHLogic.weapz[i].weapon.equals(s)) continue;
            pos = i;
        }
        return pos;
    }

    int findSkin(String s) {
        if (s.equals(RAND_STRING)) {
            return -300;
        }
        int pos = -300;
        for (int i = 0; i < BotHandlerApp.bHLogic.skinz.length; ++i) {
            if (!BotHandlerApp.bHLogic.skinz[i].botSkin.equals(s)) continue;
            pos = i;
        }
        return pos;
    }

    int findFace(String s, int skinIndex) {
        if (skinIndex == -300) {
            return -300;
        }
        String[] temp = BotHandlerApp.bHLogic.skinz[skinIndex].botFaces;
        int pos = -300;
        for (int i = 0; i < temp.length; ++i) {
            if (!temp[i].equals(s)) continue;
            pos = i;
        }
        return pos;
    }

    String deriveSkin(String fa) {
        BHSkin[] skinz = BotHandlerApp.bHLogic.skinz;
        boolean shouldContinue = true;
        String s = "Not Found";
        for (int i = 0; i < skinz.length && shouldContinue; ++i) {
            for (int j = 0; j < skinz[i].botFaces.length; ++j) {
                if (!skinz[i].botFaces[j].equals(fa)) continue;
                s = skinz[i].botSkin;
                shouldContinue = false;
            }
        }
        return s;
    }

    String deriveClass(String fa) {
        BHSkin[] skinz = BotHandlerApp.bHLogic.skinz;
        boolean shouldContinue = true;
        String s = "Not Found";
        for (int i = 0; i < skinz.length && shouldContinue; ++i) {
            for (int j = 0; j < skinz[i].botFaces.length; ++j) {
                if (!skinz[i].botFaces[j].equals(fa)) continue;
                s = skinz[i].botClass;
                shouldContinue = false;
            }
        }
        return s;
    }

    int findVoiceType(String s) {
        if (s.equals(RAND_STRING)) {
            return -300;
        }
        int pos = -300;
        for (int i = 0; i < BotHandlerApp.bHLogic.voicez.length; ++i) {
            for (int k = 0; k < BotHandlerApp.bHLogic.voicez[i].vVoiceClasses.length; ++k) {
                if (!BotHandlerApp.bHLogic.voicez[i].vVoiceClasses[k].equals(s)) continue;
                pos = i;
            }
        }
        return pos;
    }

    int findVoice(String s) {
        if (s.equals(RAND_STRING)) {
            return -300;
        }
        int pos = -300;
        for (int i = 0; i < BotHandlerApp.bHLogic.voicez.length; ++i) {
            for (int k = 0; k < BotHandlerApp.bHLogic.voicez[i].vVoiceClasses.length; ++k) {
                if (!BotHandlerApp.bHLogic.voicez[i].vVoiceClasses[k].equals(s)) continue;
                pos = k;
            }
        }
        return pos;
    }

    int findVoiceGlobal(String s) {
        if (s.equals(RAND_STRING)) {
            return -300;
        }
        int pos = -300;
        int c = 0;
        for (int i = 0; i < BotHandlerApp.bHLogic.voicez.length; ++i) {
            int k = 0;
            while (k < BotHandlerApp.bHLogic.voicez[i].vVoiceClasses.length) {
                if (BotHandlerApp.bHLogic.voicez[i].vVoiceClasses[k].equals(s)) {
                    pos = c;
                }
                ++k;
                ++c;
            }
        }
        return pos;
    }

    String getVoice(int index) {
        int pos = -300;
        int c = 0;
        for (int i = 0; i < BotHandlerApp.bHLogic.voicez.length; ++i) {
            int k = 0;
            while (k < BotHandlerApp.bHLogic.voicez[i].vVoiceClasses.length) {
                if (c == index) {
                    return BotHandlerApp.bHLogic.voicez[i].vVoiceClasses[k];
                }
                ++k;
                ++c;
            }
        }
        BHLog.log("Error in GetVoice for Voice n. " + Integer.toString(index));
        return "ERROR";
    }

    public String floatTS(float f) {
        return this.floatTS(Float.toString(f));
    }

    public String floatTS(String s) {
        int q = s.length();
        if (s.startsWith("-")) {
            for (int i = q; i < 9; ++i) {
                s = s + "0";
            }
        } else {
            for (int i = q; i < 8; ++i) {
                s = s + "0";
            }
        }
        return s;
    }

    void logGenValues() {
        BHLog.log("Checking interface values");
        this.checkSpinner(this.vSkillsDn, this.vSkillsUp, "Skill");
        this.checkSpinner(this.vAccuracyDn, this.vAccuracyUp, "Accuracy");
        this.checkSpinner(this.vAlertnessDn, this.vAlertnessUp, "Alertness");
        this.checkSpinner(this.vCampingDn, this.vCampingUp, "Skill");
        this.checkSpinner(this.vStrafingAbilityDn, this.vStrafingAbilityUp, "Strafing Ability");
    }

    void checkSpinner(float low, float high, String paramName) {
        if (low > high) {
            BHLog.log("Spinner values for " + paramName + " are " + "incorrect:\n  Min " + Float.toString(low) + " is higher " + "than Max " + Float.toString(high));
        }
    }
}

