/*
 * Decompiled with CFR 0.152.
 */
package bothandler;

import bothandler.BHFileSaver;
import bothandler.BHLog;
import bothandler.BotHandlerApp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class BHFileExporter {
    File userFile;
    File tempFile;

    public boolean exportFile(File userFile) {
        boolean bFoundBotSector = false;
        boolean toReturn = false;
        int mode = 0;
        int lines = 0;
        try {
            String s;
            this.tempFile = File.createTempFile("BHTEMPFILE", ".temp");
            BHLog.log("Created new Temp File, " + this.tempFile.getName());
            BufferedReader source = new BufferedReader(new FileReader(userFile));
            while ((s = source.readLine()) != null) {
                ++lines;
                if (s.equals("[Botpack.ChallengeBotInfo]")) {
                    bFoundBotSector = true;
                    BHLog.log("Found: " + s + ", at line " + Integer.toString(lines));
                }
                if (s.startsWith("bAdjustSkill=")) {
                    BotHandlerApp.bHLogic.bList.bAdjustSkill = s.substring(13);
                    continue;
                }
                if (s.startsWith("bRandomOrder=")) {
                    BotHandlerApp.bHLogic.bList.bRandomOrder = s.substring(13);
                    continue;
                }
                if (!s.startsWith("Difficulty=")) continue;
                BotHandlerApp.bHLogic.bList.Difficulty = s.substring(11);
            }
            if (source != null) {
                source.close();
            }
            if (!bFoundBotSector) {
                BHLog.log("Bot Sector not found in the selected file, aborting export procedure.");
                return false;
            }
            source = new BufferedReader(new FileReader(userFile));
            PrintWriter temp = new PrintWriter(new FileWriter(this.tempFile));
            BHLog.log("Writing file content before the Bot Sector");
            while ((s = source.readLine()) != null && !s.equals("[Botpack.ChallengeBotInfo]")) {
                temp.println(s);
            }
            if (temp != null) {
                temp.close();
            }
            if (source != null) {
                source.close();
            }
            new BHFileSaver().saveFile(true, this.tempFile);
            source = new BufferedReader(new FileReader(userFile));
            temp = new PrintWriter(new FileWriter(this.tempFile, true));
            lines = 0;
            BHLog.log("Writing file content after the Bot Sector");
            block9: while ((s = source.readLine()) != null) {
                switch (mode) {
                    case 0: {
                        ++lines;
                        if (!s.equals("[Botpack.ChallengeBotInfo]")) continue block9;
                        mode = 1;
                        continue block9;
                    }
                    case 1: {
                        ++lines;
                        if (!s.startsWith("[")) continue block9;
                        temp.println(s);
                        BHLog.log("Found another sector at line " + Integer.toString(lines));
                        mode = 2;
                        continue block9;
                    }
                    case 2: {
                        temp.println(s);
                        continue block9;
                    }
                }
            }
            if (temp != null) {
                temp.close();
            }
            if (source != null) {
                source.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            BHLog.log("ERROR: File Streams caused an Exception");
            return false;
        }
        BHLog.log("Going to copy Temp File " + this.tempFile.getName() + " on User File " + userFile.getName());
        toReturn = this.copyFiles(this.tempFile, userFile);
        this.tempFile.delete();
        return toReturn;
    }

    public boolean copyFiles(File sourceFile, File destFile) {
        try {
            String s;
            BufferedReader source = new BufferedReader(new FileReader(sourceFile));
            PrintWriter dest = new PrintWriter(new FileWriter(destFile));
            while ((s = source.readLine()) != null) {
                dest.println(s);
            }
            if (source != null) {
                source.close();
            }
            if (dest != null) {
                dest.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            BHLog.log("ERROR: File Streams in Copy Files caused an Exception");
            return false;
        }
        return true;
    }
}

