//////////////////////////////////////////////////////////////////////////////
// uHTTPLink - UScript HTTP Linker
//		Feralidragon - 03-07-2013
//
//		uWebDrvX 0.1
//////////////////////////////////////////////////////////////////////////////

class uHTTPLink extends UBrowserHTTPClient;

var() int HTTPConnectionTimeout;
var() int HTTPPort;
var uHTTPServiceInfo uHTTPCallBack;


final function getURLContents(string InURL, uHTTPServiceInfo uHTTP)
{
local string httpPre, domain, uri;
local int pos;

	if (uHTTP == None || uHTTP.bDeleteMe)
		return;
	uHTTPCallBack = uHTTP;
	
	if (InStr(InURL, "http://") == 0)
		httpPre = "http://";
	else if (InStr(InURL, "https://") == 0)
		httpPre = "https://";
	InURL = Mid(InURL, Len(httpPre));

	pos = InStr(InURL, "/");
	if (pos < 0)
		pos = InStr(InURL, "?");
	if (pos >= 0)
	{
		domain = Mid(InURL, 0, pos);
		uri = Mid(InURL, pos);
	}
	else
		domain = InURL;
	
	Browse(domain, uri, HTTPPort, HTTPConnectionTimeout);
}

function HTTPReceivedData(string Data)
{
	if (uHTTPCallBack != None)
		uHTTPCallBack.receiveHTTPResponse(Data);
	SetTimer(0.0, False);
}

function HTTPError(int Code)
{
	if (uHTTPCallBack != None)
		uHTTPCallBack.receiveHTTPResponse(,Code);
	SetTimer(0.0, False);
}


defaultproperties
{
	RemoteRole=ROLE_None
	HTTPConnectionTimeout=30
	HTTPPort=80
}


