//////////////////////////////////////////////////////////////////////////////
// uDBSTCol - UScript Database System Table column
//		Feralidragon - 09-07-2013
//
//		uWebDrvX 0.1
//////////////////////////////////////////////////////////////////////////////

class uDBSTCol_BoolA extends uDBSTCol config(uDBS)
abstract;

var() config byte Data[128];
var byte loadedData[128];

var() bool defaultData;


static function bool loadCol(class<uDBS> DBClass, class<uDBSTable> DBTable)
{
local int i;

	if (!Super.loadCol(DBClass, DBTable))
		return False;
	for (i = 0; i < default.loadedCSize; i++)
		default.loadedData[i] = default.Data[i];
	return True;
}

static function int getRealSize()
{
	return ArrayCount(default.Data);
}

static function string getToString(int index)
{
	if (Super.getToString(index) == "ERROR")
		return "";
	if (Bool(default.loadedData[index]))
		return "TRUE";
	return "FALSE";
}

static function bool getBool(int index)
{
	if (!Super.getBool(index))
		return False;
	return Bool(default.loadedData[index]);
}

static function bool setBool(int index, bool val)
{
	if (!Super.setBool(index, val))
		return False;
	default.loadedData[index] = Byte(val);
	return True;
}

static function bool addBool(bool val, optional out int index)
{
	if (!Super.addBool(val, index))
		return False;
	default.loadedData[index] = Byte(val);
	return True;
}

static function bool addDefault()
{
	return addBool(default.defaultData);
}

static function bool removeBool(int index, optional bool bResetOnly)
{
local int i;

	if (!Super.removeBool(index, bResetOnly))
		return False;
	if (bResetOnly)
		default.loadedData[index] = 0;
	else
	{
		default.loadedCSize--;
		for (i = index; i < default.loadedCSize; i++)
			default.loadedData[i] = default.loadedData[i+1];
		default.loadedData[default.loadedCSize] = 0;
	}
	return True;
}


defaultproperties
{
	ColType=CT_BOOL
}


