//////////////////////////////////////////////////////////////////////////////
// uBaseLXIV (uBase64) - UScript base64 encode/decode class
//		Feralidragon - 04-07-2013
//
//		uWebDrvX 0.1
//////////////////////////////////////////////////////////////////////////////

class uBaseLXIV extends Object 
abstract;

var const string BASE64_SCHARS[4];


static final function string getBase64Encode(string S, optional bool useAltChars, optional bool addPadding)
{
local int b24bits, bpos, gchars, restchars, i, j;
local string b64Piece, c[3], benc64;

	for (i = 0; i < Len(S); i += 3)
	{
		b64Piece = Mid(S, i, 3);
		b24bits = 0x000000;
		for (j = 0; j < Len(b64Piece); j++)
		{
			c[j] = Mid(b64Piece, j, 1);
			if (c[j] != "")
				b24bits = (b24bits | (asc(c[j]) << ((2-j)*8)));
		}
		
		gchars = 4;
		restchars = (Len(b64Piece) % 3);
		if (restchars > 0)
			gchars = restchars + 1;
		for (j = 0; j < gchars; j++)
		{
			bpos = ((b24bits >>> ((3-j)*6)) & 0x00003F);
			if (bpos <= 25)
				benc64 = benc64 $ chr(bpos + 65);
			else if (bpos <= 51)
				benc64 = benc64 $ chr(bpos + 71);
			else if (bpos <= 61)
				benc64 = benc64 $ chr(bpos - 4);
			else
				benc64 = benc64 $ default.BASE64_SCHARS[int(useAltChars)*2 + (bpos-62)];
		}
		
		if (addPadding)
		{
			if (restchars == 1)
				benc64 = benc64 $ "==";
			else if (restchars == 2)
				benc64 = benc64 $ "=";
		}
	}
	
	return benc64;
}


static final function string getBase64Decode(string S)
{
local int b24bits, i, j, cAsc, b;
local string encPiece, c, bdec64;

	for (i = 0; i < Len(S); i += 4)
	{
		encPiece = Mid(S, i, 4);
		b24bits = 0x000000;
		for (j = 0; j < Len(encPiece); j++)
		{
			c = Mid(encPiece, j, 1);
			if (c == "" || c == "=")
				break;
				
			cAsc = asc(c);
			if (c == default.BASE64_SCHARS[0] || c == default.BASE64_SCHARS[2])
				b = 62;
			else if (c == default.BASE64_SCHARS[1] || c == default.BASE64_SCHARS[3])
				b = 63;
			else if (cAsc >= 65 && cAsc <= 90)
				b = cAsc - 65;
			else if (cAsc >= 97 && cAsc <= 122)
				b = cAsc - 71;
			else if (cAsc >= 48 && cAsc <= 57)
				b = cAsc + 4;
			else
			{
				log("BASE64 Decode Error: Invalid Base64 string provided");
				return "";
			}
				
			b24bits = (b24bits | (b << ((3-j)*6)));
		}
		
		for (j = 0; j < 3; j++)
		{
			cAsc = ((b24bits >>> ((2-j)*8)) & 0x0000FF);
			if (cAsc == 0)
				break;
			bdec64 = bdec64 $ chr(cAsc);
		}
	}
	
	return bdec64;
}


defaultproperties
{
	BASE64_SCHARS(0)="+"
	BASE64_SCHARS(1)="/"
	BASE64_SCHARS(2)="_"
	BASE64_SCHARS(3)="*"
}


