#include "pskhack-epicstuff.h"

#define POLY_TRANS 0x2
#define POLY_ENV 0x40
#define POLY_NOSMOOTH 0x80
#define POLY_UNLIT 0x10
#define POLY_TWOS 0x1
#define POLY_MODULATED 0x4
#define POLY_MASKED 0x3

#define HEAD_POINTS "PNTS0000"
#define HEAD_WEDGES "VTXW0000"
#define HEAD_TRIS "FACE0000"
#define HEAD_MATS "MATT0000"
#define HEAD_WEIGHTS "RAWWEIGHTS"
#define HEAD_BONES "REFSKELT"
#define HEAD_BONES_PSA "REFSKELT"
#define HEAD_HEADER "ACTRHEAD"

#define CHUNK struct VChunkHeader

struct PSKStruct
{
	CHUNK h_head;
	CHUNK h_point;
	struct FVector * points;
	CHUNK h_wedge;
	struct VVertex * wedges;
	CHUNK h_tri;
	struct VTriangle * tris;
	CHUNK h_mat;
	struct VMaterial * mats;
	CHUNK h_bone;
	struct VBone * bones;
	CHUNK h_weight;
	struct VRawBoneInfluence * weights;
};

void empty_psk(struct PSKStruct * data)
{
	if(data->points)
	{
		free(data->points);
		data->points = 0;
	}
	if(data->wedges)
	{
		free(data->wedges);
		data->wedges = 0;
	}
	if(data->bones)
	{
		free(data->bones);
		data->bones = 0;
	}
	if(data->tris)
	{
		free(data->tris);
		data->tris = 0;
	}
	if(data->weights)
	{
		free(data->weights);
		data->weights = 0;
	}
	if(data->mats)
	{
		free(data->mats);
		data->mats = 0;
	}
}