/*
pskhack.c
	Author: Simon "Psychic_313" McVittie
	Language: Inexpertly written C
	Purpose: Tweak flag bits in PSK files

COMPILING WITH LINUX
gcc pskhack.c -o pskhack

COMPILING WITH MINIMAL GNU FOR WINDOWS
Put it on the same drive as MinGW (important! gcc doesn't like working across drives)
Go to a DOS prompt and cd to the folder with the source in
gcc pskhack.c -o pskhack.exe

COMPILING WITH ANYTHING ELSE
Your guess is as good as mine. It's all ANSI C, I think.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pskhack.h"

/* Returns bool for whether test is in the set [lbound,ubound] */
int isin(const int lbound, const int test, const int ubound)
{
	return (test >= lbound) && (test <= ubound);
}

char* strnrep(char *str, const char search, const char replace, const int n)
{
	int i;
	for(i=0;i<n;i++)
	{
		if(str[i]==0)
			break;
		if(str[i]==search)
			str[i]=replace;
	}
	return str;
}

const char *usagestr = "\
Unreal Tournament PSK Hack by Simon 'Psychic_313' McVittie.\n\
\n\
    Not documented yet.\n\
";

int process(char* in, char* out)
{
	struct VChunkHeader header;
    struct VBone bone;
    struct VRawBoneInfluence rawboneinfluence;
    struct VMaterial material;
    struct VTriangle triangle;
    struct VVertex vertex;
    struct FVector point;
    unsigned char *buffer;
    FILE *inf, *outf;
    int bEOF, bErr, i;
    INT items;

	/* If in == out, die */
    if(strcmp(in,out) == 0)
    {
    	printf("Error: input and output are the same! You can't do this\n");
        return 1;
    }

	printf("Scanning file `%s', output to `%s'\n",in,out);

    /* Open in */
    inf = fopen(in,"rb");
    if(!inf)
    {
    	printf("Error opening %s for input\n",in);
    	return 1;
    }

    /* Open out */
    outf = fopen(out,"wb");
    if(!outf)
    {
    	printf("Error opening %s for output\n",out);
        fclose(inf);
		return 1;
	}
	bEOF = 0;
	bErr = 0;
	while(!bEOF)
	{
		/* Read header and copy it across */
		items = fread(&header, 1, sizeof(header), inf);
		if(items == 0)
		{
			bEOF = 1;
		}
		else if(items < sizeof(header))
		{
			printf("Warning: unexpected end of file in header!\n");
			bEOF = 1;
			bErr = 1;
		} else {
			items = fwrite(&header,1,sizeof(header),outf);
			if(items<sizeof(header))
			{
				printf("Warning: error writing header!\n");
				bEOF = 1;
				bErr = 1;
			}
			if((strcmp("BONENAMES",header.ChunkID)==0 || strcmp("REFSKELT",header.ChunkID)==0) && header.DataSize==sizeof(bone))
			{
				printf("Found valid bones chunk %s...\n",header.ChunkID);
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
				for(i=0;i<header.DataCount;i++)
				{
					items = fread(&bone,sizeof(bone),1,inf);
					if(items < 1)
					{
						printf("Warning: unexpected end of file in %s chunk!\n",header.ChunkID);
						bEOF = 1;
						bErr = 1;
						break;
					} else {
						/* printf("%s >> ",bone.name);
						strnrep(bone.name,replace,' ',sizeof(bone.name));
						printf("%s\n",bone.name); */
						items = fwrite(&bone,sizeof(bone),1,outf);
						if(items<1)
						{
							printf("Warning: error writing bone!\n");
							bEOF = 1;
							bErr = 1;
						}
					}
				}
			}
			/* --- */
			else if( strcmp("PNTS0000",header.ChunkID)==0 && header.DataSize==sizeof(point))
			{
				printf("Found valid points chunk %s...\n",header.ChunkID);
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
				for(i=0;i<header.DataCount;i++)
				{
					items = fread(&point,sizeof(point),1,inf);
					if(items < 1)
					{
						printf("Warning: unexpected end of file in %s chunk!\n",header.ChunkID);
						bEOF = 1;
						bErr = 1;
						break;
					} else {
						/* do processing here */
						items = fwrite(&point,sizeof(point),1,outf);
						if(items<1)
						{
							printf("Warning: error writing point!\n");
							bEOF = 1;
							bErr = 1;
						}
					}
				}
			}
			else if( strcmp("VTXW0000",header.ChunkID)==0 && header.DataSize==sizeof(vertex))
			{
				printf("Found valid vertex chunk %s...\n",header.ChunkID);
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
				for(i=0;i<header.DataCount;i++)
				{
					items = fread(&vertex,sizeof(vertex),1,inf);
					if(items < 1)
					{
						printf("Warning: unexpected end of file in %s chunk!\n",header.ChunkID);
						bEOF = 1;
						bErr = 1;
						break;
					} else {
						/* do processing here */
						items = fwrite(&vertex,sizeof(vertex),1,outf);
						if(items<1)
						{
							printf("Warning: error writing vertex!\n");
							bEOF = 1;
							bErr = 1;
						}
					}
				}
			}
			else if( strcmp("FACE0000",header.ChunkID)==0 && header.DataSize==sizeof(triangle))
			{
				printf("Found valid triangle chunk %s...\n",header.ChunkID);
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
				for(i=0;i<header.DataCount;i++)
				{
					items = fread(&triangle,sizeof(triangle),1,inf);
					if(items < 1)
					{
						printf("Warning: unexpected end of file in %s chunk!\n",header.ChunkID);
						bEOF = 1;
						bErr = 1;
						break;
					} else {
						/* do processing here */
						items = fwrite(&triangle,sizeof(triangle),1,outf);
						if(items<1)
						{
							printf("Warning: error writing triangle!\n");
							bEOF = 1;
							bErr = 1;
						}
					}
				}
			}
			else if(strcmp("MATT0000",header.ChunkID)==0 && header.DataSize==sizeof(material))
			{
				printf("Found valid material chunk %s...\n",header.ChunkID);
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
				for(i=0;i<header.DataCount;i++)
				{
					items = fread(&material,sizeof(material),1,inf);
					if(items < 1)
					{
						printf("Warning: unexpected end of file in %s chunk!\n",header.ChunkID);
						bEOF = 1;
						bErr = 1;
						break;
					} else {
						printf("%s is texture %d\n",material.MaterialName,material.TextureIndex);
						printf("    PolyFlags %.8X\n",material.PolyFlags);
						printf("    AuxMaterial %d, AuxFlags %.8X\n",material.AuxMaterial,material.AuxFlags);
						printf("    LodBias %d, LodStyle %d\n",material.LodBias,material.LodStyle);
						/* --------- HACK ME ---------------- */
						if(material.TextureIndex == 2)
						{
							printf("  Modifying PolyFlags: Masked attribute...");
							material.PolyFlags = POLY_MASKED;
						}
						if(material.TextureIndex == 1)
						{
							printf("  Modifying PolyFlags: twosided attribute...");
							material.PolyFlags = POLY_TWOS;
						}
						/* -------- end -------------------*/
						items = fwrite(&material,sizeof(material),1,outf);
						if(items<1)
						{
							printf("Warning: error writing material!\n");
							bEOF = 1;
							bErr = 1;
						}
					}
				}
			}
			else if(strcmp("RAWWEIGHTS",header.ChunkID)==0 && header.DataSize==sizeof(rawboneinfluence))
			{
				printf("Found valid raw bone influence chunk %s...\n",header.ChunkID);
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
				for(i=0;i<header.DataCount;i++)
				{
					items = fread(&rawboneinfluence,sizeof(rawboneinfluence),1,inf);
					if(items < 1)
					{
						printf("Warning: unexpected end of file in %s chunk!\n",header.ChunkID);
						bEOF = 1;
						bErr = 1;
						break;
					} else {
						/* do processing here */
						items = fwrite(&rawboneinfluence,sizeof(rawboneinfluence),1,outf);
						if(items<1)
						{
							printf("Warning: error writing raw bone influence!\n");
							bEOF = 1;
							bErr = 1;
						}
					}
				}
			}
			/* --- */
			else if(header.DataSize*header.DataCount>0)
			{
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
			/* If not BONENAMES, malloc() a correctly sized dynamic buffer, read some
			 data and throw it straight into the output file */
				buffer = (char*)malloc((size_t)header.DataSize);
				if(!buffer)
				{
					printf("Error: out of memory! (tried allocating %d bytes)\n",(size_t)header.DataSize);
					bEOF = 1; /* if a malloc() of as little as hundreds of bytes dies, we're in trouble and should quit */
					bErr = 1;
				} else {
					for(i=0;i<header.DataCount;i++)
					{
						items = fread(buffer,header.DataSize,1,inf);
						if(items<1)
						{
							printf("\nWarning: unexpected end of file in %s chunk!\n",header.ChunkID);
							bErr = 1;
							bEOF = 1;
							break;
						}
						items = fwrite(buffer,header.DataSize,1,outf);
						if(items<1)
						{
							printf("\nWarning: error writing data in %s chunk!\n",header.ChunkID);
							bErr = 1;
							bEOF = 1;
							break;
						}
						printf("#");
					}
			/* free() buffer after reading all records */
					free(buffer);
					printf("\n");
				}
			}
			else
			{
				printf("%s chunk contains no data to copy\n",header.ChunkID);
			}
		}
	/* End. */
	}

	fclose(inf);
	fclose(outf);

	return (bErr? 1 : 0);
}

#define PREFIX "hacked_"

int main(int argc, char* argv[])
{
	char *inname, *outname;
	int i;
	if(argc < 2)
	{
		printf("%s",usagestr);
		return 1;
	}
	inname = argv[1];
	outname = (char*)malloc((size_t)(strlen(inname)+strlen(PREFIX)+2));
	strcpy(outname,PREFIX);
	strcat(outname,inname);
	i = process(inname, outname);
	if(i) printf("\nFailed.\n");
	else printf("\nCompleted.\n");
	return i;
}

/* 		 --- 
			else if((strcmp("FOO",header.ChunkID)==0 || strcmp("BAR",header.ChunkID)==0) && header.DataSize==sizeof(foo))
			{
				printf("Found valid foo chunk %s...\n",header.ChunkID);
				printf("Copying data for %s chunk (%d records x %d bytes/record)...\n",header.ChunkID,header.DataCount,header.DataSize);
				for(i=0;i<header.DataCount;i++)
				{
					items = fread(&bone,sizeof(bone),1,inf);
					if(items < 1)
					{
						printf("Warning: unexpected end of file in %s chunk!\n",header.ChunkID);
						bEOF = 1;
						bErr = 1;
						break;
					} else {
						#error do processing here
						items = fwrite(&bone,sizeof(bone),1,outf);
						if(items<1)
						{
							printf("Warning: error writing foo!\n");
							bEOF = 1;
							bErr = 1;
						}
					}
				}
			} */