/* Epic definitions taken from UnSkeletalMesh.h in UT v432 public source */
/* some comments are Epic's, others are mine */

#define INT int
#define DWORD unsigned int
#define ANSICHAR unsigned char
#define FLOAT float
#define _WORD unsigned short
#define BYTE unsigned char

/* A 3D point used in the PNTS0000 chunk */
struct FVector
{
	FLOAT x;
	FLOAT y;
	FLOAT z;
};

/* VTXW0000 chunk
Vertex with texturing info, akin to Hoppe's 'Wedge' concept - import only. */
struct VVertex
{
	_WORD	PointIndex;
	FLOAT   U,V;
	BYTE    MatIndex;
	BYTE    Reserved;
};

/* Textured triangle.
FACE0000 chunk */
struct VTriangle
{
	_WORD   WedgeIndex[3];	 /* point to three vertices in the vertex list. */
	BYTE    MatIndex;	     /* == 0 */
	BYTE    AuxMatIndex;     /* == 127 */
	DWORD   SmoothingGroups; /* 32-bit flag for smoothing groups AND Lod-bias calculation. */
};

/* Quaternion */
struct FQuat
{
	FLOAT x;
	FLOAT y;
	FLOAT z;
	FLOAT w;
};

struct VJointPos
{
	struct FQuat   	Orientation;
	struct FVector		Position;

	FLOAT       Length;
	FLOAT       XSize;
	FLOAT       YSize;
	FLOAT       ZSize;
};

/* Material - MATT0000 chunk */
struct VMaterial
{
	ANSICHAR            MaterialName[64];
	INT					TextureIndex;  /* texture index ('multiskin index') */
	DWORD				PolyFlags;     /* ALL poly's with THIS material will have this flag. */
	INT				    AuxMaterial;   /* reserved: index into another material, eg. detailtexture/shininess/whatever. */
	DWORD				AuxFlags;      /* reserved: auxiliary flags */
	INT					LodBias;       /* material-specific lod bias */
	INT					LodStyle;      /* material-specific lod style */
};

/* Bone - REFSKELT chunk */
struct VBone
{
	ANSICHAR    Name[64];
	DWORD		Flags;
	INT 		NumChildren;
	INT         ParentIndex;
	struct VJointPos	BonePos;
};

/* RAWWEIGHTS
 Raw data bone influence. */
struct VRawBoneInfluence
{
	FLOAT Weight;
	INT   PointIndex;
	INT   BoneIndex;
};

/* Before each chunk */
struct VChunkHeader
{
	ANSICHAR	ChunkID[20];
	INT			TypeFlag;
    INT         DataSize;
	INT         DataCount;
};
