//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// XTMainUtil, The main util contains many often needed function for math,
// physics and vector/rotator stuff...
//=============================================================================
class XTMainUtil expands XTSystem abstract;

const sourcescale=1.0;
const HLSMAX=240;
const RGBMAX=255;
const e=2.718281828;

////-------------------------------////
////=========== GENERAL ===========////
////-------------------------------////

//returns the current local player in a map (SP only !!!!)
static final function playerpawn GetLocalPlayerFor(actor a)
{
	local playerpawn p;

	foreach a.allactors(class'playerpawn',p)
	{
		if(viewport(p.player)!=none)break;
	}
	return p;
} 

//returns the current net player in a map on a server
static final function playerpawn GetNetPlayerFor(actor a)
{
	local playerpawn p;

	foreach a.allactors(class'playerpawn',p)
	{
		if(netconnection(p.player)!=none)break;
	}
	return p;
} 

////---------------------------------------////
////======== DRAWING/VIEW/GRAPHIC =========////
////---------------------------------------////

//returns single color parameters
static final function Color SetColor(byte R, byte G, byte B, optional byte A)
{
	local color c;
	c.r=r;
	c.g=g;
	c.b=b;
	if(a==0)c.a=255;
	else c.a=a;
	return c;
} 

//checks if single color parameters are set
static final function bool ColorIsZero(byte R,byte G,byte B, bool bCheckAlpha,optional byte A)
{
	if (!bcheckalpha)
	{
		if (r==0&&g==0&&b==0)return true;
		else return false;
	}
	else
	{
		if (r==0&&g==0&&b==0&&a==0)return true;
		else return false;	
	}
}
//uwiki (transform any 3D Worldvector into 2D HUD Positions)
static function bool MapToHud(out vector Result,rotator ViewRotation,float FOV,vector TargetDir,Canvas Canvas)
{
	local float TanFOVx,TanFOVy,TanX,TanY,dx,dy;
	local vector X,Y,Dir,XY;
	TanFOVx=Tan(FOV*Pi/360);
	TanFOVy=(Canvas.ClipY/Canvas.ClipX)*TanFOVx;
	GetAxes(ViewRotation,Dir,X,Y);
	Dir*=TargetDir dot Dir;
	XY=TargetDir-Dir;
	dx=XY dot X;
	dy=XY dot Y;
	TanX=dx/VSize(dir);
	TanY=dy/VSize(dir);
	Result.X=Canvas.ClipX*0.5*(1+TanX/TanFOVx);
	Result.Y=Canvas.ClipY*0.5*(1-TanY/ TanFOVy);
	return Dir dot vector(ViewRotation)>0&&Result.X==FClamp(Result.X,Canvas.OrgX, Canvas.ClipX)&&Result.Y==FClamp(Result.Y,Canvas.OrgY,Canvas.ClipY);
}

//converts any given world vector into screen (canvas) X/Y coordinates
static simulated function vector WorldToScreen(Canvas C,vector WorldVector)
{
	local vector CLoc,SLoc;
	local rotator CRot;
	local Actor Cam;
	C.ViewPort.Actor.PlayerCalcView(Cam,CLoc,CRot);
    	MapToHud(SLoc,CRot,C.ViewPort.Actor.FOVAngle,Normal(WorldVector-CLoc),C);
	return SLoc;
}

//converts any given world vector into screen (canvas) X/Y coordinates
static simulated function bool WorldToScreen2(Vector worldvector,pawn dude,vector eyes,rotator rot,float width,float height,out float x,out float y)
{
	local vector relativevector;
	local float Scale;
	relativevector=(worldvector-eyes)<<rot;
	if (relativevector.X<0.01)return false;
	Scale=(width/2)/Tan(dude.fovangle/2/180*Pi);
	X=relativevector.y/relativevector.x*scale+width/2;
	y=-relativevector.z/relativevector.x*scale+height/2;
	return true;
}

//converts any given screen (canvas) X/Y coordinates into a world vector
static simulated function vector ScreenToWorld(actor owner,float X,float Y,float width,float height,int fov,rotator r,float eyeheight,vector location)
{
	local Actor Other;
	local playerpawn p;
	local vector HitLocation,HitNormal,End,Start,Direction;
	Direction.x=1/tan(Fov/2/180*Pi);
	Direction.y=(x-width/2)/(width/2);
	Direction.z=-(y-height/2)/(width/2);
	Direction=Normal(Direction);
	Start=Location;
	Start.Z+=EyeHeight;
	end=Start+(Direction>>r)*1000.0;
	Other=p.Trace(HitLocation,HitNormal,End,Start,true);
	return Other.location;
} 

//uwiki, converting between color systems:
static final simulated function float HueToRGB(float n1, float n2, float hue)
{
    if(hue<0)hue+=HLSMAX;
	if(hue>HLSMAX)hue-=HLSMAX;
	if(hue<(HLSMAX/6))return (n1+(((n2-n1)*hue+(HLSMAX/12))/(HLSMAX/6)));
	if(hue>(HLSMAX/2))return n2;
	if(hue<((HLSMAX*2)/3))return (n1+(((n2-n1)*(((HLSMAX*2)/3)-hue)+(HLSMAX/12))/(HLSMAX/6)));
	else return n1;
}
static final simulated function Color hlstorgb(byte hue, byte lum, byte sat)
{
	local color C;
	local float Magic1,Magic2;
	local int R,G,B;local byte be;
	b=(lum*rgbmax)/hlsmax;
	if (sat==0)C=setcolor(be,be,be);
	else
	{
		if (lum<=(HLSMAX/2))Magic2=(lum*(HLSMAX+sat)+(HLSMAX/2))/HLSMAX;
		else Magic2=lum+sat - ((lum*sat)+(HLSMAX/2))/HLSMAX;
       		Magic1=2*lum-Magic2;
		R=(HueToRGB(Magic1,Magic2,hue+(HLSMAX/3))*RGBMAX+(HLSMAX/2))/HLSMAX;
       		G=(HueToRGB(Magic1,Magic2,hue)*RGBMAX+(HLSMAX/2))/HLSMAX;
		B=(HueToRGB(Magic1,Magic2,hue-(HLSMAX/3))* RGBMAX+(HLSMAX/2))/HLSMAX;
	}
	C=setcolor(R,G,B,255);
	return C;
}
//-----------------------------------------
// controlling and tracing when b is in 
// the fov of a...
// used for the ACanSeeB function
//-----------------------------------------
static function bool ActorIsInViewCosine(vector View,vector Dir,float FOV)
{
	local float CosAngle;
	CosAngle=Normal(View) dot Normal(Dir);
	return (0<=CosAngle&&FOV<CosAngle);
}
static function bool IsActorInFOV(Pawn P,Actor A,optional float FOVCosine)
{
	local rotator InViewRotation;
	if(FOVCosine~=0.0)FOVCosine=P.PeripheralVision;
	if( PlayerPawn(P)!=None )InViewRotation=P.ViewRotation;
	else InViewRotation=P.Rotation;
	return ActorIsInViewCosine( Vector(InViewRotation),A.Location-P.Location,FOVCosine);
}
static function Actor SpecialTrace(Actor A,out vector HitLocation,out vector HitNormal,vector Start,optional bool bTraceActors,optional float TraceInterval,optional vector TraceDirection,optional float TraceLimit,optional vector Extent)
{
	local Actor HitActor;
	local vector End;
	if(TraceInterval~=0.0)TraceInterval=500.0;
	if(TraceLimit!=0&&TraceInterval>TraceLimit)TraceInterval=TraceLimit;
	if(TraceDirection==vect(0,0,0))TraceDirection=vect(0,0,-1);
	else TraceDirection=Normal(TraceDirection);
	End=Start+TraceDirection*TraceInterval;
	HitActor=A.Trace(HitLocation,HitNormal,End,Start,bTraceActors,Extent);
	if(TraceLimit>0.0)
	{
		TraceLimit-=TraceInterval;
		if(TraceLimit<=0.0)return HitActor;
	}
	if(HitActor==None)HitActor=SpecialTrace(A,HitLocation,HitNormal,End,bTraceActors,TraceInterval,TraceDirection,TraceLimit,Extent);
	return HitActor;
}
//---------------------------------------------------------------------------------------------------------------
// - ACanSeeB -
// A function to determine if pawn A sees actor B taking into account the FOV of the pawn, lineofsight and trace
// written because SeenPlayer Function sucks and is too inacurate..
// TraceFrom    = the pawn that sees the actor that has THIS function
// TraceTo      = the actor containing this function and returning true/false if tracefrom sees traceto
// FOVCos       = the FOV of the pawn
// bTraceActors = if true, function takes actors into account while tracing
//---------------------------------------------------------------------------------------------------------------
static function bool ACanSeeB(Pawn TraceFrom,Actor TraceTo, optional float FOVCos, optional bool bTraceActors)
{
	local bool bCanSee;
	local vector StartPoint,EndPoints[3],HitLocation, HitNormal;
    local int i;
	local Actor HitActor;
	if( !IsActorInFOV(TraceFrom,TraceTo,cos(FOVCos)))return false;
	StartPoint=TraceFrom.Location+TraceFrom.BaseEyeHeight*vect(0,0,1);
	EndPoints[0]=TraceTo.Location;
	EndPoints[1]=TraceTo.Location+TraceTo.CollisionHeight*vect(0,0,1);
	EndPoints[2]=TraceTo.Location-TraceTo.CollisionHeight*vect(0,0,1);
	for(i=0;i<ArrayCount(EndPoints);i++)
	{
		HitActor=SpecialTrace(TraceFrom,HitLocation,HitNormal,Startpoint,bTraceActors,,Normal(EndPoints[i]-Startpoint),VSize(EndPoints[i]-Startpoint));
        bCanSee=(HitActor==None||HitActor==TraceTo);
		if(bCanSee)break;
	}
	return bCanSee;
}

//---------------------------------------------------------------------------------------------------------------
// - FullSceneBlend -
// A function to for blending whole screen using the clientfog function, depending on view angle of player and/or
// the radius to the blend effect causing actor
// bRadius    = radius to determine in which area the effect starts
// Owner	  = the actor causing the effect
// vFog		  = the ViewFog of the causing actor when entering radius
// rFog		  = the reversing View Fog when leaving radius
// Radius 	  = radius if bRadius = true
//---------------------------------------------------------------------------------------------------------------
static function FullSceneBlend(bool bradius,actor owner,vector vfog,float blendmult,optional float radius,optional bool bdist)
{
	local float dist,dir;
	local vector x,y,z;
	local playerpawn p;
	p=getlocalplayerfor(owner);
	owner.GetAxes(p.ViewRotation,X,Y,Z);
	dist=GetDistanceBetween(owner.location,p.location);
	dir = vector(p.viewrotation)*(blendmult/dist) dot Normal(owner.Location-p.location)/dist;
	if(bradius)
	{
		if(class'XTPhysicUtil'.static.IsActorInRadius(p.location,owner.location,false,radius))
			p.clientadjustglow(dist+blendmult,vfog*dir);
	}
	else p.clientadjustglow(dist+blendmult,vfog*dir);
}

//draws dynamic coronas on player's screen
static function DrawDynamicCorona(actor owner,canvas canvas)
{
	local float Length,ScaleX,ScaleY;
	local playerpawn p;
	local dynamiccorona l;
	local vector c,v,x,y,z,wts,dist;
	p=getlocalplayerfor(owner);
	ScaleX=Canvas.SizeX/640.0;
	ScaleY=Canvas.SizeY/480.0;
	C.X=Canvas.ClipX/2;
	C.Y=Canvas.ClipY/2;
	owner.GetAxes(p.Rotation,X,Y,Z);
	foreach p.allactors(class'dynamiccorona',l)
	{	
		if(ACanSeeB(p,l,90,!l.bIgnoreActors)&&
class'XTPhysicUtil'.static.IsActorInRadius(p.location,l.location,false,l.distance)&&class'xtmutator'.default.bdynamiccoronas&&l.binternalon)
		{
			dist=GetVectorDistance(l.location,p.location);
			if((Dist Dot X)>0.7&&(l.coronarendertype!=ct_3ddraw))
			{
				wts=WorldToScreen(canvas,l.location);
				v=vect2D(wts.X-C.X,wts.Y-C.Y);
				length=VSize(v);
				v=Normal(v);
				if(l.bModulatedCorona)canvas.Style=4;
				else canvas.style=3;
				//fix: now correct colors!
				canvas.drawcolor=setcolor(l.coronacolor.r,l.coronacolor.g,l.coronacolor.b); 
				canvas.bnosmooth=!l.bfiltercorona;
				if (l.bautocorrectpos)
				{
					if (l.bseperatedscales)
						Canvas.SetPos((v.x*Length)-(l.scale.uscale/2)*ScaleX+C.X,(V.Y*Length)-(l.scale.vscale/2)*ScaleY+C.Y);
					else
						Canvas.SetPos((v.x*Length)-((l.skin.usize*l.scale.mainscale)/2)*ScaleX+C.X,(V.Y*Length)-((l.skin.vsize*l.scale.mainscale)/2)*ScaleY+C.Y);
				}
				else 
					Canvas.SetPos((v.x*Length)-l.posfix.posx*ScaleX+C.X,(V.Y*Length)-l.posfix.posy*ScaleY+C.Y);
				if (l.skin!=none)
				{
					if (l.bseperatedscales)
					{
						if (l.bnonsquaredtile)
							Canvas.DrawTile(l.skin,l.scale.uscale*ScaleX,l.scale.vscale*ScaleY,0.0,0.0,l.skin.usize*l.scale.utile,l.skin.vsize*l.scale.vtile);
						else
							Canvas.DrawTile(l.skin,l.scale.uscale*ScaleX,l.scale.vscale*ScaleY,0.0,0.0,l.skin.usize*l.scale.maintile,l.skin.vsize*l.scale.maintile);
					}
					else 
					{
						if(l.bnonsquaredtile)
							Canvas.DrawTile(l.skin,(l.skin.usize*l.scale.mainscale)*ScaleX,(l.skin.vsize*l.scale.mainscale)*ScaleY,0.0,0.0,l.skin.usize/l.scale.utile,l.skin.vsize/l.scale.utile);
						else
							Canvas.DrawTile(l.skin,(l.scale.uscale*l.scale.mainscale)*ScaleX,(l.scale.vscale*l.scale.mainscale)*ScaleY,0.0,0.0,l.skin.usize/l.scale.maintile,l.skin.vsize/l.scale.maintile);
					}
				}
			}
		}
	}
}

//draws lensflares on player's screen (13.10.07: added single lens seperated color support)
static function DrawLensflares(actor owner,canvas canvas)
{
	local float Length,ScaleX,ScaleY;
	local playerpawn p;
	local lensflareactor l;
	local vector c,v,x,y,z,dist,wts;
	p=Canvas.Viewport.Actor;
	ScaleX=Canvas.SizeX/640.0;
	ScaleY=Canvas.SizeY/480.0;
	C.X=Canvas.ClipX/2;
	C.Y=Canvas.ClipY/2;
	owner.GetAxes(p.Rotation,X,Y,Z);
	foreach p.allactors(class'lensflareactor',l)		//iterator ;>
	{
		dist=GetVectorDistance(l.location,p.location);
		if(ACanSeeB(p,l,90,!l.bIgnoreActors)&&class'XTPhysicUtil'.static.IsActorInRadius(p.location,l.location,false,l.distance)&&class'xtmutator'.default.benablelensflares)
		{
			if((Dist Dot X)>0.7&&p.lineofsightto(l))
			{
				wts=WorldToScreen(canvas,l.location);
				v=vect2D(wts.X-C.X,wts.Y-C.Y);
				length=VSize(v);
				v=Normal(v);
				if(l.bModulatedLensflares)canvas.Style=4;
				else canvas.style=3;
				if (!l.bSeperatedColors&&!ColorIsZero(l.mainlenscolor.r,l.mainlenscolor.g,l.mainlenscolor.b,false))
					canvas.drawcolor=setcolor(l.mainlenscolor.r,l.mainlenscolor.g,l.mainlenscolor.b);
				canvas.bnosmooth=!l.bfilterlensflares;
				Canvas.SetPos((V.X*Length*0.33)-64*ScaleX+C.X,(V.Y*Length*0.33)-64*ScaleY+C.Y);
				Canvas.DrawTile(l.LensFlares[0],l.lflare[0].uscale*ScaleX,l.lflare[0].vscale*ScaleY,0.0,0.0,l.lflare[0].utile,l.lflare[0].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[0].r,l.singlelenscolor[0].g,l.singlelenscolor[0].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[0].r,l.singlelenscolor[0].g,l.singlelenscolor[0].b);
				Canvas.SetPos((V.X*Length)-32*ScaleX+C.X,(V.Y*Length)-32*ScaleY+C.Y);
				Canvas.DrawTile(l.LensFlares[1],l.lflare[1].uscale*ScaleX,l.lflare[1].vscale*ScaleY,0.0,0.0,l.lflare[1].utile,l.lflare[1].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[1].r,l.singlelenscolor[1].g,l.singlelenscolor[1].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[1].r,l.singlelenscolor[1].g,l.singlelenscolor[1].b);
				Canvas.SetPos((V.X*Length*0.66)-64*ScaleX+C.X,(V.Y*Length*0.66)-64*ScaleY+C.Y);
				Canvas.DrawTile(l.LensFlares[1],l.lflare[2].uscale*ScaleX,l.lflare[2].vscale*ScaleY,0.0,0.0,l.lflare[2].utile,l.lflare[2].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[2].r,l.singlelenscolor[2].g,l.singlelenscolor[2].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[2].r,l.singlelenscolor[2].g,l.singlelenscolor[2].b);
				Canvas.SetPos((V.X*Length*1.2)-32*ScaleX+C.X,(V.Y*Length*1.2)-32*ScaleY+C.Y );
				Canvas.DrawTile(l.LensFlares[2],l.lflare[3].uscale*ScaleX,l.lflare[3].vscale*ScaleY,0.0,0.0,l.lflare[3].utile,l.lflare[3].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[3].r,l.singlelenscolor[3].g,l.singlelenscolor[3].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[3].r,l.singlelenscolor[3].g,l.singlelenscolor[3].b);
				Canvas.SetPos((V.x*Length*0.125)-64*ScaleX+C.X,(V.Y*Length*0.125)-64*ScaleY+C.Y );
				Canvas.DrawTile(l.LensFlares[4],l.lflare[4].uscale*ScaleX,l.lflare[4].vscale*ScaleY,0.0,0.0,l.lflare[4].utile,l.lflare[4].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[4].r,l.singlelenscolor[4].g,l.singlelenscolor[4].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[4].r,l.singlelenscolor[4].g,l.singlelenscolor[4].b);
				Canvas.SetPos((V.X*Length*-0.21)-64*ScaleX+C.X, (V.Y*Length*-0.21)-64*ScaleY+C.Y);
				Canvas.DrawTile(l.LensFlares[3],l.lflare[5].uscale*ScaleX,l.lflare[5].vscale*ScaleY,0.0,0.0,l.lflare[5].utile,l.lflare[5].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[5].r,l.singlelenscolor[5].g,l.singlelenscolor[5].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[5].r,l.singlelenscolor[5].g,l.singlelenscolor[5].b);
				Canvas.SetPos((V.X*Length*-0.30)-32*ScaleX+C.X,(V.Y*Length*-0.30)-32*ScaleY+C.Y );
				Canvas.DrawTile(l.LensFlares[4],l.lflare[6].uscale*ScaleX,l.lflare[6].vscale*ScaleY,0.0,0.0,l.lflare[6].utile,l.lflare[6].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[6].r,l.singlelenscolor[6].g,l.singlelenscolor[6].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[6].r,l.singlelenscolor[6].g,l.singlelenscolor[6].b);
				Canvas.SetPos((V.X*Length*-0.5)-90*ScaleX+C.X,(V.Y*Length*-0.5)-90*ScaleY+C.Y );
				Canvas.DrawTile(l.LensFlares[4],l.lflare[7].uscale*ScaleX,l.lflare[7].vscale*ScaleY,0.0,0.0,l.lflare[7].utile,l.lflare[7].vtile);
			if(l.bSeperatedColors&&!ColorIsZero(l.singlelenscolor[7].r,l.singlelenscolor[7].g,l.singlelenscolor[7].b,false))
					canvas.drawcolor=setcolor(l.singlelenscolor[7].r,l.singlelenscolor[7].g,l.singlelenscolor[7].b);
			}
		}
	}
}

//trace and texture functions for the decal projectors:
static function TraceProject(projector p,out vector v,out rotator r)
{
	local int i;
	local Vector HitNormal,HitLocation,End,X;
	X=vector(p.rotation);  //fix me: vectors don't store roll-information of a rotator!
	End=p.Location+p.MaxTraceDistance*X;
	p.Trace(HitLocation,HitNormal,End,p.Location+x,false);
	v=(hitlocation+hitnormal*9)+x;
	r=rotator(p.location-(hitlocation+hitnormal*9)+x);
}
static function SetProjectMaterial(projector p,int i,bool bcontrol)
{
	local vector end,hitlocation,hitnormal,x;
	p.d[i].detachdecal();
	X=vector(p.rotation);  //fix me: vectors don't store roll-information of a rotator!
	End=p.Location+p.MaxTraceDistance*X;
	p.Trace(HitLocation,HitNormal,End,p.Location+vect(0,0,1),false);
	if(bcontrol)p.d[i].texture=p.projectormaterial;
	else p.d[i].texture=none;		//note: may causes long ut.log (AttachDecal: no texture)
	p.d[i].multidecallevel=p.maxprojectablesurfaces;
	p.d[i].drawscale=p.projmaterialsize;
	p.d[i].setlocation((hitlocation+hitnormal*9)+x);
	p.d[i].attachdecal(100,vect(0,0,1));
}

//a traced dynamic projection
static function DynamicProject(dynamicprojector p,float delta)  
{
	local int i;
	local float f;
	local Vector HitNormal,HitLocation,End,X,Y;

	X=vector(p.rotation);  //get the direction from projector, fix me: vectors don't store roll-information of a rotator!
	End=p.Location+p.MaxTraceDistance*x;  //how far is our trace from the projector?
	p.Trace(HitLocation,HitNormal,End,p.location+x,p.bActorsInterruptTrace);  //trace now!
	for(i=0;i<p.brightnesslevel;i++)  //check how much overlayed decals are used
	{
		p.d[i].detachdecal();  //detach it from surface for changings
		p.d[i].multidecallevel=p.maxprojectablesurfaces;
		p.d[i].texture=p.projectormaterial;
		//Scaleing Stuff:
		//the size of this projection grows by time
		if(p.sizemodifier==scale_grow)scale(p.d[i].drawscale,delta,0.0,p.projmaxsize,0.0,p.projgrowtime,true);

		//the size of this projection shrinks by time
		else if(p.sizemodifier==scale_shrink)scale(p.d[i].drawscale,delta,p.projminsize,0.0,p.projshrinktime,0.0,false);

		//the size of this projection depends on the distance from projector to traced surface
		else if(p.sizemodifier==scale_dependsondistance)
		{
			if(p.breverse)
				p.d[i].drawscale=p.projmaterialsize/getdistancebetween(p.location,p.d[i].location,p.distancefactor);
			else p.d[i].drawscale=p.projmaterialsize*getdistancebetween(p.location,p.d[i].location,p.distancefactor);
			p.d[i].drawscale=setlimit(p.d[i].drawscale,p.projminsize,p.projmaxsize,p.breverse);
		}

		//the size of this projection is constantly and normally controlled by projector
		else p.d[i].drawscale=p.projmaterialsize;

		//Switch/Blink Stuff:
		if(p.blinktype==bl_fastflicker)  //fast flickering, kinda like a broken lamp (exactly like LT_Flicker of a light!)
		{
			if(randbool())p.d[i].texture=none;			//simply the texture is set and unset by the RandBool() Function
			else p.d[i].texture=p.projectormaterial;
		}
		else if(p.blinktype==bl_blink)  //periodic blinking, for alarm or something
		{
			if(p.bblink)p.d[i].texture=none;           //simply the texture is set and unset by the bool
			else p.d[i].texture=p.projectormaterial;
		}
		//decal rotation around own axes simultaneously like the projector, and re-attach it
		//fix me: dunno why the roll-component doesn't work..
		if(p.badaptrot)		//check up for rotationrate stuff (not (!) rotation or direction!)
		{
			p.d[i].rotationrate=p.rotationrate;
			p.d[i].setphysics(phys_rotating);
			p.d[i].setlocation((hitlocation+hitnormal*9)+x);
			p.d[i].setrotation(rotator(p.location-(hitlocation+hitnormal*9)+x));
			p.d[i].attachdecal(100,vect(0,0,1)+hitnormal+x);  //re-attach it
		}
		//no decal rotation around own axes, and re-attach it
		else
		{
			p.d[i].setlocation((vect(0,0,1)+hitlocation+hitnormal*9)+x);
			p.d[i].attachdecal(100,vect(0,0,1)+hitnormal+x);
		}
	}
}
////--------------------------------------------------------////
////=========== MATH(Vectors,Scaling,Angles etc. ===========////
////--------------------------------------------------------////

// dot product of a with a, instead of finding square of vsize of a vector
static final function float VSizeSq(vector A)
{
	return A dot A;
}

//vsize2d (taking only x/y into count)
static final function float VSize2D(vector A)
{
	return sqrt((a.x*a.x)+(a.y+a.y));
} 

//vsize2d squared
static final function float VSize2DSq(vector A)
{
	return (a.x*a.x)+(a.y*a.y);
} 

//float size of rotator r
static final function float RotSize(rotator r)
{
	local float size;
	size=Max(size,Abs(r.Pitch));
	size=Max(size,Abs(r.Roll));
	size=Max(size,Abs(r.Yaw));
	return size;
} 

//variable vector component access
static final function vector Vect2(float x,float y,float z)
{
	local vector v;
	v.x=x;
	v.y=y;
	v.z=z;
	return v;
} 

//same as Vect2 but ignoring Z component
static final function vector Vect2D(float x,float y)
{
	local vector v;
	v.x=x;
	v.y=y;
	return v;
}

//variable rotator component access
static final function rotator Rot2(int p,int y,int r)
{
	local rotator ro;
	ro.pitch=p;
	ro.yaw=y;
	ro.roll=r;
	return ro;
}

//randomizes internally a float between min/max and the variation
static final function RandAttribute(out float f,float var,float max,float min)
{
	local float half;
	if(f>min&&f<max)
	{
		half=var/2;
		f+=var*FRand()-half;
		if(f<min)f=min;
		else if(f>max)f=max;
	}
}

//add a factor to a base amount until limit is reached
static function int Add(int base,int toadd,int limit)
{
	local int v;
	if(base<limit)v=Min(limit,v+toadd);
	return v;
}

//simply checks weither a float is positive or negative
static function bool FNegative(float f)
{
	if (f>0.0)return true;
	else if (f>=0.0) return false;
}

//sets max/min of f, breverse switches between max/min
static final function float SetLimit(float f,float min,float max,bool breverse)
{
	if(!breverse)
	{
		if(f>=max)f=max;
	}
	else
	{
		if(f<=min)f=min;
	}
	return f;
}

//randomly switches true/false (timer or tick function recommended for implementation)
static function bool RandBool()
{
	local int i;
	i=rand(2);
	if(i==0)return true;
	else return false;
}

//smoothly scales a float between min/max controlled by the timefactor, bgrow controls internally and the start
static function Scale(out float f,float t,float min,float max,float shrinktime,float growtime,bool bgrow)
{
	if (bgrow)
	{
		f+=(t/growtime);
		if (f>=max)f=max;
	}
	else
	{
		f-=(t/shrinktime);
		if (f<=min)f=min;
	}
} 

//periodicly scales a float similar to sin
static function ScalePeriodic(out float f,float t,float min,float max,float shrinktime,float growtime,bool bgrow)
{
	if (bgrow)
	{
		f+=(min*t)/growtime;
		if (f>=max)f=max;
		if (f==max)bgrow=false;
	}
	if (!bgrow)
	{
		f-=(min*t)/shrinktime;
		if (f<=min)f=min;
		if (f==min)bgrow=true;
	}
}

//random float depending on variation
static final function float RandFloat(float f,float var)
{
	return f+frand()*var;
}

//scales a float periodicly (by math formulas (sin,tan etc.),amplitude (max/min), frequency, period (lifetime) and so on)
static function float SetWavyFloat(int mode,float amp,float freq,float l,optional float s1,optional float s2,optional float l1,optional float l2,optional float fc,optional float fc2)
{
	if (mode==0)return sourcescale*(amp+(amp*sin((l*pi)/freq)));
	else if (mode==1)return sourcescale*(amp+(amp*tan((l*pi)/freq)));
	else if (mode==2)return sourcescale*(amp+(amp*cos((l*pi)/freq)));
	else if (mode==3)return sourcescale*(amp+(amp*atan((l*pi)/freq)));
	else if (mode==4)return sourcescale*(amp+(amp*square((l*pi)/freq)));
	else if (mode==5)return sourcescale*(amp+(amp*exp((l*pi)/freq)));
	else if (mode==6)return sourcescale*(amp+(amp*abs((l*pi)/freq)));
	else if (mode==7)return sourcescale*(amp+(amp*loge((l*pi)/freq)));
	else if (mode==8)return sourcescale*(amp+(amp*sqrt((l*pi)/freq)));
	else if (mode==9)return sourcescale*(amp+(amp*smerp((l*pi)/freq,s1/freq,s2/freq)));
	else if (mode==10)return sourcescale*(amp+(amp*lerp((l*pi)/freq,l1/freq,l2/freq)));
	else if (mode==11)return sourcescale*(amp+(amp*fclamp(((l*pi)/freq),(fc/freq),(fc2/freq))));
} 

static final function int GetRandInt(int max)
{
	local int num;
	num=rand(max+1);
	if(rand(2)==1)num=-num;
	return num;
} //extended rand
static function float GetDistanceBetween(vector a,vector b,optional int divfactor,optional bool bstats)
{
	local float moddist,distance;
	distance=vsize(b-a);
	if(divfactor>0)moddist=distance/divfactor;
	if (bstats)
	{
		log("distance between"$a$"and"$b$"="$distance);
		if(divfactor>0)log("mod-distance between"$a$"and"$b$"="$moddist);
	}
	if(divfactor>0)return moddist;
	else return distance;
}
static function vector GetVectorDistance(vector a,vector b)
{
	local float dist;
	Dist=VSize(a-b);
	return (a-b)/Dist;
}

defaultproperties
{
}
