//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// SmokeEmitter, basic emitter class recommended for smoke effects (support
// for bursting and stuff)
//=============================================================================
class SmokeEmitter expands EnvironmentEmitter;

var(Pointers) int ProjBurstIntensity;
var(Pointers) bool bProjBurst;	
var(Pointers) float ConcentrateTime;
var(Pointers) int ConcentrateIntensity;
var(Pointers) int BurstIntensity;
var(Pointers) enum EConcentrateType
{
	CT_ConcentrateToStaticPoint,
	CT_ConcentrateToDynamicPoint,
	CT_ConcentrateToPawn,
	CT_ConcentrateToScriptedPawn,
	CT_ConcentrateToPlayerPawn,
	CT_PushAwayFromStaticPoint,
	CT_PushAwayFromDynamicPoint,
	CT_PushAwayFromPawn,
	CT_PushAwayFromScriptedPawn,
	CT_PushAwayFromPlayerPawn,
	CT_NormalMovement
}ConcentrateType;

function SetPointers()
{
	if (ConcentrateType == ct_concentratetostaticpoint)
	{	
		p.count = 0;
		p.staticpoint();
		p.concentrateintensity = ConcentrateIntensity;
		p.burstintensity = 0;
		p.settimer(ConcentrateTime, true);
	}
	else if (ConcentrateType == ct_pushawayfromstaticpoint)
	{	
		p.count = 0;
		p.staticburstpoint();
		p.burstintensity = burstintensity;
		p.concentrateintensity = 0;
		p.settimer(ConcentrateTime, true);
	}
	else if (ConcentrateType == ct_pushawayfromdynamicpoint)
	{
		p.count = 0;
		p.burstdyn();
		p.burstintensity = burstintensity;
		p.concentrateintensity = 0;
		p.settimer(ConcentrateTime, true);
	}	
	else if (ConcentrateType == ct_concentratetodynamicpoint)
	{
		p.count = 0;p.dynamicpoint();
		p.concentrateintensity = concentrateintensity;
		p.burstintensity = 0;
		p.settimer(ConcentrateTime, true);
	}
	else if (concentratetype == ct_concentratetopawn)
	{
		p.count = 0;
		p.pawnfollow();
		p.concentrateintensity = concentrateintensity;
		p.burstintensity = 0;
		p.settimer(ConcentrateTime, true);
	}
	else if (concentratetype == ct_pushawayfrompawn)
	{
		p.count = 0;
		p.pawnburst();		
		p.concentrateintensity = 0;
		p.burstintensity = burstintensity;
		p.settimer(ConcentrateTime, true);
	}
	else if (concentratetype == ct_normalmovement)
	{
		p.count = 0;
		p.point = none;
		p.point2 = none;
		p.point3 = none;
		p.point4 = none;
		p.pr = none;
		p.p = none;
		p.p2 = none;
		p.burstintensity = 0;
		p.concentrateintensity = 0;
	}
	else if (concentratetype == ct_pushawayfromscriptedpawn)
	{
		p.count = 0;
		p.p = none;
		p.p2 = none;
		p.p5 = None;
		p.p6 = none;
		p.burstintensity = burstintensity;
		p.concentrateintensity = 0;
		p.scriptedpawnburst();
		p.settimer(concentratetime, true);
	}
	else if (concentratetype == ct_concentratetoscriptedpawn)
	{
		p.count = 0;
		p.p3 = none;
		p.p4 = none;
		p.p5 = none;
		p.p6 = none;
		p.burstintensity = 0;
		p.concentrateintensity = concentrateintensity;
		p.scriptedpawnfollow();
		p.settimer(concentratetime, true);
	}
	else if (concentratetype == ct_pushawayfromplayerpawn)
	{
		p.count = 0;
		p.p3 = none;
		p.p4 = none;
		p.p = none;
		p.p2 = none;
		p.p6 = none;
		p.burstintensity = burstintensity;
		p.concentrateintensity = 0;
		p.playerpawnburst();
		p.settimer(concentratetime, true);
	}
	else if (concentratetype == ct_concentratetoplayerpawn)
	{
		p.count = 0;
		p.p3 = none;
		p.p4 = none;
		p.p = none;
		p.p2 = none;
		p.p5 = none;
		p.burstintensity = 0;
		p.concentrateintensity = concentrateintensity;
		p.playerpawnfollow();
		p.settimer(concentratetime, true);
	}
	if (bProjBurst)
	{
		p.count = 0;
		p.projburst();
		p.prburstintensity=projburstintensity;
		p.settimer(ConcentrateTime, true);
	}
}
function getparticleoptions()
{	
	super.getparticleoptions();
	SetPointers();
	
}

defaultproperties
{
     ProjBurstIntensity=-32
     ConcentrateTime=0.500000
     ConcentrateIntensity=8
     burstintensity=-32
     ConcentrateType=CT_NormalMovement
     GlowTextureScaleglow=0.000000
     GlowTexturesize=0.000000
     NearDetailDropRadius=0
     ParticleSprite=Texture'UT99ExtensionPack.SmokeParticles.SmokeParticleLS20'
     RepeatDelay=0.400000
     ParticleLifespan=1.500000
     ParticleSize=0.175000
     NumSetRandTexes=7
     bPclRandomTextures=True
     PclRandomTextures(0)=Texture'UT99ExtensionPack.SmokeParticles.OlRSmoke000'
     PclRandomTextures(1)=Texture'UT99ExtensionPack.SmokeParticles.OlRSmoke010'
     PclRandomTextures(2)=Texture'UT99ExtensionPack.SmokeParticles.OlRSmoke020'
     PclRandomTextures(3)=Texture'UT99ExtensionPack.SmokeParticles.OlRSmoke030'
     PclRandomTextures(4)=Texture'UT99ExtensionPack.SmokeParticles.OlRSmoke040'
     PclRandomTextures(5)=Texture'UT99ExtensionPack.SmokeParticles.OlRSmoke050'
     PclRandomTextures(6)=Texture'UT99ExtensionPack.SmokeParticles.OlRSmoke060'
     Radius=(X=6,Y=6)
     DetailTemplate(0)=0.300000
     DetailTemplate(1)=0.125000
     DetailTemplate(2)=0.065000
     DetailTemplate(3)=0.004000
     DetailTemplate(4)=0.000900
     DetailTemplate(5)=0.000200
     DetailTemplate(6)=0.000010
     bSetDetailByMenu=True
     AllowedFOV=60
     MaximumSpeed=86.000000
     ParticleSpeed=84.000000
     bRandomMovementAcceleration=True
     ParticleSizingGrowTime=1.300000
     ParticleFadeOutTime=1.500000
     ParticleMaxSize=1.300000
     SizeType=ST_Grow
     FadeEffect=FE_FadeOut
     bNoDelete=False
     bStasis=False
     SoundVolume=192
}
