//=============================================================================
// UNREAL: Phoenix Rising
// once used for LSoNP
// - PUBLIC VERSION -
// class by Shadow
// DynParticlePoint, part of the LSoNP/Phoenix Rising ParticleSystem
// like particleconcentratepoint, but dynamicly moving across map
// NOTE : i had to sub-class pawn.uc to get access to the native function
// "moveto" for circling support
//=============================================================================
class DynParticlePoint expands Pawn;
var() int FlyingRadius,VerticalRange;
var() bool bCircleOnly;
var	vector v;

function PreBeginPlay(){Super.PreBeginPlay();v = Location;}

auto state circle
{
	ignores seeplayer, enemynotvisible;
	begin: 
	SetPhysics(PHYS_Flying);
	moving:	
	if (!bCircleOnly)
	{
		Destination = Vrand() * FlyingRadius + v;
		Destination.Z = v.Z + Rand(VerticalRange);
	}
	else
	{
		destination = VRand()*flyingradius+v;
		destination.z = v.z;
	}
	MoveTo(Destination);
	Goto('moving');
}

function SetVariables(bool battach,float aspeed,int radius,int vertrange,bool bonlyrevolution,float aircontr,float accrate)
{
	if (battach)
	{	
		setphysics(phys_trailer);
		btrailersamerotation=true;
	}
	airspeed=aspeed;
	flyingradius=radius;
	verticalrange=vertrange;
	bcircleonly=bonlyrevolution;
	aircontrol=aircontr;
	accelrate=accrate;
}
simulated function bool AdjustHitLocation(out vector HitLocation, vector TraceDir)
{
	local float adjZ, maxZ;
	TraceDir = Normal(TraceDir);	
	HitLocation = HitLocation + 0.4 * CollisionRadius * TraceDir;
	return true;
}

defaultproperties
{
     FlyingRadius=128
     VerticalRange=64
     AirSpeed=512.000000
     AccelRate=1000.000000
     SightRadius=2000.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     Intelligence=BRAINS_NONE
     bHidden=True
     bCanTeleport=False
     bForceStasis=True
     Style=STY_Translucent
     Texture=None
     DrawScale=0.250000
     bGameRelevant=True
     bIsKillGoal=False
     CollisionRadius=10.000000
     CollisionHeight=10.000000
     bCollideWorld=False
     bProjTarget=False
     bFixedRotationDir=True
}
