//===============================================================================
// SkeletalSlith
// A slith that uses skeletal animations
// By AlCapowned
//===============================================================================

class SkeletalSlith extends Slith;
#exec MESH  MODELIMPORT MESH=SkeletalSlithMesh MODELFILE=models\SkeletalSlithMesh.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=SkeletalSlithMesh X=0 Y=0 Z=45 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=SkeletalSlithAnims ANIMFILE=models\SkeletalSlithAnims.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=SkeletalSlithMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=SkeletalSlithMesh ANIM=SkeletalSlithAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Breath STARTFRAME=0 NUMFRAMES=6 RATE=6.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=ChargeUp STARTFRAME=6 NUMFRAMES=14 RATE=16.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=ChargeUp2 STARTFRAME=20 NUMFRAMES=14 RATE=16.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Claw1 STARTFRAME=34 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=Attack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Claw2 STARTFRAME=45 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=Attack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Dead1 STARTFRAME=56 NUMFRAMES=13 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=LTakeHit STARTFRAME=56 NUMFRAMES=1  RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=WTakeHit STARTFRAME=69 NUMFRAMES=1  RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Dead2 STARTFRAME=69 NUMFRAMES=21 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Dive STARTFRAME=90 NUMFRAMES=16 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Falling STARTFRAME=98 NUMFRAMES=1 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=LFighter STARTFRAME=106 NUMFRAMES=1 RATE=15.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=WFighter STARTFRAME=34 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Punch STARTFRAME=106 NUMFRAMES=14 RATE=15.0000 COMPRESS=1.00 GROUP=Attack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Punch2 STARTFRAME=120 NUMFRAMES=14 RATE=15.0000 COMPRESS=1.00 GROUP=Attack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Scratch STARTFRAME=134 NUMFRAMES=20 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Scratch2 STARTFRAME=154 NUMFRAMES=20 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Shoot1 STARTFRAME=174 NUMFRAMES=14 RATE=15.0000 COMPRESS=1.00 GROUP=MovingAttack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Shoot1M STARTFRAME=188 NUMFRAMES=14 RATE=15.0000 COMPRESS=1.00 GROUP=MovingAttack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Shoot2 STARTFRAME=202 NUMFRAMES=14 RATE=15.0000 COMPRESS=1.00 GROUP=MovingAttack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Shoot2M STARTFRAME=216 NUMFRAMES=14 RATE=15.0000 COMPRESS=1.00 GROUP=MovingAttack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Slash STARTFRAME=230 NUMFRAMES=15 RATE=15.0000 COMPRESS=1.00 GROUP=Attack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Slash2 STARTFRAME=245 NUMFRAMES=15 RATE=15.0000 COMPRESS=1.00 GROUP=Attack 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Slick STARTFRAME=260 NUMFRAMES=15 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Slick2 STARTFRAME=275 NUMFRAMES=15 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Slither STARTFRAME=290 NUMFRAMES=15 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Surface STARTFRAME=305 NUMFRAMES=18 RATE=15.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=SkeletalSlithAnims SEQ=Swim STARTFRAME=323 NUMFRAMES=16 RATE=15.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=SkeletalSlithAnims  VERBOSE

#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Claw1 TIME=0.81 FUNCTION=ClawDamageTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Claw2 TIME=0.81 FUNCTION=ClawDamageTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Punch TIME=0.5 FUNCTION=ClawDamageTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Punch2 TIME=0.5 FUNCTION=ClawDamageTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Slash TIME=0.5 FUNCTION=ClawDamageTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Slash2 TIME=0.5 FUNCTION=ClawDamageTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Shoot1 TIME=0.3 FUNCTION=ShootTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Shoot2 TIME=0.3 FUNCTION=ShootTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Shoot1M TIME=0.3 FUNCTION=ShootTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Shoot2M TIME=0.3 FUNCTION=ShootTarget
#exec ANIM NOTIFY ANIM=SkeletalSlithAnims SEQ=Dead1 TIME=0.61 FUNCTION=LandThump


#exec TEXTURE IMPORT NAME=JSSlith1 FILE=MODELS\JSSlith1.PCX GROUP=Skins 
//exec MESHMAP SCALE MESHMAP=SkeletalSlithMesh X=0.24 Y=0.24 Z=0.24
#exec MESHMAP SETTEXTURE MESHMAP=SkeletalSlithMesh NUM=0 TEXTURE=JSSlith1

function PlayWaiting()
{
	local float decision;

	if (Region.Zone.bWaterZone)
	{
		LoopAnim('Swim', 0.2  + 0.3 * FRand());
		return;
	}
	
	decision = FRand();

	if (decision < 0.8)
		LoopAnim('Breath', 0.2 + 0.6 * FRand());
	else if (decision < 0.9)
	{
		PlaySound(Slick, SLOT_Interact);
		LoopAnim('Slick', 0.4 + 0.6 * FRand());
	}
	else if (decision < 0.90)
	{
		PlaySound(Slick, SLOT_Interact);
		LoopAnim('Slick2', 0.4 + 0.6 * FRand());
	}
	else if (decision < 0.95)
	{
		PlaySound(Slick, SLOT_Interact);
		LoopAnim('Scratch2', 0.4 + 0.6 * FRand());
	}
	else
		PlaySound(Scratch, SLOT_Interact);
		LoopAnim('Scratch', 0.4 + 0.6 * FRand());
	
}

function PlayVictoryDance()
{
	local float decision;
	decision = FRand();
	
	if (decision < 0.5)
	{
		PlayAnim('ChargeUp', 0.3, 0.1);
		PlaySound(Charge, SLOT_Interact);
	}
	else if (decision > 0.5)
	{
		PlayAnim('ChargeUp2', 0.3, 0.1);
		PlaySound(Charge, SLOT_Interact);
	}	
			
}

function PlayMeleeAttack()
{
	local float decision;
	
	decision = FRand();
	Acceleration = AccelRate * Normal(Target.Location - Location);
	//log("Start Melee Attack");
	if ( Region.Zone.bWaterZone )
	{
		if (AnimSequence == 'Claw1')
			decision += 0.17;
		else if (AnimSequence == 'Claw2')
			decision -= 0.17; 

		if (decision < 0.5)
			PlayAnim('Claw1');
		else
			PlayAnim('Claw2');
	}
	else
	{
		if (AnimSequence == 'Punch' || AnimSequence == 'Punch2'  )
			decision += 0.17;
		else if (AnimSequence == 'Slash' || AnimSequence == 'Slash2')
			decision -= 0.17; 
		if (decision < 0.5)
		{
			PlayAnim('Punch');
 		}
		else if (decision < 0.25)
		{
			PlayAnim('Punch2');
 		}
		else if (decision > 0.5)
		{
	 		PlayAnim('Slash'); 
	 	}
		else if (decision > 0.6)
		{
	 		PlayAnim('Slash2'); 
	 	}
 	}	
}

function PlayRangedAttack()
{

	local float decision;
	
	decision = FRand();

	if (Region.Zone.bWaterZone)
	{
		if (AnimSequence == 'Shoot2')
			decision += 0.17;
		else if (AnimSequence == 'Shoot2M')
			decision -= 0.17; 

		if (decision < 0.5)
			PlayAnim('Shoot2');
		else
			PlayAnim('Shoot2M');
	}
	else
	{
		if (AnimSequence == 'Shoot1')
			decision += 0.17;
		else if (AnimSequence == 'Shoot1M')
			decision -= 0.17; 
		
		if (decision < 0.5)
			PlayAnim('Shoot1');
		else
			PlayAnim('Shoot1M');
	}
}




defaultproperties
{
    Mesh=SkeletalMesh'SkeletalSlith.SkeletalSlithMesh'
    DrawType=DT_Mesh
    bStatic=False
}

