//=============================================================================
// PrecipitationGenerator.
//=============================================================================
class PrecipitationGenerator expands Actor;

/*=============================================================================
PercipitationGenerator.

PercipitationGenerator Created by Steve Nabors
http://www.planetunreal.com/slick
Feb 2001

This is a PercipitationGenerator actor that will spawn 
random Rain, Snow, or whatever that falls to the ground.  

The coverage area is determined by the radius you give it.
If you give a coverageRadius then the coverage area
will be circular, extending out from the actor the distance
of the CoverageRadius Value.   If you would like to define
a square or rectangular area of coverage then set
CoverageRadius to 0 and specify CoverageX and CoverageY.
If CoverageX and CoverageY are ignored if CoverageRadius
does not equal 0.

Be sure that the horizontal plane that the Rain
Generator is placed is clear of any geometry.  You will
Get errors in your log file if Particles try to spawn
inside geometry or outside the map so be sure to check
the log file while the map is running to make sure everything
is okay.

SpawnWhenLand is a configurable actor that gets spawned
when the particles hit the ground.  This can be a waterring,
Splash, explosion, or whatever you find under effects.  The
percentage is the percent chance for each particle that
they will spawn this effect.  0 means none of them
and 100 means every particle will spawn the effect.
The effect only gets spawned withing a 640 unit radius of
your player so keep this in mind.  Set SpawnWhenLand to None
to disable.

vVelocity is the spawn Velocity of the spawned particles.
A default verticle negative speed is given.  You can
change X,Y,Z as needed.  When in top down view of the
Generator: X is left, -X is Right, Y is Down, and -Y is
Up.  Z is the verticle speed, Z is up and -Z is down.

When playing Online this actor will go to sleep when player
moves out of view of the generator for more that 5 seconds.
Then when the player can be seen by the generator again the
rain will start up.  sometimes this works okay and sometimes
not.  If you are getting wierd results then I suggest making
the generator bAlwaysRelevant = True in the advanced properties.
The will force the Generator to stay on always but can
eat up cpu time if the gererator is producing a large output.
If this is the case then I suggest lowering the intensity of
the generator and turn off the spawned effects.  "Stat Game"
at the console can give you some information about actor's CPU
time in the game.

//=============================================================================*/

var() float ParticleSize; // Draw Scale of spawn sprites
var() byte Intensity; // Intensity from 0 - 255,  0 - 30 is usually acceptable for most computers.  If you have a supercomputer you can try 255, LOL
var() Texture ParticleTexture;
var() ERenderStyle ParticleStyle; // sprite Stye eg> Translucent, Masked, etc.
var() int CoverageRadius; // Use Radius "Circle" by Default unless it equals 0.
var() int CoverageX; // rectangular coverage (Set CoverageRadius to 0 to use)
var() int CoverageY; // rectangular coverage (Set CoverageRadius to 0 to use)
var() class<effects> SpawnWhenLand; // effect to spawn when particle lands
var() int SpawnWhenLandPercentage; // percentage of time to spawn particle 0(never) - 100(Always)
var() float SpawnWhenLandDrawscale; // DrawScale of Spawned effect
var() Vector vVelocity; // Falling Velocity Settings
var() bool bLineOfSiteCheck; // Used to speed up certain type of maps.  When the particle spawns and it doesn't see the local player it will die

// Internal Variables
var PrecipParticle D;
var int ct;
var vector NewLoc;

Replication
{
	Reliable if(bNetInitial && Role == ROLE_Authority)
	bLineOfSiteCheck,
	vVelocity,
	CoverageX,
	CoverageY,
	ParticleSize,
	intensity,
	ParticleTexture,
	ParticleStyle,
	CoverageRadius,
	SpawnWhenLand,
	SpawnWhenLandPercentage,
	SpawnWhenLandDrawscale;
}

simulated function PreBeginPlay()
{
//	Super.PreBeginPlay(); //Impressive - Opps... has been removed
//////////////////////////////////////
//Quote At Epic:
//event PreBeginPlay()
//{
//	Don't call Actor PreBeginPlay()
//}
//////////////////////////////////////

//
	Texture = None;
	if(Level.Netmode != NM_DedicatedServer)
		SetTimer(0.1, True);
	else
		Disable('Timer');
}

simulated function Timer()
{
	for(ct=0; ct < intensity; ct++)
	{
		if(CoverageRadius > 0)
		{
			NewLoc = Location + Vrand() * CoverageRadius;
			NewLoc.z = Location.z;
		}
		else
		{
			NewLoc.x = Location.x + RandRange(-CoverageX, CoverageX);
			NewLoc.y = Location.y + RandRange(-Coveragey, Coveragey);
			NewLoc.z = Location.z;
		}
		d = Spawn(class'PrecipParticle',,,NewLoc);
		if ( d != None ) //Probably not always spawned, right ?
		{
			d.DrawScale = ParticleSize;  
			d.Texture = ParticleTexture;
			d.Style = ParticleStyle;
			d.bLOS = bLineOfSiteCheck;
			d.Velocity=vVelocity + FRand() * (vVelocity * 0.2);
			if(Rand(100) < SpawnWhenlandPercentage && SpawnWhenlandPercentage > 0 && SpawnWhenLand != None)
			{
				d.LSpawn = True;
				d.LSpawnType = SpawnWhenLand;
				d.LSpawnSize = SpawnWhenLandDrawscale;
			}
		} //end of monkey spam
	}
}
// Cya!

defaultproperties
{
     ParticleSize=0.300000
     Intensity=20
     ParticleTexture=Texture'GenFX.LensFlar.DotBlue'
     ParticleStyle=STY_Translucent
     CoverageRadius=512
     SpawnWhenLand=Class'UnrealShare.WaterRing'
     SpawnWhenLandPercentage=25
     SpawnWhenLandDrawscale=0.050000
     vVelocity=(Z=-1500.000000)
     bStasis=True
     RemoteRole=ROLE_SimulatedProxy
     bGameRelevant=True
}
