//=============================================================================
// LightningTrigger.
//
// - causes lightnings and thunders in randomly generated periods
//
// Created by Michael Geisinger
// Copyright (c) 2002 by Michael Geisinger
// Version 1.1 (08Feb2002)
//
// Mail: Sidewinder_GER@hotmail.com (Germany)
// Home: http://sidewinder.de.vu/
//
// Created with UnrealEd2 (436)
//
//=============================================================================
class LightningTrigger expands Triggers;


//-----------------------------------------------------------------------------
// Variables

var()	sound	Thunders[10];		// Thunder sounds
var		int		NumSounds;		// Number of sounds specified

var()	name		LightningEvent;	// Event generated to toggle Triggerlights

var()	float	LightningTime;	// How long the lightning should be shown

var()	float	MinTime;			// Minimal time between lightnings
var()	float	MaxTime;			// Maximal time between lightnings

var()	float	MinFastTime;		// Minimal time between lightnings at a time
var()	float	MaxFastTime;		// Maximal time between lightnings at a time

var()	int		MinLightnings;	// Minimal number of lightnings at a time
var()	int		MaxLightnings;	// Maximal number of lightnings at a time

var		int		ToShow;			// How many lightnings should be shown
var		int		Shown;			// How many lightnings have been shown yet
var		int		Num;				// Internal

var()	bool		MultipleThunder;	// Multiple thunders per series?
var		bool		Thundered;		// Has there been a thunder recently?


//-----------------------------------------------------------------------------
// Functions

function Trigger( actor Other, pawn EventInstigator )
{
	local float f;
	local int i;
	
	Instigator = EventInstigator;	
	
	// Calculate the number of sounds
	NumSounds = ArrayCount(Thunders);
	for (i=0; i<=ArrayCount(Thunders); i++) 
	{
		if (Thunders[i] == None) 
		{
			NumSounds = i;
			break;
		}
	}
	
	// Swap values if necessary
	if (MinTime > MaxTime)
	{
		Log("[LightningTrigger] Swapping MinTime and MaxTime");
		f = MinTime;
		MinTime = MaxTime;
		MaxTime = f;
	}
	
	if (MinFastTime > MaxFastTime)
	{
		Log("[LightningTrigger] Swapping MinFastTime and MaxFastTime");
		f = MinFastTime;
		MinFastTime = MaxFastTime;
		MaxFastTime = f;
	}
		
	if (MinLightnings > MaxLightnings)
	{
		Log("[LightningTrigger] Swapping MinThunders and MaxThunders");
		i = MinLightnings;
		MinLightnings = MaxLightnings;
		MaxLightnings = i;
	}
	
	ToShow = 0;
	Shown = 0;
	
	GoToState('Dispatch');	
}

function TriggerActors()
{
	if (LightningEvent != '')
		foreach AllActors( class 'Actor', Target, LightningEvent )
			Target.Trigger( Self, Instigator );
}

function PlayThunder()
{
	local PlayerPawn PP;

	foreach AllActors( class 'PlayerPawn', PP )
		if (PP.bIsPlayer == true)
			PP.ClientPlaySound(Thunders[Num]);
}

//-----------------------------------------------------------------------------
// States

state Dispatch
{
Begin:
	Disable('Trigger');
	
	while (true)
	{	
		Sleep(FRand()*(MaxTime-MinTime) + MinTime);
		
		Thundered = false;
		
		ToShow = Rand(MaxLightnings+1-MinLightnings) + MinLightnings;	
		for ( Shown=0; Shown<=ToShow; Shown++ )
		{
			Num = Rand(NumSounds)+1;
			
			TriggerActors();
			if (Thunders[Num] != None)
				if (!Thundered)
				{
					PlayThunder();
					Thundered = true;
				}
				else
				{
					If (MultipleThunder)
					{
						PlayThunder();
						Thundered = true;
					}
				}
			Sleep(LightningTime);
			TriggerActors();
			
			Sleep( FRand()*(MaxFastTime-MinFastTime) + MinFastTime );		
		}
	}
	
	Enable('Trigger');
}

// THE END
//
// Copyright (c) 2002 by Michael Geisinger
//-----------------------------------------------------------------------------

defaultproperties
{
     Thunders(0)=Sound'AmbOutside.OneShot.lightn11'
     Thunders(1)=Sound'AmbOutside.OneShot.lightn11'
     Thunders(2)=Sound'AmbOutside.OneShot.lightn1a'
     Thunders(3)=Sound'AmbOutside.OneShot.lightn2a'
     Thunders(4)=Sound'AmbOutside.OneShot.lightn4a'
     Thunders(5)=Sound'AmbOutside.OneShot.lightn4a'
     LightningTime=0.050000
     MinTime=5.000000
     MaxTime=15.000000
     MaxFastTime=0.200000
     MinLightnings=1
     MaxLightnings=3
}
