class DestroyableDice extends Decoration;

// This is the import example for the big white dice that can be destroyed
#exec mesh import mesh=BigDice anivfile=Models\BigDice_a.3d datafile=Models\BigDice_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=BigDice x=0 y=0 z=0
#exec mesh sequence mesh=BigDice seq=All startframe=0 numframes=1
#exec mesh sequence mesh=BigDice seq=Still  startframe=0   numframes=1

#exec TEXTURE IMPORT NAME=BKDice1  FILE=Textures\BKDice1.pcx
#exec TEXTURE IMPORT NAME=BKDice2  FILE=Textures\BKDice2.pcx
#exec TEXTURE IMPORT NAME=BKDice3  FILE=Textures\BKDice3.pcx
#exec TEXTURE IMPORT NAME=BKDice4  FILE=Textures\BKDice4.pcx
#exec TEXTURE IMPORT NAME=BKDice5  FILE=Textures\BKDice5.pcx
#exec TEXTURE IMPORT NAME=BKDice6  FILE=Textures\BKDice6.pcx

#exec meshmap scale meshmap=BigDice x=0.25000 y=0.25000 z=0.50000
#exec meshmap settexture meshmap=BigDice NUM=0 TEXTURE=BKDice1
#exec meshmap settexture meshmap=BigDice NUM=1 TEXTURE=BKDice2
#exec meshmap settexture meshmap=BigDice NUM=2 TEXTURE=BKDice3
#exec meshmap settexture meshmap=BigDice NUM=3 TEXTURE=BKDice4
#exec meshmap settexture meshmap=BigDice NUM=4 TEXTURE=BKDice5
#exec meshmap settexture meshmap=BigDice NUM=5 TEXTURE=BKDice6

var() int Health;
var() int FragChunks;
var() Float Fragsize;

function PreBeginPlay()
{
   if ( Buoyancy == Default.Buoyancy)
      Buoyancy = Mass * (0.9 + 0.6 * FRand());

   Super.PreBeginPlay();
}

Auto State Animate
{

   function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation,Vector momentum, name damageType)
   {
      Instigator = InstigatedBy;
      if (Health<0) Return;
      if ( Instigator != None )
         MakeNoise(1.0);
      bBobbing = false;
      Health -= NDamage;
      if (Health <0)
         Frag(Class'DiceFragments',Momentum,FragSize,FragChunks);
      else
      {
         SetPhysics(PHYS_Falling);
         Momentum.Z = 1000;
         Velocity=Momentum*0.016;
      }
   }
}

defaultproperties
{
   Health=200
   FragChunks=20
   Fragsize=0.25000
   bPushable=True
   PushSound=Sound'UnrealShare.General.ObjectPush'
   EndPushSound=Sound'UnrealShare.General.Endpush'
   bStatic=False
   DrawType=DT_Mesh
   Mesh=Mesh'BigDice'
	CollisionRadius=64.00000
  	CollisionHeight=64.00000
   bCollideActors=True
   bCollideWorld=True
   bBlockActors=True
   bBlockPlayers=True
   Mass=50.000000
}